/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import soot.util.MultiMap;

public class ConcurrentHashMultiMap<K, V>
implements MultiMap<K, V> {
    Map<K, Map<V, V>> m = new ConcurrentHashMap<K, Map<V, V>>(0);

    public ConcurrentHashMultiMap() {
    }

    public ConcurrentHashMultiMap(MultiMap<K, V> m) {
        this.putAll(m);
    }

    @Override
    public void putAll(MultiMap<K, V> m) {
        for (K key2 : m.keySet()) {
            this.putAll(key2, m.get(key2));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.numKeys() == 0;
    }

    @Override
    public int numKeys() {
        return this.m.size();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.m.containsKey(key2);
    }

    @Override
    public boolean containsValue(V value2) {
        for (Map<V, V> s2 : this.m.values()) {
            if (!s2.containsKey(value2)) continue;
            return true;
        }
        return false;
    }

    protected Map<V, V> newSet() {
        return new ConcurrentHashMap();
    }

    private Map<V, V> findSet(K key2) {
        Map<V, V> s2 = this.m.get(key2);
        if (s2 == null) {
            s2 = this.newSet();
            this.m.put(key2, s2);
        }
        return s2;
    }

    @Override
    public boolean put(K key2, V value2) {
        return this.findSet(key2).put(value2, value2) == null;
    }

    @Override
    public boolean putAll(K key2, Set<V> values2) {
        if (values2.isEmpty()) {
            return false;
        }
        Map<V, V> set2 = this.findSet(key2);
        boolean ok = false;
        for (V v : values2) {
            if (set2.put(v, v) != null) continue;
            ok = true;
        }
        return ok;
    }

    @Override
    public boolean remove(K key2, V value2) {
        boolean ret;
        Map<V, V> s2 = this.m.get(key2);
        if (s2 == null) {
            return false;
        }
        boolean bl = ret = s2.remove(value2) != null;
        if (s2.isEmpty()) {
            this.m.remove(key2);
        }
        return ret;
    }

    @Override
    public boolean remove(K key2) {
        return null != this.m.remove(key2);
    }

    @Override
    public boolean removeAll(K key2, Set<V> values2) {
        Map<V, V> s2 = this.m.get(key2);
        if (s2 == null) {
            return false;
        }
        boolean ret = false;
        for (V v : values2) {
            if (s2.remove(v) == null) continue;
            ret = true;
        }
        if (s2.isEmpty()) {
            this.m.remove(key2);
        }
        return ret;
    }

    @Override
    public Set<V> get(K o) {
        Map<V, V> ret = this.m.get(o);
        if (ret == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret.keySet());
    }

    @Override
    public Set<K> keySet() {
        return this.m.keySet();
    }

    @Override
    public Set<V> values() {
        HashSet<V> ret = new HashSet<V>(this.m.size());
        for (Map<V, V> s2 : this.m.values()) {
            ret.addAll(s2.keySet());
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof MultiMap)) {
            return false;
        }
        MultiMap mm = (MultiMap)o;
        if (!this.keySet().equals(mm.keySet())) {
            return false;
        }
        for (Map.Entry<K, Map<V, V>> e : this.m.entrySet()) {
            Map<V, V> s2 = e.getValue();
            if (s2.equals(mm.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.m.hashCode();
    }

    @Override
    public int size() {
        return this.m.size();
    }
}

