/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import soot.Body;
import soot.G;
import soot.SootMethod;
import soot.Unit;
import soot.UnitBox;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.util.Chain;

public abstract class UnitGraph
implements DirectedGraph<Unit> {
    protected List<Unit> heads;
    protected List<Unit> tails;
    protected Map<Unit, List<Unit>> unitToSuccs;
    protected Map<Unit, List<Unit>> unitToPreds;
    protected SootMethod method;
    protected Body body;
    protected Chain<Unit> unitChain;

    protected UnitGraph(Body body) {
        this.body = body;
        this.unitChain = body.getUnits();
        this.method = body.getMethod();
        if (Options.v().verbose()) {
            G.v().out.println("[" + this.method.getName() + "]     Constructing " + this.getClass().getName() + "...");
        }
    }

    protected void buildUnexceptionalEdges(Map<Unit, List<Unit>> unitToSuccs, Map<Unit, List<Unit>> unitToPreds) {
        Unit nextUnit;
        for (Unit u : this.unitChain) {
            unitToPreds.put(u, new ArrayList());
        }
        Iterator<Unit> unitIt = this.unitChain.iterator();
        Unit unit = nextUnit = unitIt.hasNext() ? unitIt.next() : null;
        while (nextUnit != null) {
            Unit currentUnit = nextUnit;
            nextUnit = unitIt.hasNext() ? unitIt.next() : null;
            ArrayList<Unit> successors = new ArrayList<Unit>();
            if (currentUnit.fallsThrough() && nextUnit != null) {
                successors.add(nextUnit);
                unitToPreds.get(nextUnit).add(currentUnit);
            }
            if (currentUnit.branches()) {
                for (UnitBox targetBox : currentUnit.getUnitBoxes()) {
                    Unit target = targetBox.getUnit();
                    if (successors.contains(target)) continue;
                    successors.add(target);
                    List<Unit> preds = unitToPreds.get(target);
                    if (preds == null) {
                        throw new RuntimeException("Unit graph contains jump to non-existing target");
                    }
                    preds.add(currentUnit);
                }
            }
            unitToSuccs.put(currentUnit, successors);
        }
    }

    protected void buildHeadsAndTails() {
        Unit entryPoint;
        ArrayList<Unit> tailList = new ArrayList<Unit>();
        ArrayList<Unit> headList = new ArrayList<Unit>();
        for (Unit s2 : this.unitChain) {
            List<Unit> preds;
            List<Unit> succs = this.unitToSuccs.get(s2);
            if (succs.isEmpty()) {
                tailList.add(s2);
            }
            if (!(preds = this.unitToPreds.get(s2)).isEmpty()) continue;
            headList.add(s2);
        }
        if (!this.unitChain.isEmpty() && !headList.contains(entryPoint = this.unitChain.getFirst())) {
            headList.add(entryPoint);
        }
        this.tails = Collections.unmodifiableList(tailList);
        this.heads = Collections.unmodifiableList(headList);
    }

    protected static void makeMappedListsUnmodifiable(Map<?, List<Unit>> map2) {
        for (Map.Entry<?, List<Unit>> entry2 : map2.entrySet()) {
            List<Unit> value2 = entry2.getValue();
            if (value2.size() == 0) {
                entry2.setValue(Collections.emptyList());
                continue;
            }
            entry2.setValue(Collections.unmodifiableList(value2));
        }
    }

    protected Map<Unit, List<Unit>> combineMapValues(Map<Unit, List<Unit>> mapA, Map<Unit, List<Unit>> mapB) {
        HashMap<Unit, List<Unit>> result2 = new HashMap<Unit, List<Unit>>(mapA.size() * 2 + 1, 0.7f);
        for (Unit unit : this.unitChain) {
            int resultSize;
            List<Unit> listB;
            List<Unit> listA = mapA.get(unit);
            if (listA == null) {
                listA = Collections.emptyList();
            }
            if ((listB = mapB.get(unit)) == null) {
                listB = Collections.emptyList();
            }
            if ((resultSize = listA.size() + listB.size()) == 0) {
                result2.put(unit, Collections.emptyList());
                continue;
            }
            ArrayList<Unit> resultList = new ArrayList<Unit>(resultSize);
            List<Unit> list = null;
            if (listA.size() >= listB.size()) {
                resultList.addAll(listA);
                list = listB;
            } else {
                resultList.addAll(listB);
                list = listA;
            }
            for (Unit element2 : list) {
                if (resultList.contains(element2)) continue;
                resultList.add(element2);
            }
            result2.put(unit, Collections.unmodifiableList(resultList));
        }
        return result2;
    }

    protected void addEdge(Map<Unit, List<Unit>> unitToSuccs, Map<Unit, List<Unit>> unitToPreds, Unit head2, Unit tail) {
        List<Unit> headsSuccs = unitToSuccs.get(head2);
        if (headsSuccs == null) {
            headsSuccs = new ArrayList<Unit>(3);
            unitToSuccs.put(head2, headsSuccs);
        }
        if (!headsSuccs.contains(tail)) {
            headsSuccs.add(tail);
            List<Unit> tailsPreds = unitToPreds.get(tail);
            if (tailsPreds == null) {
                tailsPreds = new ArrayList<Unit>();
                unitToPreds.put(tail, tailsPreds);
            }
            tailsPreds.add(head2);
        }
    }

    public Body getBody() {
        return this.body;
    }

    public List<Unit> getExtendedBasicBlockPathBetween(Unit from2, Unit to2) {
        UnitGraph g = this;
        if (g.getPredsOf(to2).size() > 1) {
            return null;
        }
        LinkedList<Unit> pathStack = new LinkedList<Unit>();
        LinkedList<Integer> pathStackIndex = new LinkedList<Integer>();
        pathStack.add(from2);
        pathStackIndex.add(new Integer(0));
        int psiMax = g.getSuccsOf((Unit)pathStack.get(0)).size();
        int level = 0;
        while ((Integer)pathStackIndex.get(0) != psiMax) {
            List<Unit> succs;
            int p = (Integer)pathStackIndex.get(level);
            if (p >= (succs = g.getSuccsOf((Unit)pathStack.get(level))).size()) {
                pathStack.remove(level);
                pathStackIndex.remove(level);
                int q = (Integer)pathStackIndex.get(--level);
                pathStackIndex.set(level, new Integer(q + 1));
                continue;
            }
            Unit betweenUnit = succs.get(p);
            if (betweenUnit == to2) {
                pathStack.add(to2);
                return pathStack;
            }
            if (g.getPredsOf(betweenUnit).size() > 1) {
                pathStackIndex.set(level, new Integer(p + 1));
                continue;
            }
            ++level;
            pathStackIndex.add(new Integer(0));
            pathStack.add(betweenUnit);
        }
        return null;
    }

    @Override
    public List<Unit> getHeads() {
        return this.heads;
    }

    @Override
    public List<Unit> getTails() {
        return this.tails;
    }

    @Override
    public List<Unit> getPredsOf(Unit u) {
        List<Unit> l = this.unitToPreds.get(u);
        if (l == null) {
            throw new NoSuchElementException("Invalid unit " + u);
        }
        return l;
    }

    @Override
    public List<Unit> getSuccsOf(Unit u) {
        List<Unit> l = this.unitToSuccs.get(u);
        if (l == null) {
            throw new NoSuchElementException("Invalid unit " + u);
        }
        return l;
    }

    @Override
    public int size() {
        return this.unitChain.size();
    }

    @Override
    public Iterator<Unit> iterator() {
        return this.unitChain.iterator();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Unit u : this.unitChain) {
            buf.append("// preds: ").append(this.getPredsOf(u)).append('\n');
            buf.append(u).append('\n');
            buf.append("// succs ").append(this.getSuccsOf(u)).append('\n');
        }
        return buf.toString();
    }
}

