/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.exceptions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.BodyTransformer;
import soot.Unit;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.toolkits.graph.UnitGraph;

public abstract class TrapTransformer
extends BodyTransformer {
    public Set<Unit> getUnitsWithMonitor(UnitGraph ug) {
        HashSet<Unit> unitsWithMonitor = new HashSet<Unit>();
        for (Unit head2 : ug.getHeads()) {
            ArrayList<Unit> workList = new ArrayList<Unit>();
            workList.add(head2);
            HashSet<Unit> doneSet = new HashSet<Unit>();
            while (!workList.isEmpty()) {
                Unit curUnit = (Unit)workList.remove(0);
                if (!doneSet.add(curUnit)) continue;
                workList.addAll(ug.getSuccsOf(curUnit));
                if (curUnit instanceof EnterMonitorStmt) {
                    unitsWithMonitor.add(curUnit);
                    continue;
                }
                if (curUnit instanceof ExitMonitorStmt) continue;
                for (Unit pred : ug.getPredsOf(curUnit)) {
                    if (!unitsWithMonitor.contains(pred)) continue;
                    unitsWithMonitor.add(curUnit);
                }
            }
        }
        Iterator it = unitsWithMonitor.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof EnterMonitorStmt)) continue;
            it.remove();
        }
        return unitsWithMonitor;
    }
}

