/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.tagkit.AttributeValueException;
import soot.tagkit.InnerClassTag;
import soot.tagkit.Tag;

public class InnerClassAttribute
implements Tag {
    private ArrayList<InnerClassTag> list = null;

    public InnerClassAttribute() {
    }

    public InnerClassAttribute(ArrayList<InnerClassTag> list) {
        this.list = list;
    }

    public String getClassSpecs() {
        if (this.list == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (InnerClassTag ict : this.list) {
            sb.append(".inner_class_spec_attr ");
            sb.append(ict.getInnerClass());
            sb.append(" ");
            sb.append(ict.getOuterClass());
            sb.append(" ");
            sb.append(ict.getShortName());
            sb.append(" ");
            sb.append(ict.getAccessFlags());
            sb.append(" ");
            sb.append(".end .inner_class_spec_attr ");
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return "InnerClassAttribute";
    }

    @Override
    public byte[] getValue() throws AttributeValueException {
        return new byte[1];
    }

    public List<InnerClassTag> getSpecs() {
        return this.list == null ? Collections.emptyList() : this.list;
    }

    public void add(InnerClassTag newt) {
        if (this.list != null) {
            String new_inner = newt.getInnerClass();
            for (InnerClassTag ict : this.list) {
                String inner2 = ict.getInnerClass();
                if (!new_inner.equals(inner2)) continue;
                if (ict.accessFlags != 0 && newt.accessFlags > 0 && ict.accessFlags != newt.accessFlags) {
                    throw new RuntimeException("Error: trying to add an InnerClassTag twice with different access flags! (" + ict.accessFlags + " and " + newt.accessFlags + ")");
                }
                if (ict.accessFlags == 0 && newt.accessFlags != 0) {
                    this.list.remove(ict);
                    this.list.add(newt);
                }
                return;
            }
        }
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.add(newt);
    }
}

