/*
 * Decompiled with CFR 0.152.
 */
package soot.sootify;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import soot.PatchingChain;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.BreakpointStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeStmt;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NopStmt;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.StmtSwitch;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.sootify.TemplatePrinter;
import soot.sootify.ValueTemplatePrinter;

class StmtTemplatePrinter
implements StmtSwitch {
    private final TemplatePrinter p;
    private final ValueTemplatePrinter vtp;
    private List<Unit> jumpTargets = new ArrayList<Unit>();

    public StmtTemplatePrinter(TemplatePrinter templatePrinter, PatchingChain<Unit> units) {
        this.p = templatePrinter;
        this.vtp = new ValueTemplatePrinter(this.p);
        for (Unit u : units) {
            for (UnitBox ub : u.getUnitBoxes()) {
                this.jumpTargets.add(ub.getUnit());
            }
        }
        final ArrayList<Unit> unitsList = new ArrayList<Unit>(units);
        Collections.sort(this.jumpTargets, new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                return unitsList.indexOf(o1) - unitsList.indexOf(o2);
            }
        });
        for (int i = 0; i < this.jumpTargets.size(); ++i) {
            this.p.println("NopStmt jumpTarget" + i + "= Jimple.v().newNopStmt();");
        }
    }

    private String nameOfJumpTarget(Unit u) {
        if (!this.isJumpTarget(u)) {
            throw new InternalError("not a jumpt target! " + u);
        }
        return "jumpTarget" + this.jumpTargets.indexOf(u);
    }

    private boolean isJumpTarget(Unit u) {
        return this.jumpTargets.contains(u);
    }

    private String printValueAssignment(Value value2, String varName) {
        return this.vtp.printValueAssignment(value2, varName);
    }

    private void printStmt(Unit u, String ... ops) {
        String stmtClassName = u.getClass().getSimpleName();
        if (stmtClassName.charAt(0) == 'J') {
            stmtClassName = stmtClassName.substring(1);
        }
        if (this.isJumpTarget(u)) {
            String nameOfJumpTarget = this.nameOfJumpTarget(u);
            this.p.println("units.add(" + nameOfJumpTarget + ");");
        }
        this.p.print("units.add(");
        this.printFactoryMethodCall(stmtClassName, ops);
        this.p.printlnNoIndent(");");
    }

    private void printFactoryMethodCall(String stmtClassName, String ... ops) {
        this.p.printNoIndent("Jimple.v().new");
        this.p.printNoIndent(stmtClassName);
        this.p.printNoIndent("(");
        int i = 1;
        for (String op : ops) {
            this.p.printNoIndent(op);
            if (i < ops.length) {
                this.p.printNoIndent(",");
            }
            ++i;
        }
        this.p.printNoIndent(")");
    }

    @Override
    public void caseThrowStmt(ThrowStmt stmt) {
        String varName = this.printValueAssignment(stmt.getOp(), "op");
        this.printStmt(stmt, varName);
    }

    @Override
    public void caseTableSwitchStmt(TableSwitchStmt stmt) {
        this.p.openBlock();
        String varName = this.printValueAssignment(stmt.getKey(), "key");
        int lowIndex = stmt.getLowIndex();
        this.p.println("int lowIndex=" + lowIndex + ";");
        int highIndex = stmt.getHighIndex();
        this.p.println("int highIndex=" + highIndex + ";");
        this.p.println("List<Unit> targets = new LinkedList<Unit>();");
        for (Unit s2 : stmt.getTargets()) {
            String nameOfJumpTarget = this.nameOfJumpTarget(s2);
            this.p.println("targets.add(" + nameOfJumpTarget + ")");
        }
        Unit defaultTarget = stmt.getDefaultTarget();
        this.p.println("Unit defaultTarget = " + this.nameOfJumpTarget(defaultTarget) + ";");
        this.printStmt(stmt, varName, "lowIndex", "highIndex", "targets", "defaultTarget");
        this.p.closeBlock();
    }

    @Override
    public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
        this.printStmt(stmt, new String[0]);
    }

    @Override
    public void caseReturnStmt(ReturnStmt stmt) {
        String varName = this.printValueAssignment(stmt.getOp(), "retVal");
        this.printStmt(stmt, varName);
    }

    @Override
    public void caseRetStmt(RetStmt stmt) {
        String varName = this.printValueAssignment(stmt.getStmtAddress(), "stmtAddress");
        this.printStmt(stmt, varName);
    }

    @Override
    public void caseNopStmt(NopStmt stmt) {
        this.printStmt(stmt, new String[0]);
    }

    @Override
    public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
        this.p.openBlock();
        String keyVarName = this.printValueAssignment(stmt.getKey(), "key");
        this.p.println("List<IntConstant> lookupValues = new LinkedList<IntConstant>();");
        int i = 0;
        for (IntConstant c : stmt.getLookupValues()) {
            this.vtp.suggestVariableName("lookupValue" + i);
            c.apply(this.vtp);
            this.p.println("lookupValues.add(lookupValue" + ++i + ");");
        }
        this.p.println("List<Unit> targets = new LinkedList<Unit>();");
        for (Unit u : stmt.getTargets()) {
            String nameOfJumpTarget = this.nameOfJumpTarget(u);
            this.p.println("targets.add(" + nameOfJumpTarget + ")");
        }
        Unit defaultTarget = stmt.getDefaultTarget();
        this.p.println("Unit defaultTarget=" + defaultTarget.toString() + ";");
        this.printStmt(stmt, keyVarName, "lookupValues", "targets", "defaultTarget");
        this.p.closeBlock();
    }

    @Override
    public void caseInvokeStmt(InvokeStmt stmt) {
        String varName = this.printValueAssignment(stmt.getInvokeExpr(), "ie");
        this.printStmt(stmt, varName);
    }

    @Override
    public void caseIfStmt(IfStmt stmt) {
        String varName = this.printValueAssignment(stmt.getCondition(), "condition");
        Stmt target = stmt.getTarget();
        this.vtp.suggestVariableName("target");
        String targetName = this.vtp.getLastAssignedVarName();
        this.p.println("Unit " + targetName + "=" + this.nameOfJumpTarget(target) + ";");
        this.printStmt(stmt, varName, targetName);
    }

    @Override
    public void caseIdentityStmt(IdentityStmt stmt) {
        String varName = this.printValueAssignment(stmt.getLeftOp(), "lhs");
        String varName2 = this.printValueAssignment(stmt.getRightOp(), "idRef");
        this.printStmt(stmt, varName, varName2);
    }

    @Override
    public void caseGotoStmt(GotoStmt stmt) {
        Unit target = stmt.getTarget();
        this.vtp.suggestVariableName("target");
        String targetName = this.vtp.getLastAssignedVarName();
        this.p.println("Unit " + targetName + "=" + this.nameOfJumpTarget(target) + ";");
        this.printStmt(stmt, targetName);
    }

    @Override
    public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
        String varName = this.printValueAssignment(stmt.getOp(), "monitor");
        this.printStmt(stmt, varName);
    }

    @Override
    public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
        String varName = this.printValueAssignment(stmt.getOp(), "monitor");
        this.printStmt(stmt, varName);
    }

    @Override
    public void caseBreakpointStmt(BreakpointStmt stmt) {
        this.printStmt(stmt, new String[0]);
    }

    @Override
    public void caseAssignStmt(AssignStmt stmt) {
        String varName = this.printValueAssignment(stmt.getLeftOp(), "lhs");
        String varName2 = this.printValueAssignment(stmt.getRightOp(), "rhs");
        this.printStmt(stmt, varName, varName2);
    }

    @Override
    public void defaultCase(Object obj) {
        throw new InternalError("should never be called");
    }
}

