/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.shimple.toolkits.scalar.SEvaluator;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardBranchedFlowAnalysis;
import soot.toolkits.scalar.Pair;
import soot.util.Chain;

class SCPFAnalysis
extends ForwardBranchedFlowAnalysis {
    protected FlowSet emptySet = new ArraySparseSet();
    protected Map<Local, Constant> localToConstant;
    protected Map<Stmt, GotoStmt> stmtToReplacement = new HashMap<Stmt, GotoStmt>();
    protected List<IfStmt> deadStmts = new ArrayList<IfStmt>();

    public Map<Local, Constant> getResults() {
        return this.localToConstant;
    }

    public List<IfStmt> getDeadStmts() {
        return this.deadStmts;
    }

    public Map<Stmt, GotoStmt> getStmtsToReplace() {
        return this.stmtToReplacement;
    }

    public SCPFAnalysis(UnitGraph graph) {
        super(graph);
        Chain<Local> locals = graph.getBody().getLocals();
        Iterator localsIt = locals.iterator();
        this.localToConstant = new HashMap<Local, Constant>(graph.size() * 2 + 1, 0.7f);
        while (localsIt.hasNext()) {
            Local local = (Local)localsIt.next();
            this.localToConstant.put(local, SEvaluator.TopConstant.v());
        }
        this.doAnalysis();
    }

    @Override
    protected boolean treatTrapHandlersAsEntries() {
        return true;
    }

    @Override
    protected Object entryInitialFlow() {
        FlowSet<Constant> entrySet = this.emptySet.emptySet();
        entrySet.add(SEvaluator.TopConstant.v());
        return entrySet;
    }

    @Override
    protected Object newInitialFlow() {
        return this.emptySet.emptySet();
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        FlowSet fin1 = (FlowSet)in1;
        FlowSet fin2 = (FlowSet)in2;
        FlowSet fout = (FlowSet)out;
        fin1.union(fin2, fout);
    }

    @Override
    protected void copy(Object source, Object dest) {
        FlowSet fource = (FlowSet)source;
        FlowSet fest = (FlowSet)dest;
        fource.copy(fest);
    }

    @Override
    protected void flowThrough(Object in, Unit s2, List fallOut, List branchOuts) {
        Constant keyC;
        Value keyV;
        GotoStmt gotoStmt;
        FlowSet<Pair> fin = ((FlowSet)in).clone();
        if (fin.isEmpty()) {
            return;
        }
        Pair pair = this.processDefinitionStmt(s2);
        if (pair != null) {
            fin.add(pair);
        }
        if (!s2.branches() && s2.fallsThrough()) {
            for (FlowSet fallSet : fallOut) {
                fallSet.union(fin);
            }
            return;
        }
        boolean conservative = true;
        boolean fall = false;
        boolean branch = false;
        FlowSet oneBranch = null;
        if (s2 instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)s2;
            Value cond = ifStmt.getCondition();
            Constant constant = SEvaluator.getFuzzyConstantValueOf(cond, this.localToConstant);
            if (constant instanceof SEvaluator.BottomConstant) {
                this.deadStmts.remove(ifStmt);
                this.stmtToReplacement.remove(ifStmt);
            } else {
                if (constant instanceof SEvaluator.TopConstant) {
                    return;
                }
                conservative = false;
                IntConstant trueC = IntConstant.v(1);
                IntConstant falseC = IntConstant.v(0);
                if (constant.equals(trueC)) {
                    branch = true;
                    gotoStmt = Jimple.v().newGotoStmt(ifStmt.getTargetBox());
                    this.stmtToReplacement.put(ifStmt, gotoStmt);
                }
                if (constant.equals(falseC)) {
                    fall = true;
                    this.deadStmts.add(ifStmt);
                }
            }
        }
        if (s2 instanceof TableSwitchStmt) {
            TableSwitchStmt table = (TableSwitchStmt)s2;
            keyV = table.getKey();
            keyC = SEvaluator.getFuzzyConstantValueOf(keyV, this.localToConstant);
            if (keyC instanceof SEvaluator.BottomConstant) {
                this.stmtToReplacement.remove(table);
            } else {
                if (keyC instanceof SEvaluator.TopConstant) {
                    return;
                }
                if (keyC instanceof IntConstant) {
                    conservative = false;
                    int key2 = ((IntConstant)keyC).value;
                    int low = table.getLowIndex();
                    int high = table.getHighIndex();
                    int index = key2 - low;
                    UnitBox branchBox = null;
                    branchBox = index < 0 || index > high ? table.getDefaultTargetBox() : table.getTargetBox(index);
                    GotoStmt gotoStmt2 = Jimple.v().newGotoStmt(branchBox);
                    this.stmtToReplacement.put(table, gotoStmt2);
                    List<UnitBox> unitBoxes = table.getUnitBoxes();
                    int setIndex = unitBoxes.indexOf(branchBox);
                    oneBranch = (FlowSet)branchOuts.get(setIndex);
                }
            }
        }
        if (s2 instanceof LookupSwitchStmt) {
            LookupSwitchStmt lookup = (LookupSwitchStmt)s2;
            keyV = lookup.getKey();
            keyC = SEvaluator.getFuzzyConstantValueOf(keyV, this.localToConstant);
            if (keyC instanceof SEvaluator.BottomConstant) {
                this.stmtToReplacement.remove(lookup);
            } else {
                if (keyC instanceof SEvaluator.TopConstant) {
                    return;
                }
                if (keyC instanceof IntConstant) {
                    conservative = false;
                    int index = lookup.getLookupValues().indexOf(keyC);
                    UnitBox branchBox = null;
                    branchBox = index == -1 ? lookup.getDefaultTargetBox() : lookup.getTargetBox(index);
                    gotoStmt = Jimple.v().newGotoStmt(branchBox);
                    this.stmtToReplacement.put(lookup, gotoStmt);
                    List<UnitBox> unitBoxes = lookup.getUnitBoxes();
                    int setIndex = unitBoxes.indexOf(branchBox);
                    oneBranch = (FlowSet)branchOuts.get(setIndex);
                }
            }
        }
        if (conservative) {
            fall = s2.fallsThrough();
            branch = s2.branches();
        }
        if (fall) {
            for (FlowSet fallSet : fallOut) {
                fallSet.union(fin);
            }
        }
        if (branch) {
            for (FlowSet branchSet : branchOuts) {
                branchSet.union(fin);
            }
        }
        if (oneBranch != null) {
            oneBranch.union(fin);
        }
    }

    protected Pair processDefinitionStmt(Unit u) {
        if (!(u instanceof DefinitionStmt)) {
            return null;
        }
        DefinitionStmt dStmt = (DefinitionStmt)u;
        Value value2 = dStmt.getLeftOp();
        if (!(value2 instanceof Local)) {
            return null;
        }
        Local local = (Local)value2;
        Value rightOp = dStmt.getRightOp();
        Constant constant = SEvaluator.getFuzzyConstantValueOf(rightOp, this.localToConstant);
        if (!this.merge(local, constant)) {
            return null;
        }
        return new Pair<Unit, Constant>(u, this.localToConstant.get(local));
    }

    protected boolean merge(Local local, Constant constant) {
        Constant current = this.localToConstant.get(local);
        if (current instanceof SEvaluator.BottomConstant) {
            return false;
        }
        if (current instanceof SEvaluator.TopConstant) {
            this.localToConstant.put(local, constant);
            return true;
        }
        if (current.equals(constant)) {
            return false;
        }
        this.localToConstant.put(local, SEvaluator.BottomConstant.v());
        return true;
    }
}

