/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.toolkits.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.toolkits.graph.GlobalValueNumberer;
import soot.shimple.toolkits.graph.ValueGraph;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.graph.CompleteBlockGraph;

public class SimpleGlobalValueNumberer
implements GlobalValueNumberer {
    protected BlockGraph cfg;
    protected ValueGraph vg;
    protected Set<Partition> partitions;
    protected Map<ValueGraph.Node, Partition> nodeToPartition;
    protected int currentPartitionNumber;
    protected List<Partition> newPartitions;

    public SimpleGlobalValueNumberer(BlockGraph cfg) {
        this.cfg = cfg;
        this.vg = new ValueGraph(cfg);
        this.partitions = new HashSet<Partition>();
        this.nodeToPartition = new HashMap<ValueGraph.Node, Partition>();
        this.currentPartitionNumber = 0;
        this.initPartition();
        this.iterPartition();
    }

    public static void main(String[] args) {
        Scene.v().loadClassAndSupport(args[0]);
        SootClass sc = Scene.v().getSootClass(args[0]);
        SootMethod sm = sc.getMethod(args[1]);
        Body b = sm.retrieveActiveBody();
        ShimpleBody sb = Shimple.v().newBody(b);
        CompleteBlockGraph cfg = new CompleteBlockGraph(sb);
        SimpleGlobalValueNumberer sgvn = new SimpleGlobalValueNumberer(cfg);
        System.out.println(sgvn);
    }

    @Override
    public int getGlobalValueNumber(Local local) {
        ValueGraph.Node node = this.vg.getNode(local);
        return this.nodeToPartition.get(node).getPartitionNumber();
    }

    @Override
    public boolean areEqual(Local local1, Local local2) {
        ValueGraph.Node node1 = this.vg.getNode(local1);
        ValueGraph.Node node2 = this.vg.getNode(local2);
        return this.nodeToPartition.get(node1) == this.nodeToPartition.get(node2);
    }

    protected void initPartition() {
        HashMap<String, Partition> labelToPartition = new HashMap<String, Partition>();
        for (ValueGraph.Node node : this.vg.getTopNodes()) {
            String label = node.getLabel();
            Partition partition2 = (Partition)labelToPartition.get(label);
            if (partition2 == null) {
                partition2 = new Partition();
                this.partitions.add(partition2);
                labelToPartition.put(label, partition2);
            }
            partition2.add(node);
            this.nodeToPartition.put(node, partition2);
        }
    }

    protected void iterPartition() {
        this.newPartitions = new ArrayList<Partition>();
        for (Partition partition2 : this.partitions) {
            this.processPartition(partition2);
        }
        this.partitions.addAll(this.newPartitions);
    }

    protected void processPartition(Partition partition2) {
        int size2 = partition2.size();
        if (size2 == 0) {
            return;
        }
        ValueGraph.Node firstNode = (ValueGraph.Node)partition2.get(0);
        Partition newPartition = new Partition();
        boolean processNewPartition = false;
        for (int i = 1; i < size2; ++i) {
            ValueGraph.Node node = (ValueGraph.Node)partition2.get(i);
            if (this.childrenAreInSamePartition(firstNode, node)) continue;
            partition2.remove(i);
            --size2;
            newPartition.add(node);
            this.newPartitions.add(newPartition);
            this.nodeToPartition.put(node, newPartition);
            processNewPartition = true;
        }
        if (processNewPartition) {
            this.processPartition(newPartition);
        }
    }

    protected boolean childrenAreInSamePartition(ValueGraph.Node node1, ValueGraph.Node node2) {
        boolean ordered = node1.isOrdered();
        if (ordered != node2.isOrdered()) {
            throw new RuntimeException("Assertion failed.");
        }
        List<ValueGraph.Node> children1 = node1.getChildren();
        List<ValueGraph.Node> children2 = node2.getChildren();
        int numberOfChildren = children1.size();
        if (children2.size() != numberOfChildren) {
            return false;
        }
        if (ordered) {
            for (int i = 0; i < numberOfChildren; ++i) {
                ValueGraph.Node child1 = children1.get(i);
                ValueGraph.Node child2 = children2.get(i);
                if (this.nodeToPartition.get(child1) == this.nodeToPartition.get(child2)) continue;
                return false;
            }
        } else {
            block1: for (int i = 0; i < numberOfChildren; ++i) {
                ValueGraph.Node child1 = children1.get(i);
                for (int j = i; j < numberOfChildren; ++j) {
                    ValueGraph.Node child2 = children2.get(j);
                    if (this.nodeToPartition.get(child1) == this.nodeToPartition.get(child2)) {
                        if (j == i) continue block1;
                        children2.remove(j);
                        children2.add(i, child2);
                        continue block1;
                    }
                    if (j + 1 != numberOfChildren) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        Body b = this.cfg.getBody();
        for (Local local : b.getLocals()) {
            tmp.append(local + "\t" + this.getGlobalValueNumber(local) + "\n");
        }
        return tmp.toString();
    }

    protected class Partition
    extends ArrayList {
        protected int partitionNumber;

        protected Partition() {
            this.partitionNumber = SimpleGlobalValueNumberer.this.currentPartitionNumber++;
        }

        protected int getPartitionNumber() {
            return this.partitionNumber;
        }
    }
}

