/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import soot.G;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.internal.JimpleLocal;
import soot.jimple.toolkits.base.Aggregator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.jimple.toolkits.scalar.UnconditionalBranchFolder;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.options.ShimpleOptions;
import soot.shimple.PhiExpr;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.ShimpleFactory;
import soot.shimple.internal.PhiNodeManager;
import soot.shimple.internal.PiNodeManager;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.graph.DominatorNode;
import soot.toolkits.graph.DominatorTree;
import soot.toolkits.scalar.UnusedLocalEliminator;
import soot.toolkits.scalar.ValueUnitPair;

public class ShimpleBodyBuilder {
    protected ShimpleBody body;
    protected ShimpleFactory sf;
    protected DominatorTree<Block> dt;
    protected BlockGraph cfg;
    protected List<Local> origLocals;
    public PhiNodeManager phi;
    public PiNodeManager pi;
    ShimpleOptions options;
    protected Map<String, Local> newLocals;
    protected Map<Local, Local> newLocalsToOldLocal;
    protected int[] assignmentCounters;
    protected Stack<Integer>[] namingStacks;

    public ShimpleBodyBuilder(ShimpleBody body) {
        this.body = body;
        this.sf = G.v().shimpleFactory;
        this.sf.setBody(body);
        this.sf.clearCache();
        this.phi = new PhiNodeManager(body);
        this.pi = new PiNodeManager(body, false);
        this.options = body.getOptions();
        this.makeUniqueLocalNames();
    }

    public void update() {
        this.cfg = this.sf.getBlockGraph();
        this.dt = this.sf.getDominatorTree();
        this.origLocals = new ArrayList<Local>(this.body.getLocals());
    }

    public void transform() {
        this.phi.insertTrivialPhiNodes();
        boolean change = false;
        if (this.options.extended()) {
            change = this.pi.insertTrivialPiNodes();
            while (change && this.phi.insertTrivialPhiNodes()) {
                change = this.pi.insertTrivialPiNodes();
            }
        }
        this.renameLocals();
        this.phi.trimExceptionalPhiNodes();
        this.makeUniqueLocalNames();
    }

    public void preElimOpt() {
    }

    public void postElimOpt() {
        boolean optElim = this.options.node_elim_opt();
        if (optElim) {
            DeadAssignmentEliminator.v().transform(this.body);
            UnreachableCodeEliminator.v().transform(this.body);
            UnconditionalBranchFolder.v().transform(this.body);
            Aggregator.v().transform(this.body);
            UnusedLocalEliminator.v().transform(this.body);
        }
    }

    public void eliminatePhiNodes() {
        if (this.phi.doEliminatePhiNodes()) {
            this.makeUniqueLocalNames();
        }
    }

    public void eliminatePiNodes() {
        boolean optElim = this.options.node_elim_opt();
        this.pi.eliminatePiNodes(optElim);
    }

    public void renameLocals() {
        this.update();
        this.newLocals = new HashMap<String, Local>();
        this.newLocalsToOldLocal = new HashMap<Local, Local>();
        this.assignmentCounters = new int[this.origLocals.size()];
        this.namingStacks = new Stack[this.origLocals.size()];
        for (int i = 0; i < this.namingStacks.length; ++i) {
            this.namingStacks[i] = new Stack();
        }
        List<Block> heads2 = this.cfg.getHeads();
        if (heads2.isEmpty()) {
            return;
        }
        if (heads2.size() != 1) {
            throw new RuntimeException("Assertion failed:  Only one head expected.");
        }
        Block entry2 = heads2.get(0);
        this.renameLocalsSearch(entry2);
    }

    public void renameLocalsSearch(Block block) {
        ArrayList<Local> lhsLocals = new ArrayList<Local>();
        for (Unit unit : block) {
            Object defStmt;
            Value lhsValue;
            int localIndex;
            ArrayList<ValueBox> useBoxes = new ArrayList<ValueBox>();
            if (!Shimple.isPhiNode(unit)) {
                useBoxes.addAll(unit.getUseBoxes());
            }
            for (ValueBox useBox : useBoxes) {
                Value use = useBox.getValue();
                localIndex = this.indexOfLocal(use);
                if (localIndex == -1) continue;
                Local localUse = (Local)use;
                if (this.namingStacks[localIndex].empty()) continue;
                Integer subscript = this.namingStacks[localIndex].peek();
                Local renamedLocal = this.fetchNewLocal(localUse, subscript);
                useBox.setValue(renamedLocal);
            }
            if (!(unit instanceof DefinitionStmt) || !this.origLocals.contains(lhsValue = (defStmt = (DefinitionStmt)unit).getLeftOp())) continue;
            ValueBox lhsLocalBox = defStmt.getLeftOpBox();
            Local lhsLocal = (Local)lhsValue;
            lhsLocals.add(lhsLocal);
            localIndex = this.indexOfLocal(lhsLocal);
            if (localIndex == -1) {
                throw new RuntimeException("Assertion failed.");
            }
            Integer subscript = this.assignmentCounters[localIndex];
            Local newLhsLocal = this.fetchNewLocal(lhsLocal, subscript);
            lhsLocalBox.setValue(newLhsLocal);
            this.namingStacks[localIndex].push(subscript);
            int n = localIndex;
            this.assignmentCounters[n] = this.assignmentCounters[n] + 1;
        }
        for (Block succ : this.cfg.getSuccsOf(block)) {
            if (block.getHead() == null && block.getTail() == null) continue;
            for (Unit unit : succ) {
                PhiExpr phiExpr = Shimple.getPhiExpr(unit);
                if (phiExpr == null) continue;
                int argIndex = phiExpr.getArgIndex(block);
                if (argIndex == -1) {
                    throw new RuntimeException("Assertion failed.");
                }
                ValueUnitPair phiArgBox = phiExpr.getArgBox(argIndex);
                Local phiArg = (Local)phiArgBox.getValue();
                int localIndex = this.indexOfLocal(phiArg);
                if (localIndex == -1) {
                    throw new RuntimeException("Assertion failed.");
                }
                if (this.namingStacks[localIndex].empty()) continue;
                Integer subscript = this.namingStacks[localIndex].peek();
                Local newPhiArg = this.fetchNewLocal(phiArg, subscript);
                phiArgBox.setValue(newPhiArg);
            }
        }
        DominatorNode<Block> node = this.dt.getDode(block);
        for (DominatorNode<Block> childNode : this.dt.getChildrenOf(node)) {
            this.renameLocalsSearch(childNode.getGode());
        }
        for (Local lhsLocal : lhsLocals) {
            int lhsLocalIndex = this.indexOfLocal(lhsLocal);
            if (lhsLocalIndex == -1) {
                throw new RuntimeException("Assertion failed.");
            }
            this.namingStacks[lhsLocalIndex].pop();
        }
    }

    protected Local fetchNewLocal(Local local, Integer subscript) {
        Local oldLocal = local;
        if (!this.origLocals.contains(local)) {
            oldLocal = this.newLocalsToOldLocal.get(local);
        }
        if (subscript == 0) {
            return oldLocal;
        }
        String name = oldLocal.getName() + "_" + subscript;
        Local newLocal = this.newLocals.get(name);
        if (newLocal == null) {
            newLocal = new JimpleLocal(name, oldLocal.getType());
            this.newLocals.put(name, newLocal);
            this.newLocalsToOldLocal.put(newLocal, oldLocal);
            this.body.getLocals().add(newLocal);
        }
        return newLocal;
    }

    protected int indexOfLocal(Value local) {
        int localIndex = this.origLocals.indexOf(local);
        if (localIndex == -1) {
            Local oldLocal = this.newLocalsToOldLocal.get(local);
            localIndex = this.origLocals.indexOf(oldLocal);
        }
        return localIndex;
    }

    public void makeUniqueLocalNames() {
        if (this.options.standard_local_names()) {
            LocalNameStandardizer.v().transform(this.body);
            return;
        }
        HashSet<String> localNames = new HashSet<String>();
        for (Local local : this.body.getLocals()) {
            String localName = local.getName();
            if (localNames.contains(localName)) {
                String uniqueName = this.makeUniqueLocalName(localName, localNames);
                local.setName(uniqueName);
                localNames.add(uniqueName);
                continue;
            }
            localNames.add(localName);
        }
    }

    public String makeUniqueLocalName(String dupName, Set<String> localNames) {
        int counter = 1;
        String newName = dupName;
        while (localNames.contains(newName)) {
            newName = dupName + "_" + counter++;
        }
        return newName;
    }
}

