/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.integer;

import java.io.PrintWriter;
import java.io.StringWriter;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.IntType;
import soot.IntegerType;
import soot.Local;
import soot.NullType;
import soot.ShortType;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.ClassConstant;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.ConcreteRef;
import soot.jimple.ConditionExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.RemExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.UshrExpr;
import soot.jimple.XorExpr;
import soot.jimple.internal.JIdentityStmt;
import soot.jimple.toolkits.typing.Util;
import soot.jimple.toolkits.typing.integer.ClassHierarchy;
import soot.jimple.toolkits.typing.integer.TypeException;
import soot.jimple.toolkits.typing.integer.TypeNode;
import soot.jimple.toolkits.typing.integer.TypeResolver;

class ConstraintChecker
extends AbstractStmtSwitch {
    private final TypeResolver resolver;
    private final boolean fix;
    private JimpleBody stmtBody;

    public ConstraintChecker(TypeResolver resolver, boolean fix) {
        this.resolver = resolver;
        this.fix = fix;
    }

    public void check(Stmt stmt, JimpleBody stmtBody) throws TypeException {
        try {
            this.stmtBody = stmtBody;
            stmt.apply(this);
        }
        catch (RuntimeTypeException e) {
            StringWriter st = new StringWriter();
            PrintWriter pw = new PrintWriter(st);
            e.printStackTrace(pw);
            pw.close();
            throw new TypeException(st.toString());
        }
    }

    static void error(String message) {
        throw new RuntimeTypeException(message);
    }

    private void handleInvokeExpr(InvokeExpr ie, Stmt invokestmt) {
        SootMethodRef method = ie.getMethodRef();
        for (int i = 0; i < ie.getArgCount(); ++i) {
            Local local;
            if (!(ie.getArg(i) instanceof Local) || !((local = (Local)ie.getArg(i)).getType() instanceof IntegerType) || ClassHierarchy.v().typeNode(local.getType()).hasAncestor_1(ClassHierarchy.v().typeNode(method.parameterType(i)))) continue;
            if (this.fix) {
                ie.setArg(i, this.insertCast(local, method.parameterType(i), invokestmt));
                continue;
            }
            ConstraintChecker.error("Type Error");
        }
        if (ie instanceof DynamicInvokeExpr) {
            DynamicInvokeExpr die = (DynamicInvokeExpr)ie;
            SootMethodRef bootstrapMethod = die.getBootstrapMethodRef();
            for (int i = 0; i < die.getBootstrapArgCount(); ++i) {
                Local local;
                if (!(die.getBootstrapArg(i) instanceof Local) || !((local = (Local)die.getBootstrapArg(i)).getType() instanceof IntegerType) || ClassHierarchy.v().typeNode(local.getType()).hasAncestor_1(ClassHierarchy.v().typeNode(bootstrapMethod.parameterType(i)))) continue;
                if (this.fix) {
                    die.setArg(i, this.insertCast(local, bootstrapMethod.parameterType(i), invokestmt));
                    continue;
                }
                ConstraintChecker.error("Type Error");
            }
        }
    }

    @Override
    public void caseBreakpointStmt(BreakpointStmt stmt) {
    }

    @Override
    public void caseInvokeStmt(InvokeStmt stmt) {
        this.handleInvokeExpr(stmt.getInvokeExpr(), stmt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void caseAssignStmt(AssignStmt stmt) {
        Value index;
        ArrayType base;
        Type baset;
        ConcreteRef ref;
        Value l = stmt.getLeftOp();
        Value r = stmt.getRightOp();
        TypeNode left = null;
        TypeNode right = null;
        if (l instanceof ArrayRef) {
            ref = (ArrayRef)l;
            baset = ((Local)ref.getBase()).getType();
            if (baset instanceof ArrayType) {
                base = (ArrayType)baset;
                index = ref.getIndex();
                if (base.numDimensions == 1 && base.baseType instanceof IntegerType) {
                    left = ClassHierarchy.v().typeNode(base.baseType);
                }
                if (index instanceof Local && !ClassHierarchy.v().typeNode(((Local)index).getType()).hasAncestor_1(ClassHierarchy.v().INT)) {
                    if (this.fix) {
                        ref.setIndex(this.insertCast((Local)index, IntType.v(), stmt));
                    } else {
                        ConstraintChecker.error("Type Error(5)");
                    }
                }
            }
        } else if (l instanceof Local) {
            if (((Local)l).getType() instanceof IntegerType) {
                left = ClassHierarchy.v().typeNode(((Local)l).getType());
            }
        } else if (l instanceof InstanceFieldRef) {
            ref = (InstanceFieldRef)l;
            if (ref.getFieldRef().type() instanceof IntegerType) {
                left = ClassHierarchy.v().typeNode(ref.getFieldRef().type());
            }
        } else {
            if (!(l instanceof StaticFieldRef)) throw new RuntimeException("Unhandled assignment left hand side type: " + l.getClass());
            ref = (StaticFieldRef)l;
            if (((StaticFieldRef)ref).getFieldRef().type() instanceof IntegerType) {
                left = ClassHierarchy.v().typeNode(((StaticFieldRef)ref).getFieldRef().type());
            }
        }
        if (r instanceof ArrayRef) {
            ref = (ArrayRef)r;
            baset = ((Local)ref.getBase()).getType();
            if (!(baset instanceof NullType)) {
                base = (ArrayType)baset;
                index = ref.getIndex();
                if (base.numDimensions == 1 && base.baseType instanceof IntegerType) {
                    right = ClassHierarchy.v().typeNode(base.baseType);
                }
                if (index instanceof Local && !ClassHierarchy.v().typeNode(((Local)index).getType()).hasAncestor_1(ClassHierarchy.v().INT)) {
                    if (this.fix) {
                        ref.setIndex(this.insertCast((Local)index, IntType.v(), stmt));
                    } else {
                        ConstraintChecker.error("Type Error(6)");
                    }
                }
            }
        } else if (!(r instanceof DoubleConstant) && !(r instanceof FloatConstant)) {
            if (r instanceof IntConstant) {
                int value2 = ((IntConstant)r).value;
                right = value2 < Short.MIN_VALUE ? ClassHierarchy.v().INT : (value2 < -128 ? ClassHierarchy.v().SHORT : (value2 < 0 ? ClassHierarchy.v().BYTE : (value2 < 2 ? ClassHierarchy.v().R0_1 : (value2 < 128 ? ClassHierarchy.v().R0_127 : (value2 < 32768 ? ClassHierarchy.v().R0_32767 : (value2 < 65536 ? ClassHierarchy.v().CHAR : ClassHierarchy.v().INT))))));
            } else if (!(r instanceof LongConstant || r instanceof NullConstant || r instanceof StringConstant || r instanceof ClassConstant)) {
                if (r instanceof BinopExpr) {
                    int value3;
                    BinopExpr be2 = (BinopExpr)r;
                    Value lv = be2.getOp1();
                    Value rv = be2.getOp2();
                    TypeNode lop = null;
                    TypeNode rop = null;
                    if (lv instanceof Local) {
                        if (((Local)lv).getType() instanceof IntegerType) {
                            lop = ClassHierarchy.v().typeNode(((Local)lv).getType());
                        }
                    } else if (!(lv instanceof DoubleConstant) && !(lv instanceof FloatConstant)) {
                        if (lv instanceof IntConstant) {
                            value3 = ((IntConstant)lv).value;
                            lop = value3 < Short.MIN_VALUE ? ClassHierarchy.v().INT : (value3 < -128 ? ClassHierarchy.v().SHORT : (value3 < 0 ? ClassHierarchy.v().BYTE : (value3 < 2 ? ClassHierarchy.v().R0_1 : (value3 < 128 ? ClassHierarchy.v().R0_127 : (value3 < 32768 ? ClassHierarchy.v().R0_32767 : (value3 < 65536 ? ClassHierarchy.v().CHAR : ClassHierarchy.v().INT))))));
                        } else if (!(lv instanceof LongConstant || lv instanceof NullConstant || lv instanceof StringConstant || lv instanceof ClassConstant)) {
                            throw new RuntimeException("Unhandled binary expression left operand type: " + lv.getClass());
                        }
                    }
                    if (rv instanceof Local) {
                        if (((Local)rv).getType() instanceof IntegerType) {
                            rop = ClassHierarchy.v().typeNode(((Local)rv).getType());
                        }
                    } else if (!(rv instanceof DoubleConstant) && !(rv instanceof FloatConstant)) {
                        if (rv instanceof IntConstant) {
                            value3 = ((IntConstant)rv).value;
                            rop = value3 < Short.MIN_VALUE ? ClassHierarchy.v().INT : (value3 < -128 ? ClassHierarchy.v().SHORT : (value3 < 0 ? ClassHierarchy.v().BYTE : (value3 < 2 ? ClassHierarchy.v().R0_1 : (value3 < 128 ? ClassHierarchy.v().R0_127 : (value3 < 32768 ? ClassHierarchy.v().R0_32767 : (value3 < 65536 ? ClassHierarchy.v().CHAR : ClassHierarchy.v().INT))))));
                        } else if (!(rv instanceof LongConstant || rv instanceof NullConstant || rv instanceof StringConstant || rv instanceof ClassConstant)) {
                            throw new RuntimeException("Unhandled binary expression right operand type: " + rv.getClass());
                        }
                    }
                    if (be2 instanceof AddExpr || be2 instanceof SubExpr || be2 instanceof MulExpr || be2 instanceof DivExpr || be2 instanceof RemExpr) {
                        if (lop != null && rop != null) {
                            if (!lop.hasAncestor_1(ClassHierarchy.v().INT)) {
                                if (this.fix) {
                                    be2.setOp1(this.insertCast(be2.getOp1(), ConstraintChecker.getTypeForCast(lop), IntType.v(), stmt));
                                } else {
                                    ConstraintChecker.error("Type Error(7)");
                                }
                            }
                            if (!rop.hasAncestor_1(ClassHierarchy.v().INT)) {
                                if (this.fix) {
                                    be2.setOp2(this.insertCast(be2.getOp2(), ConstraintChecker.getTypeForCast(rop), IntType.v(), stmt));
                                } else {
                                    ConstraintChecker.error("Type Error(8)");
                                }
                            }
                        }
                        right = ClassHierarchy.v().INT;
                    } else if (be2 instanceof AndExpr || be2 instanceof OrExpr || be2 instanceof XorExpr) {
                        if (lop != null && rop != null) {
                            TypeNode lca = lop.lca_1(rop);
                            if (lca == ClassHierarchy.v().TOP) {
                                if (this.fix) {
                                    if (!lop.hasAncestor_1(ClassHierarchy.v().INT)) {
                                        be2.setOp1(this.insertCast(be2.getOp1(), ConstraintChecker.getTypeForCast(lop), ConstraintChecker.getTypeForCast(rop), stmt));
                                        lca = rop;
                                    }
                                    if (!rop.hasAncestor_1(ClassHierarchy.v().INT)) {
                                        be2.setOp2(this.insertCast(be2.getOp2(), ConstraintChecker.getTypeForCast(rop), ConstraintChecker.getTypeForCast(lop), stmt));
                                        lca = lop;
                                    }
                                } else {
                                    ConstraintChecker.error("Type Error(11)");
                                }
                            }
                            right = lca;
                        }
                    } else if (be2 instanceof ShlExpr) {
                        if (lop != null && !lop.hasAncestor_1(ClassHierarchy.v().INT)) {
                            if (this.fix) {
                                be2.setOp1(this.insertCast(be2.getOp1(), ConstraintChecker.getTypeForCast(lop), IntType.v(), stmt));
                            } else {
                                ConstraintChecker.error("Type Error(9)");
                            }
                        }
                        if (!rop.hasAncestor_1(ClassHierarchy.v().INT)) {
                            if (this.fix) {
                                be2.setOp2(this.insertCast(be2.getOp2(), ConstraintChecker.getTypeForCast(rop), IntType.v(), stmt));
                            } else {
                                ConstraintChecker.error("Type Error(10)");
                            }
                        }
                        right = lop == null ? null : ClassHierarchy.v().INT;
                    } else if (be2 instanceof ShrExpr || be2 instanceof UshrExpr) {
                        if (lop != null && !lop.hasAncestor_1(ClassHierarchy.v().INT)) {
                            if (this.fix) {
                                be2.setOp1(this.insertCast(be2.getOp1(), ConstraintChecker.getTypeForCast(lop), ByteType.v(), stmt));
                                lop = ClassHierarchy.v().BYTE;
                            } else {
                                ConstraintChecker.error("Type Error(9)");
                            }
                        }
                        if (!rop.hasAncestor_1(ClassHierarchy.v().INT)) {
                            if (this.fix) {
                                be2.setOp2(this.insertCast(be2.getOp2(), ConstraintChecker.getTypeForCast(rop), IntType.v(), stmt));
                            } else {
                                ConstraintChecker.error("Type Error(10)");
                            }
                        }
                        right = lop;
                    } else if (be2 instanceof CmpExpr || be2 instanceof CmpgExpr || be2 instanceof CmplExpr) {
                        right = ClassHierarchy.v().BYTE;
                    } else {
                        TypeNode lca;
                        if (!(be2 instanceof EqExpr) && !(be2 instanceof GeExpr) && !(be2 instanceof GtExpr) && !(be2 instanceof LeExpr) && !(be2 instanceof LtExpr) && !(be2 instanceof NeExpr)) throw new RuntimeException("Unhandled binary expression type: " + be2.getClass());
                        if (rop != null && (lca = lop.lca_1(rop)) == ClassHierarchy.v().TOP) {
                            if (this.fix) {
                                if (!lop.hasAncestor_1(ClassHierarchy.v().INT)) {
                                    be2.setOp1(this.insertCast(be2.getOp1(), ConstraintChecker.getTypeForCast(lop), ConstraintChecker.getTypeForCast(rop), stmt));
                                }
                                if (!rop.hasAncestor_1(ClassHierarchy.v().INT)) {
                                    be2.setOp2(this.insertCast(be2.getOp2(), ConstraintChecker.getTypeForCast(rop), ConstraintChecker.getTypeForCast(lop), stmt));
                                }
                            } else {
                                ConstraintChecker.error("Type Error(11)");
                            }
                        }
                        right = ClassHierarchy.v().BOOLEAN;
                    }
                } else if (r instanceof CastExpr) {
                    CastExpr ce = (CastExpr)r;
                    if (ce.getCastType() instanceof IntegerType) {
                        right = ClassHierarchy.v().typeNode(ce.getCastType());
                    }
                } else if (r instanceof InstanceOfExpr) {
                    right = ClassHierarchy.v().BOOLEAN;
                } else if (r instanceof InvokeExpr) {
                    InvokeExpr ie = (InvokeExpr)r;
                    this.handleInvokeExpr(ie, stmt);
                    if (ie.getMethodRef().returnType() instanceof IntegerType) {
                        right = ClassHierarchy.v().typeNode(ie.getMethodRef().returnType());
                    }
                } else if (r instanceof NewArrayExpr) {
                    NewArrayExpr nae = (NewArrayExpr)r;
                    Value size2 = nae.getSize();
                    if (size2 instanceof Local && !ClassHierarchy.v().typeNode(((Local)size2).getType()).hasAncestor_1(ClassHierarchy.v().INT)) {
                        if (this.fix) {
                            nae.setSize(this.insertCast((Local)size2, IntType.v(), stmt));
                        } else {
                            ConstraintChecker.error("Type Error(12)");
                        }
                    }
                } else if (!(r instanceof NewExpr)) {
                    if (r instanceof NewMultiArrayExpr) {
                        NewMultiArrayExpr nmae = (NewMultiArrayExpr)r;
                        for (int i = 0; i < nmae.getSizeCount(); ++i) {
                            Value size3 = nmae.getSize(i);
                            if (!(size3 instanceof Local) || ClassHierarchy.v().typeNode(((Local)size3).getType()).hasAncestor_1(ClassHierarchy.v().INT)) continue;
                            if (this.fix) {
                                nmae.setSize(i, this.insertCast((Local)size3, IntType.v(), stmt));
                                continue;
                            }
                            ConstraintChecker.error("Type Error(13)");
                        }
                    } else if (r instanceof LengthExpr) {
                        right = ClassHierarchy.v().INT;
                    } else if (r instanceof NegExpr) {
                        NegExpr ne = (NegExpr)r;
                        if (ne.getOp() instanceof Local) {
                            Local local = (Local)ne.getOp();
                            if (local.getType() instanceof IntegerType) {
                                TypeNode ltype = ClassHierarchy.v().typeNode(local.getType());
                                if (!ltype.hasAncestor_1(ClassHierarchy.v().INT)) {
                                    if (this.fix) {
                                        ne.setOp(this.insertCast(local, IntType.v(), stmt));
                                        ltype = ClassHierarchy.v().BYTE;
                                    } else {
                                        ConstraintChecker.error("Type Error(14)");
                                    }
                                }
                                right = ltype == ClassHierarchy.v().CHAR ? ClassHierarchy.v().INT : ltype;
                            }
                        } else if (!(ne.getOp() instanceof DoubleConstant) && !(ne.getOp() instanceof FloatConstant)) {
                            if (ne.getOp() instanceof IntConstant) {
                                right = ClassHierarchy.v().INT;
                            } else if (!(ne.getOp() instanceof LongConstant)) {
                                throw new RuntimeException("Unhandled neg expression operand type: " + ne.getOp().getClass());
                            }
                        }
                    } else if (r instanceof Local) {
                        Local local = (Local)r;
                        if (local.getType() instanceof IntegerType) {
                            right = ClassHierarchy.v().typeNode(local.getType());
                        }
                    } else if (r instanceof InstanceFieldRef) {
                        ref = (InstanceFieldRef)r;
                        if (ref.getFieldRef().type() instanceof IntegerType) {
                            right = ClassHierarchy.v().typeNode(ref.getFieldRef().type());
                        }
                    } else {
                        if (!(r instanceof StaticFieldRef)) throw new RuntimeException("Unhandled assignment right hand side type: " + r.getClass());
                        ref = (StaticFieldRef)r;
                        if (((StaticFieldRef)ref).getFieldRef().type() instanceof IntegerType) {
                            right = ClassHierarchy.v().typeNode(((StaticFieldRef)ref).getFieldRef().type());
                        }
                    }
                }
            }
        }
        if (left == null || right == null || right.hasAncestor_1(left)) return;
        if (this.fix) {
            stmt.setRightOp(this.insertCast(stmt.getRightOp(), ConstraintChecker.getTypeForCast(right), ConstraintChecker.getTypeForCast(left), stmt));
            return;
        } else {
            ConstraintChecker.error("Type Error(15)");
        }
    }

    static Type getTypeForCast(TypeNode node) {
        if (node.type() == null) {
            if (node == ClassHierarchy.v().R0_1) {
                return BooleanType.v();
            }
            if (node == ClassHierarchy.v().R0_127) {
                return ByteType.v();
            }
            if (node == ClassHierarchy.v().R0_32767) {
                return ShortType.v();
            }
        }
        return node.type();
    }

    @Override
    public void caseIdentityStmt(IdentityStmt stmt) {
        Value l = stmt.getLeftOp();
        Value r = stmt.getRightOp();
        if (l instanceof Local && ((Local)l).getType() instanceof IntegerType) {
            TypeNode left = ClassHierarchy.v().typeNode(((Local)l).getType());
            TypeNode right = ClassHierarchy.v().typeNode(r.getType());
            if (!right.hasAncestor_1(left)) {
                if (this.fix) {
                    ((JIdentityStmt)stmt).setLeftOp(this.insertCastAfter((Local)l, ConstraintChecker.getTypeForCast(left), ConstraintChecker.getTypeForCast(right), stmt));
                } else {
                    ConstraintChecker.error("Type Error(16)");
                }
            }
        }
    }

    @Override
    public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
    }

    @Override
    public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
    }

    @Override
    public void caseGotoStmt(GotoStmt stmt) {
    }

    @Override
    public void caseIfStmt(IfStmt stmt) {
        int value2;
        ConditionExpr cond;
        ConditionExpr expr = cond = (ConditionExpr)stmt.getCondition();
        Value lv = expr.getOp1();
        Value rv = expr.getOp2();
        TypeNode lop = null;
        TypeNode rop = null;
        if (lv instanceof Local) {
            if (((Local)lv).getType() instanceof IntegerType) {
                lop = ClassHierarchy.v().typeNode(((Local)lv).getType());
            }
        } else if (!(lv instanceof DoubleConstant) && !(lv instanceof FloatConstant)) {
            if (lv instanceof IntConstant) {
                value2 = ((IntConstant)lv).value;
                lop = value2 < Short.MIN_VALUE ? ClassHierarchy.v().INT : (value2 < -128 ? ClassHierarchy.v().SHORT : (value2 < 0 ? ClassHierarchy.v().BYTE : (value2 < 2 ? ClassHierarchy.v().R0_1 : (value2 < 128 ? ClassHierarchy.v().R0_127 : (value2 < 32768 ? ClassHierarchy.v().R0_32767 : (value2 < 65536 ? ClassHierarchy.v().CHAR : ClassHierarchy.v().INT))))));
            } else if (!(lv instanceof LongConstant || lv instanceof NullConstant || lv instanceof StringConstant || lv instanceof ClassConstant)) {
                throw new RuntimeException("Unhandled binary expression left operand type: " + lv.getClass());
            }
        }
        if (rv instanceof Local) {
            if (((Local)rv).getType() instanceof IntegerType) {
                rop = ClassHierarchy.v().typeNode(((Local)rv).getType());
            }
        } else if (!(rv instanceof DoubleConstant) && !(rv instanceof FloatConstant)) {
            if (rv instanceof IntConstant) {
                value2 = ((IntConstant)rv).value;
                rop = value2 < Short.MIN_VALUE ? ClassHierarchy.v().INT : (value2 < -128 ? ClassHierarchy.v().SHORT : (value2 < 0 ? ClassHierarchy.v().BYTE : (value2 < 2 ? ClassHierarchy.v().R0_1 : (value2 < 128 ? ClassHierarchy.v().R0_127 : (value2 < 32768 ? ClassHierarchy.v().R0_32767 : (value2 < 65536 ? ClassHierarchy.v().CHAR : ClassHierarchy.v().INT))))));
            } else if (!(rv instanceof LongConstant || rv instanceof NullConstant || rv instanceof StringConstant || rv instanceof ClassConstant)) {
                throw new RuntimeException("Unhandled binary expression right operand type: " + rv.getClass());
            }
        }
        if (lop != null && rop != null && lop.lca_1(rop) == ClassHierarchy.v().TOP) {
            if (this.fix) {
                if (!lop.hasAncestor_1(ClassHierarchy.v().INT)) {
                    expr.setOp1(this.insertCast(expr.getOp1(), ConstraintChecker.getTypeForCast(lop), ConstraintChecker.getTypeForCast(rop), stmt));
                }
                if (!rop.hasAncestor_1(ClassHierarchy.v().INT)) {
                    expr.setOp2(this.insertCast(expr.getOp2(), ConstraintChecker.getTypeForCast(rop), ConstraintChecker.getTypeForCast(lop), stmt));
                }
            } else {
                ConstraintChecker.error("Type Error(17)");
            }
        }
    }

    @Override
    public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
        Value key2 = stmt.getKey();
        if (key2 instanceof Local && !ClassHierarchy.v().typeNode(((Local)key2).getType()).hasAncestor_1(ClassHierarchy.v().INT)) {
            if (this.fix) {
                stmt.setKey(this.insertCast((Local)key2, IntType.v(), stmt));
            } else {
                ConstraintChecker.error("Type Error(18)");
            }
        }
    }

    @Override
    public void caseNopStmt(NopStmt stmt) {
    }

    @Override
    public void caseReturnStmt(ReturnStmt stmt) {
        if (stmt.getOp() instanceof Local && ((Local)stmt.getOp()).getType() instanceof IntegerType && !ClassHierarchy.v().typeNode(((Local)stmt.getOp()).getType()).hasAncestor_1(ClassHierarchy.v().typeNode(this.stmtBody.getMethod().getReturnType()))) {
            if (this.fix) {
                stmt.setOp(this.insertCast((Local)stmt.getOp(), this.stmtBody.getMethod().getReturnType(), stmt));
            } else {
                ConstraintChecker.error("Type Error(19)");
            }
        }
    }

    @Override
    public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
    }

    @Override
    public void caseTableSwitchStmt(TableSwitchStmt stmt) {
        Value key2 = stmt.getKey();
        if (key2 instanceof Local) {
            if (!ClassHierarchy.v().typeNode(((Local)key2).getType()).hasAncestor_1(ClassHierarchy.v().INT)) {
                if (this.fix) {
                    stmt.setKey(this.insertCast((Local)key2, IntType.v(), stmt));
                } else {
                    ConstraintChecker.error("Type Error(20)");
                }
            }
            this.resolver.typeVariable((Local)key2).addParent(this.resolver.INT);
        }
    }

    @Override
    public void caseThrowStmt(ThrowStmt stmt) {
    }

    public void defaultCase(Stmt stmt) {
        throw new RuntimeException("Unhandled statement type: " + stmt.getClass());
    }

    private Local insertCast(Local oldlocal, Type type, Stmt stmt) {
        Local newlocal = Jimple.v().newLocal("tmp", type);
        this.stmtBody.getLocals().add(newlocal);
        Unit u = Util.findFirstNonIdentityUnit(this.stmtBody, stmt);
        this.stmtBody.getUnits().insertBefore(Jimple.v().newAssignStmt(newlocal, Jimple.v().newCastExpr(oldlocal, type)), u);
        return newlocal;
    }

    private Local insertCastAfter(Local leftlocal, Type lefttype, Type righttype, Stmt stmt) {
        Local newlocal = Jimple.v().newLocal("tmp", righttype);
        this.stmtBody.getLocals().add(newlocal);
        Unit u = Util.findLastIdentityUnit(this.stmtBody, stmt);
        this.stmtBody.getUnits().insertAfter(Jimple.v().newAssignStmt(leftlocal, Jimple.v().newCastExpr(newlocal, lefttype)), u);
        return newlocal;
    }

    private Local insertCast(Value oldvalue, Type oldtype, Type type, Stmt stmt) {
        Local newlocal1 = Jimple.v().newLocal("tmp", oldtype);
        Local newlocal2 = Jimple.v().newLocal("tmp", type);
        this.stmtBody.getLocals().add(newlocal1);
        this.stmtBody.getLocals().add(newlocal2);
        Unit u = Util.findFirstNonIdentityUnit(this.stmtBody, stmt);
        this.stmtBody.getUnits().insertBefore(Jimple.v().newAssignStmt(newlocal1, oldvalue), u);
        this.stmtBody.getUnits().insertBefore(Jimple.v().newAssignStmt(newlocal2, Jimple.v().newCastExpr(newlocal1, type)), u);
        return newlocal2;
    }

    private static class RuntimeTypeException
    extends RuntimeException {
        RuntimeTypeException(String message) {
            super(message);
        }
    }
}

