/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing;

import java.util.TreeSet;
import soot.ArrayType;
import soot.G;
import soot.RefType;
import soot.jimple.toolkits.typing.InternalTypingException;
import soot.jimple.toolkits.typing.TypeException;
import soot.jimple.toolkits.typing.TypeNode;
import soot.jimple.toolkits.typing.TypeResolverBV;
import soot.options.Options;
import soot.util.BitSetIterator;
import soot.util.BitVector;

@Deprecated
class TypeVariableBV
implements Comparable<Object> {
    private static final boolean DEBUG = false;
    private final int id;
    private final TypeResolverBV resolver;
    private TypeVariableBV rep = this;
    private int rank = 0;
    private TypeNode approx;
    private TypeNode type;
    private TypeVariableBV array;
    private TypeVariableBV element;
    private int depth;
    private BitVector parents = new BitVector();
    private BitVector children = new BitVector();
    private BitVector ancestors;
    private BitVector indirectAncestors;

    public TypeVariableBV(int id, TypeResolverBV resolver) {
        this.id = id;
        this.resolver = resolver;
    }

    public TypeVariableBV(int id, TypeResolverBV resolver, TypeNode type) {
        this.id = id;
        this.resolver = resolver;
        this.type = type;
        this.approx = type;
        for (TypeNode parent : type.parents()) {
            this.addParent(resolver.typeVariable(parent));
        }
        if (type.hasElement()) {
            this.element = resolver.typeVariable(type.element());
            this.element.array = this;
        }
    }

    public int hashCode() {
        if (this.rep != this) {
            return this.ecr().hashCode();
        }
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this.rep != this) {
            return this.ecr().equals(obj);
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        TypeVariableBV ecr = ((TypeVariableBV)obj).ecr();
        return ecr == this;
    }

    @Override
    public int compareTo(Object o) {
        if (this.rep != this) {
            return this.ecr().compareTo(o);
        }
        return this.id - ((TypeVariableBV)o).ecr().id;
    }

    private TypeVariableBV ecr() {
        if (this.rep != this) {
            this.rep = this.rep.ecr();
        }
        return this.rep;
    }

    public TypeVariableBV union(TypeVariableBV var) throws TypeException {
        if (this.rep != this) {
            return this.ecr().union(var);
        }
        TypeVariableBV y = var.ecr();
        if (this == y) {
            this.parents.clear(var.ownId());
            this.children.clear(var.ownId());
            return this;
        }
        if (this.rank > y.rank) {
            this.resolver.invalidateId(y.id());
            y.rep = this;
            this.merge(y);
            y.clear();
            return this;
        }
        this.resolver.invalidateId(this.id());
        this.rep = y;
        if (this.rank == y.rank) {
            ++y.rank;
        }
        y.merge(this);
        this.clear();
        return y;
    }

    private void clear() {
        this.approx = null;
        this.type = null;
        this.element = null;
        this.array = null;
        this.parents = null;
        this.children = null;
        this.ancestors = null;
        this.indirectAncestors = null;
    }

    private void merge(TypeVariableBV var) throws TypeException {
        if (this.depth != 0 || var.depth != 0) {
            throw new InternalTypingException();
        }
        if (this.type == null) {
            this.type = var.type;
        } else if (var.type != null) {
            TypeVariableBV.error("Type Error(1): Attempt to merge two types.");
        }
        this.parents.or(var.parents);
        this.parents.clear(var.ownId());
        this.parents.clear(this.ownId());
        this.children.or(var.children);
        this.children.clear(var.ownId());
        this.children.clear(this.ownId());
    }

    void validate() throws TypeException {
        if (this.rep != this) {
            this.ecr().validate();
            return;
        }
        if (this.type != null) {
            BitSetIterator i = this.parents.iterator();
            while (i.hasNext()) {
                TypeVariableBV parent = this.resolver.typeVariableForId(i.next()).ecr();
                if (parent.type == null || this.type.hasAncestor(parent.type)) continue;
                TypeVariableBV.error("Type Error(2): Parent type is not a valid ancestor.");
            }
            i = this.children.iterator();
            while (i.hasNext()) {
                TypeVariableBV child = this.resolver.typeVariableForId(i.next()).ecr();
                if (child.type == null || this.type.hasDescendant(child.type)) continue;
                TypeVariableBV.error("Type Error(3): Child type is not a valid descendant.");
            }
        }
    }

    public void removeIndirectRelations() {
        if (this.rep != this) {
            this.ecr().removeIndirectRelations();
            return;
        }
        if (this.indirectAncestors == null) {
            this.fixAncestors();
        }
        BitVector parentsToRemove = new BitVector();
        BitSetIterator parentIt = this.parents.iterator();
        while (parentIt.hasNext()) {
            int parent = parentIt.next();
            if (!this.indirectAncestors.get(parent)) continue;
            parentsToRemove.set(parent);
        }
        BitSetIterator i = parentsToRemove.iterator();
        while (i.hasNext()) {
            this.removeParent(this.resolver.typeVariableForId(i.next()));
        }
    }

    private void fixAncestors() {
        BitVector ancestors = new BitVector(0);
        BitVector indirectAncestors = new BitVector(0);
        this.fixParents();
        BitSetIterator i = this.parents.iterator();
        while (i.hasNext()) {
            TypeVariableBV parent = this.resolver.typeVariableForId(i.next()).ecr();
            if (parent.ancestors == null) {
                parent.fixAncestors();
            }
            ancestors.set(parent.id);
            ancestors.or(parent.ancestors);
            indirectAncestors.or(parent.ancestors);
        }
        this.ancestors = ancestors;
        this.indirectAncestors = indirectAncestors;
    }

    private void fixParents() {
        if (this.rep != this) {
            this.ecr().fixParents();
        }
        BitVector invalid = new BitVector();
        invalid.or(this.parents);
        invalid.and(this.resolver.invalidIds());
        BitSetIterator i = invalid.iterator();
        while (i.hasNext()) {
            this.parents.set(this.resolver.typeVariableForId(i.next()).id());
        }
        this.parents.clear(this.id);
        this.parents.clear(this.id());
        this.parents.andNot(invalid);
    }

    public int id() {
        if (this.rep != this) {
            return this.ecr().id();
        }
        return this.id;
    }

    public int ownId() {
        return this.id;
    }

    public void addParent(TypeVariableBV variable) {
        if (this.rep != this) {
            this.ecr().addParent(variable);
            return;
        }
        TypeVariableBV var = variable.ecr();
        if (var == this) {
            return;
        }
        this.parents.set(var.id);
        var.children.set(this.id);
    }

    public void removeParent(TypeVariableBV variable) {
        if (this.rep != this) {
            this.ecr().removeParent(variable);
            return;
        }
        this.parents.clear(variable.id());
        this.parents.clear(variable.ownId());
        variable.children().clear(this.id);
    }

    public void addChild(TypeVariableBV variable) {
        if (this.rep != this) {
            this.ecr().addChild(variable);
            return;
        }
        TypeVariableBV var = variable.ecr();
        if (var == this) {
            return;
        }
        this.children.set(var.id);
        this.parents.set(var.id);
    }

    public void removeChild(TypeVariableBV variable) {
        if (this.rep != this) {
            this.ecr().removeChild(variable);
            return;
        }
        TypeVariableBV var = variable.ecr();
        this.children.clear(var.id);
        var.parents.clear(var.id);
    }

    public int depth() {
        if (this.rep != this) {
            return this.ecr().depth();
        }
        return this.depth;
    }

    public void makeElement() {
        if (this.rep != this) {
            this.ecr().makeElement();
            return;
        }
        if (this.element == null) {
            this.element = this.resolver.typeVariable();
            this.element.array = this;
        }
    }

    public TypeVariableBV element() {
        if (this.rep != this) {
            return this.ecr().element();
        }
        return this.element == null ? null : this.element.ecr();
    }

    public TypeVariableBV array() {
        if (this.rep != this) {
            return this.ecr().array();
        }
        return this.array == null ? null : this.array.ecr();
    }

    public BitVector parents() {
        if (this.rep != this) {
            return this.ecr().parents();
        }
        return this.parents;
    }

    public BitVector children() {
        if (this.rep != this) {
            return this.ecr().children();
        }
        return this.children;
    }

    public TypeNode approx() {
        if (this.rep != this) {
            return this.ecr().approx();
        }
        return this.approx;
    }

    public TypeNode type() {
        if (this.rep != this) {
            return this.ecr().type();
        }
        return this.type;
    }

    static void error(String message) throws TypeException {
        throw new TypeException(message);
    }

    public static void computeApprox(TreeSet<TypeVariableBV> workList) throws TypeException {
        while (workList.size() > 0) {
            TypeVariableBV var = workList.first();
            workList.remove(var);
            var.fixApprox(workList);
        }
    }

    private void fixApprox(TreeSet<TypeVariableBV> workList) throws TypeException {
        TypeNode type;
        if (this.rep != this) {
            this.ecr().fixApprox(workList);
            return;
        }
        if (this.type == null && this.approx != this.resolver.hierarchy().NULL) {
            TypeVariableBV array;
            TypeVariableBV element2 = this.element();
            if (element2 != null) {
                if (!this.approx.hasElement()) {
                    G.v().out.println("*** " + this + " ***");
                    TypeVariableBV.error("Type Error(4)");
                }
                TypeNode temp = this.approx.element();
                if (element2.approx == null) {
                    element2.approx = temp;
                    workList.add(element2);
                } else {
                    type = element2.approx.lca(temp);
                    if (type != element2.approx) {
                        element2.approx = type;
                        workList.add(element2);
                    } else if (element2.approx != this.resolver.hierarchy().INT && (type = this.approx.lca(element2.approx.array())) != this.approx) {
                        this.approx = type;
                        workList.add(this);
                    }
                }
            }
            if ((array = this.array()) != null && this.approx != this.resolver.hierarchy().NULL && this.approx != this.resolver.hierarchy().INT) {
                TypeNode temp = this.approx.array();
                if (array.approx == null) {
                    array.approx = temp;
                    workList.add(array);
                } else {
                    TypeNode type2 = array.approx.lca(temp);
                    if (type2 != array.approx) {
                        array.approx = type2;
                        workList.add(array);
                    } else {
                        type2 = this.approx.lca(array.approx.element());
                        if (type2 != this.approx) {
                            this.approx = type2;
                            workList.add(this);
                        }
                    }
                }
            }
        }
        BitSetIterator i = this.parents.iterator();
        while (i.hasNext()) {
            TypeVariableBV parent = this.resolver.typeVariableForId(i.next()).ecr();
            if (parent.approx == null) {
                parent.approx = this.approx;
                workList.add(parent);
                continue;
            }
            type = parent.approx.lca(this.approx);
            if (type == parent.approx) continue;
            parent.approx = type;
            workList.add(parent);
        }
        if (this.type != null) {
            this.approx = this.type;
        }
    }

    public void fixDepth() throws TypeException {
        ArrayType at;
        if (this.rep != this) {
            this.ecr().fixDepth();
            return;
        }
        if (this.type != null) {
            if (this.type.type() instanceof ArrayType) {
                at = (ArrayType)this.type.type();
                this.depth = at.numDimensions;
            } else {
                this.depth = 0;
            }
        } else if (this.approx.type() instanceof ArrayType) {
            at = (ArrayType)this.approx.type();
            this.depth = at.numDimensions;
        } else {
            this.depth = 0;
        }
        if (this.depth == 0 && this.element() != null) {
            TypeVariableBV.error("Type Error(11)");
        } else if (this.depth > 0 && this.element() == null) {
            this.makeElement();
            TypeVariableBV element2 = this.element();
            element2.depth = this.depth - 1;
            while (element2.depth != 0) {
                element2.makeElement();
                element2.element().depth = element2.depth - 1;
                element2 = element2.element();
            }
        }
    }

    public void propagate() {
        TypeVariableBV var;
        if (this.rep != this) {
            this.ecr().propagate();
        }
        if (this.depth == 0) {
            return;
        }
        BitSetIterator i = this.parents.iterator();
        while (i.hasNext()) {
            var = this.resolver.typeVariableForId(i.next()).ecr();
            if (var.depth() == this.depth) {
                this.element().addParent(var.element());
                continue;
            }
            if (var.depth() == 0) {
                if (var.type() != null || Options.v().j2me()) continue;
                var.addChild(this.resolver.typeVariable(this.resolver.hierarchy().CLONEABLE));
                var.addChild(this.resolver.typeVariable(this.resolver.hierarchy().SERIALIZABLE));
                continue;
            }
            if (var.type() != null || Options.v().j2me()) continue;
            var.addChild(this.resolver.typeVariable(ArrayType.v(RefType.v("java.lang.Cloneable"), var.depth())));
            var.addChild(this.resolver.typeVariable(ArrayType.v(RefType.v("java.io.Serializable"), var.depth())));
        }
        BitSetIterator varIt = this.parents.iterator();
        while (varIt.hasNext()) {
            var = this.resolver.typeVariableForId(varIt.next());
            this.removeParent(var);
        }
    }

    public String toString() {
        if (this.rep != this) {
            return this.ecr().toString();
        }
        StringBuffer s2 = new StringBuffer();
        s2.append(",[parents:");
        boolean comma = false;
        BitSetIterator i = this.parents.iterator();
        while (i.hasNext()) {
            if (comma) {
                s2.append(",");
            } else {
                comma = true;
            }
            s2.append(i.next());
        }
        s2.append("],[children:");
        comma = false;
        i = this.children.iterator();
        while (i.hasNext()) {
            if (comma) {
                s2.append(",");
            } else {
                comma = true;
            }
            s2.append(i.next());
        }
        s2.append("]");
        return "[id:" + this.id + ",depth:" + this.depth + (this.type != null ? ",type:" + this.type : "") + ",approx:" + this.approx + s2 + (this.element == null ? "" : ",arrayof:" + this.element.id()) + "]";
    }
}

