/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import soot.toolkits.graph.DirectedGraph;

public class LoopBodyFinder {
    private final Stack<Object> stack = new Stack();
    private final Set<Set<Object>> loops = new HashSet<Set<Object>>();

    LoopBodyFinder(Map<Object, Object> backEdges, DirectedGraph g) {
        this.findLoopBody(backEdges, g);
    }

    private void findLoopBody(Map<Object, Object> backEdges, DirectedGraph g) {
        Set<Map.Entry<Object, Object>> maps = backEdges.entrySet();
        for (Map.Entry<Object, Object> entry2 : maps) {
            Object tail = entry2.getKey();
            Object head2 = entry2.getValue();
            Set<Object> loopBody = this.finder(tail, head2, g);
            this.loops.add(loopBody);
        }
    }

    private Set<Object> finder(Object tail, Object head2, DirectedGraph g) {
        HashSet<Object> loop2 = new HashSet<Object>();
        this.stack.empty();
        loop2.add(head2);
        this.insert(tail, loop2);
        while (!this.stack.empty()) {
            Object p = this.stack.pop();
            for (Object pred : g.getPredsOf(p)) {
                this.insert(pred, loop2);
            }
        }
        return loop2;
    }

    private void insert(Object m, Set<Object> loop2) {
        if (!loop2.contains(m)) {
            loop2.add(m);
            this.stack.push(m);
        }
    }

    public Set<Set<Object>> getLoopBody() {
        return this.loops;
    }
}

