/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import soot.jimple.toolkits.thread.mhp.PegChain;
import soot.jimple.toolkits.thread.mhp.PegGraph;
import soot.jimple.toolkits.thread.mhp.TopologicalSorter;
import soot.jimple.toolkits.thread.mhp.stmt.JPegStmt;
import soot.toolkits.scalar.FlowSet;
import soot.util.Chain;

public class CompactSequentNodes {
    long compactNodes = 0L;
    long add = 0L;

    public CompactSequentNodes(PegGraph pg) {
        PegChain mainPegChain = pg.getMainPegChain();
        this.compactGraph(mainPegChain, pg);
        this.compactStartChain(pg);
        System.err.println("compact seq. node: " + this.compactNodes);
        System.err.println("number of compacting seq. nodes: " + this.add);
    }

    private void compactGraph(Chain chain2, PegGraph peg) {
        Set canNotBeCompacted = peg.getCanNotBeCompacted();
        List<List<Object>> list = this.computeSequentNodes(chain2, peg);
        for (List<Object> s2 : list) {
            if (this.checkIfContainsElemsCanNotBeCompacted(s2, canNotBeCompacted)) continue;
            ++this.add;
            this.compact(s2, chain2, peg);
        }
    }

    private void compactStartChain(PegGraph graph) {
        Set<Map.Entry<JPegStmt, List>> maps = graph.getStartToThread().entrySet();
        for (Map.Entry<JPegStmt, List> entry2 : maps) {
            List runMethodChainList = entry2.getValue();
            for (Chain chain2 : runMethodChainList) {
                this.compactGraph(chain2, graph);
            }
        }
    }

    private List<List<Object>> computeSequentNodes(Chain chain2, PegGraph pg) {
        HashSet<Object> gray = new HashSet<Object>();
        ArrayList<List<Object>> sequentNodes = new ArrayList<List<Object>>();
        Set canNotBeCompacted = pg.getCanNotBeCompacted();
        TopologicalSorter ts = new TopologicalSorter(chain2, pg);
        ListIterator<Object> it = ts.sorter().listIterator();
        while (it.hasNext()) {
            Object node = it.next();
            ArrayList<Object> list = new ArrayList<Object>();
            if (gray.contains(node)) continue;
            this.visitNode(pg, node, list, canNotBeCompacted, gray);
            if (list.size() <= 1) continue;
            gray.addAll(list);
            sequentNodes.add(list);
        }
        return sequentNodes;
    }

    private void visitNode(PegGraph pg, Object node, List<Object> list, Set canNotBeCompacted, Set<Object> gray) {
        if (pg.getPredsOf(node).size() == 1 && pg.getSuccsOf(node).size() == 1 && !canNotBeCompacted.contains(node) && !gray.contains(node)) {
            list.add(node);
            for (Object o : pg.getSuccsOf(node)) {
                this.visitNode(pg, o, list, canNotBeCompacted, gray);
            }
        }
    }

    private boolean checkIfContainsElemsCanNotBeCompacted(List list, Set canNotBeCompacted) {
        for (Object node : list) {
            if (!canNotBeCompacted.contains(node)) continue;
            return true;
        }
        return false;
    }

    private void compact(List list, Chain chain2, PegGraph peg) {
        Iterator it = list.iterator();
        FlowSet allNodes = peg.getAllNodes();
        HashMap unitToSuccs = peg.getUnitToSuccs();
        HashMap unitToPreds = peg.getUnitToPreds();
        ArrayList newPreds = new ArrayList();
        ArrayList newSuccs = new ArrayList();
        while (it.hasNext()) {
            Object s2 = it.next();
            for (Object pred : peg.getPredsOf(s2)) {
                List succsOfPred = peg.getSuccsOf(pred);
                succsOfPred.remove(s2);
                if (list.contains(pred)) continue;
                newPreds.add(pred);
                succsOfPred.add(list);
            }
            for (Object succ : peg.getSuccsOf(s2)) {
                List predsOfSucc = peg.getPredsOf(succ);
                predsOfSucc.remove(s2);
                if (list.contains(succ)) continue;
                newSuccs.add(succ);
                predsOfSucc.add(list);
            }
        }
        unitToSuccs.put(list, newSuccs);
        unitToPreds.put(list, newPreds);
        allNodes.add(list);
        chain2.add(list);
        this.updateMonitor(peg, list);
        for (Object s2 : list) {
            chain2.remove(s2);
            allNodes.remove(s2);
            unitToSuccs.remove(s2);
            unitToPreds.remove(s2);
        }
        this.compactNodes += (long)list.size();
    }

    private void updateMonitor(PegGraph pg, List list) {
        Set<Map.Entry<String, FlowSet>> maps = pg.getMonitor().entrySet();
        block0: for (Map.Entry<String, FlowSet> entry2 : maps) {
            FlowSet fs = entry2.getValue();
            for (Object obj : list) {
                if (!fs.contains(obj)) continue;
                fs.add(list);
                continue block0;
            }
        }
    }
}

