/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.EquivalentValue;
import soot.G;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.Ref;
import soot.jimple.toolkits.infoflow.CallLocalityContext;
import soot.jimple.toolkits.infoflow.ClassInfoFlowAnalysis;
import soot.jimple.toolkits.infoflow.ClassLocalObjectsAnalysis;
import soot.jimple.toolkits.infoflow.InfoFlowAnalysis;
import soot.jimple.toolkits.infoflow.LocalObjectsAnalysis;
import soot.jimple.toolkits.infoflow.SmartMethodInfoFlowAnalysis;
import soot.jimple.toolkits.infoflow.SmartMethodLocalObjectsAnalysis;
import soot.jimple.toolkits.infoflow.UseFinder;
import soot.jimple.toolkits.thread.AbstractRuntimeThread;
import soot.jimple.toolkits.thread.IThreadLocalObjectsAnalysis;
import soot.jimple.toolkits.thread.mhp.MhpTester;

public class ThreadLocalObjectsAnalysis
extends LocalObjectsAnalysis
implements IThreadLocalObjectsAnalysis {
    MhpTester mhp;
    List<AbstractRuntimeThread> threads;
    InfoFlowAnalysis primitiveDfa;
    static boolean printDebug = false;
    Map valueCache;
    Map fieldCache;
    Map invokeCache;

    public ThreadLocalObjectsAnalysis(MhpTester mhp) {
        super(new InfoFlowAnalysis(false, true, printDebug));
        this.mhp = mhp;
        this.threads = mhp.getThreads();
        this.primitiveDfa = new InfoFlowAnalysis(true, true, printDebug);
        this.valueCache = new HashMap();
        this.fieldCache = new HashMap();
        this.invokeCache = new HashMap();
    }

    public void precompute() {
        for (AbstractRuntimeThread thread2 : this.threads) {
            for (Object item : thread2.getRunMethods()) {
                SootMethod runMethod = (SootMethod)item;
                if (!runMethod.getDeclaringClass().isApplicationClass()) continue;
                this.getClassLocalObjectsAnalysis(runMethod.getDeclaringClass());
            }
        }
    }

    @Override
    protected ClassLocalObjectsAnalysis newClassLocalObjectsAnalysis(LocalObjectsAnalysis loa, InfoFlowAnalysis dfa, UseFinder uf, SootClass sc) {
        ArrayList<SootMethod> runMethods = new ArrayList<SootMethod>();
        for (AbstractRuntimeThread thread2 : this.threads) {
            for (SootMethod sootMethod : thread2.getRunMethods()) {
                if (sootMethod.getDeclaringClass() != sc) continue;
                runMethods.add(sootMethod);
            }
        }
        return new ClassLocalObjectsAnalysis(loa, dfa, this.primitiveDfa, uf, sc, runMethods);
    }

    @Override
    public boolean isObjectThreadLocal(Value localOrRef, SootMethod sm) {
        List<AbstractRuntimeThread> mhpThreads;
        if (this.threads.size() <= 1) {
            return true;
        }
        if (printDebug) {
            G.v().out.println("- " + localOrRef + " in " + sm + " is...");
        }
        if ((mhpThreads = this.mhp.getThreads()) != null) {
            for (AbstractRuntimeThread thread2 : mhpThreads) {
                for (Object meth : thread2.getRunMethods()) {
                    SootMethod runMethod = (SootMethod)meth;
                    if (!runMethod.getDeclaringClass().isApplicationClass() || this.isObjectLocalToContext(localOrRef, sm, runMethod)) continue;
                    if (printDebug) {
                        G.v().out.println("  THREAD-SHARED (simpledfa " + ClassInfoFlowAnalysis.methodCount + " smartdfa " + SmartMethodInfoFlowAnalysis.counter + " smartloa " + SmartMethodLocalObjectsAnalysis.counter + ")");
                    }
                    return false;
                }
            }
        }
        if (printDebug) {
            G.v().out.println("  THREAD-LOCAL (simpledfa " + ClassInfoFlowAnalysis.methodCount + " smartdfa " + SmartMethodInfoFlowAnalysis.counter + " smartloa " + SmartMethodLocalObjectsAnalysis.counter + ")");
        }
        return true;
    }

    public boolean hasNonThreadLocalEffects(SootMethod containingMethod, InvokeExpr ie) {
        if (this.threads.size() <= 1) {
            return true;
        }
        return true;
    }

    public List escapesThrough(Value sharedValue, SootMethod containingMethod) {
        ArrayList<EquivalentValue> ret = new ArrayList<EquivalentValue>();
        for (AbstractRuntimeThread thread2 : this.mhp.getThreads()) {
            for (Object meth : thread2.getRunMethods()) {
                SootMethod runMethod = (SootMethod)meth;
                if (!runMethod.getDeclaringClass().isApplicationClass() || this.isObjectLocalToContext(sharedValue, containingMethod, runMethod)) continue;
                ClassLocalObjectsAnalysis cloa = this.getClassLocalObjectsAnalysis(containingMethod.getDeclaringClass());
                CallLocalityContext clc = cloa.getMergedContext(containingMethod);
                SmartMethodInfoFlowAnalysis smifa = this.dfa.getMethodInfoFlowAnalysis(containingMethod);
                EquivalentValue sharedValueEqVal = sharedValue instanceof InstanceFieldRef ? InfoFlowAnalysis.getNodeForFieldRef(containingMethod, ((FieldRef)sharedValue).getField()) : new EquivalentValue(sharedValue);
                List<EquivalentValue> sources = smifa.sourcesOf(sharedValueEqVal);
                for (EquivalentValue source : sources) {
                    if (!(source.getValue() instanceof Ref) || clc == null || clc.isFieldLocal(source)) continue;
                    ret.add(source);
                }
            }
        }
        return ret;
    }
}

