/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import soot.SideEffectTester;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Expr;
import soot.jimple.FieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.toolkits.scalar.ToppedSet;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class FastAvailableExpressionsAnalysis
extends ForwardFlowAnalysis<Unit, FlowSet<Value>> {
    SideEffectTester st;
    Map<Unit, FlowSet<Value>> unitToGenerateSet;
    Map<Unit, FlowSet<Value>> unitToPreserveSet;
    Map<Value, Unit> rhsToContainingStmt;
    FlowSet<Value> emptySet;

    public FastAvailableExpressionsAnalysis(DirectedGraph<Unit> dg, SootMethod m, SideEffectTester st) {
        super(dg);
        this.st = st;
        ExceptionalUnitGraph g = (ExceptionalUnitGraph)dg;
        this.rhsToContainingStmt = new HashMap<Value, Unit>();
        this.emptySet = new ToppedSet<Value>(new ArraySparseSet());
        this.unitToGenerateSet = new HashMap<Unit, FlowSet<Value>>(g.size() * 2 + 1, 0.7f);
        for (Unit s2 : g) {
            AssignStmt as;
            FlowSet<Value> genSet = this.emptySet.clone();
            if (s2 instanceof AssignStmt && ((as = (AssignStmt)s2).getRightOp() instanceof Expr || as.getRightOp() instanceof FieldRef)) {
                Value gen = as.getRightOp();
                this.rhsToContainingStmt.put(gen, s2);
                boolean cantAdd = false;
                if (gen instanceof NewExpr || gen instanceof NewArrayExpr || gen instanceof NewMultiArrayExpr) {
                    cantAdd = true;
                }
                if (gen instanceof InvokeExpr) {
                    cantAdd = true;
                }
                if (!cantAdd) {
                    genSet.add(gen, genSet);
                }
            }
            this.unitToGenerateSet.put(s2, genSet);
        }
        this.doAnalysis();
    }

    @Override
    protected FlowSet<Value> newInitialFlow() {
        FlowSet<Value> newSet = this.emptySet.clone();
        ((ToppedSet)newSet).setTop(true);
        return newSet;
    }

    @Override
    protected FlowSet<Value> entryInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected void flowThrough(FlowSet<Value> in, Unit u, FlowSet<Value> out) {
        in.copy(out);
        if (((ToppedSet)in).isTop()) {
            return;
        }
        out.union(this.unitToGenerateSet.get(u), out);
        if (((ToppedSet)out).isTop()) {
            throw new RuntimeException("trying to kill on topped set!");
        }
        LinkedList<Value> l = new LinkedList<Value>(out.toList());
        for (Value avail : l) {
            if (avail instanceof FieldRef) {
                if (!this.st.unitCanWriteTo(u, avail)) continue;
                out.remove(avail, out);
                continue;
            }
            for (ValueBox vb : avail.getUseBoxes()) {
                Value use = vb.getValue();
                if (!this.st.unitCanWriteTo(u, use)) continue;
                out.remove(avail, out);
            }
        }
    }

    @Override
    protected void merge(FlowSet<Value> inSet1, FlowSet<Value> inSet2, FlowSet<Value> outSet) {
        inSet1.intersection(inSet2, outSet);
    }

    @Override
    protected void copy(FlowSet<Value> sourceSet, FlowSet<Value> destSet) {
        sourceSet.copy(destSet);
    }
}

