/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.Timers;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.DivExpr;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.RemExpr;
import soot.options.Options;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class DeadAssignmentEliminator
extends BodyTransformer {
    public DeadAssignmentEliminator(Singletons.Global g) {
    }

    public static DeadAssignmentEliminator v() {
        return G.v().soot_jimple_toolkits_scalar_DeadAssignmentEliminator();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        boolean eliminateOnlyStackLocals = PhaseOptions.getBoolean(options, "only-stack-locals");
        if (Options.v().verbose()) {
            G.v().out.println("[" + b.getMethod().getName() + "] Eliminating dead code...");
        }
        if (Options.v().time()) {
            Timers.v().deadCodeTimer.start();
        }
        PatchingChain<Unit> units = b.getUnits();
        ArrayDeque<Unit> q = new ArrayDeque<Unit>(units.size());
        boolean isStatic = b.getMethod().isStatic();
        boolean allEssential = true;
        boolean checkInvoke = false;
        Local thisLocal = null;
        Iterator it = units.iterator();
        while (it.hasNext()) {
            Unit s2 = (Unit)it.next();
            boolean isEssential = true;
            if (s2 instanceof NopStmt) {
                boolean removeNop = it.hasNext();
                if (!removeNop) {
                    removeNop = true;
                    for (Trap t : b.getTraps()) {
                        if (t.getEndUnit() != s2) continue;
                        removeNop = false;
                        break;
                    }
                }
                if (removeNop) {
                    it.remove();
                    continue;
                }
            } else if (s2 instanceof AssignStmt) {
                Value rhs;
                AssignStmt as = (AssignStmt)s2;
                Value lhs = as.getLeftOp();
                if (lhs == (rhs = as.getRightOp()) && lhs instanceof Local) {
                    it.remove();
                    continue;
                }
                if (lhs instanceof Local && (!eliminateOnlyStackLocals || ((Local)lhs).getName().startsWith("$") || lhs.getType() instanceof NullType)) {
                    isEssential = false;
                    if (!checkInvoke) {
                        checkInvoke |= as.containsInvokeExpr();
                    }
                    if (rhs instanceof CastExpr) {
                        CastExpr ce = (CastExpr)rhs;
                        Type t = ce.getCastType();
                        Value v = ce.getOp();
                        isEssential = !(t instanceof RefType) || v != NullConstant.v();
                    } else if (rhs instanceof InvokeExpr || rhs instanceof ArrayRef || rhs instanceof NewExpr || rhs instanceof NewArrayExpr || rhs instanceof NewMultiArrayExpr) {
                        isEssential = true;
                    } else if (rhs instanceof FieldRef) {
                        isEssential = true;
                        if (rhs instanceof InstanceFieldRef) {
                            InstanceFieldRef ifr = (InstanceFieldRef)rhs;
                            if (!isStatic && thisLocal == null) {
                                thisLocal = b.getThisLocal();
                            }
                            isEssential = isStatic || thisLocal != ifr.getBase();
                        }
                    } else if (rhs instanceof DivExpr || rhs instanceof RemExpr) {
                        Value v;
                        BinopExpr expr = (BinopExpr)rhs;
                        Type t1 = expr.getOp1().getType();
                        Type t2 = expr.getOp2().getType();
                        boolean bl = isEssential = IntType.v().equals(t1) || LongType.v().equals(t1) || IntType.v().equals(t2) || LongType.v().equals(t2);
                        if (isEssential && IntType.v().equals(t2) && (v = expr.getOp2()) instanceof IntConstant) {
                            IntConstant i = (IntConstant)v;
                            boolean bl2 = isEssential = i.value == 0;
                        }
                        if (isEssential && LongType.v().equals(t2) && (v = expr.getOp2()) instanceof LongConstant) {
                            LongConstant l = (LongConstant)v;
                            boolean bl3 = isEssential = l.value == 0L;
                        }
                    }
                }
            }
            if (isEssential) {
                q.addFirst(s2);
            }
            allEssential &= isEssential;
        }
        if (checkInvoke || !allEssential) {
            LocalDefs localDefs = LocalDefs.Factory.newLocalDefs(b);
            if (!allEssential) {
                HashSet<Unit> essential = new HashSet<Unit>(b.getUnits().size());
                while (!q.isEmpty()) {
                    Unit s3 = (Unit)q.removeFirst();
                    if (!essential.add(s3)) continue;
                    for (ValueBox box : s3.getUseBoxes()) {
                        Local l;
                        List<Unit> defs;
                        Value v = box.getValue();
                        if (!(v instanceof Local) || (defs = localDefs.getDefsOfAt(l = (Local)v, s3)) == null) continue;
                        q.addAll(defs);
                    }
                }
                units.retainAll(essential);
            }
            if (checkInvoke) {
                LocalUses localUses = LocalUses.Factory.newLocalUses(b, localDefs);
                ArrayList<AssignStmt> postProcess = new ArrayList<AssignStmt>();
                for (Unit u : units) {
                    AssignStmt s4;
                    if (!(u instanceof AssignStmt) || !(s4 = (AssignStmt)u).containsInvokeExpr()) continue;
                    boolean deadAssignment = true;
                    for (UnitValueBoxPair pair : localUses.getUsesOf(s4)) {
                        if (!units.contains(pair.unit)) continue;
                        deadAssignment = false;
                        break;
                    }
                    if (!deadAssignment) continue;
                    postProcess.add(s4);
                }
                for (AssignStmt s5 : postProcess) {
                    InvokeStmt newInvoke = Jimple.v().newInvokeStmt(s5.getInvokeExpr());
                    newInvoke.addAllTagsOf(s5);
                    units.swapWith(s5, newInvoke);
                    if (!Scene.v().hasCallGraph()) continue;
                    Scene.v().getCallGraph().swapEdgesOutOf(s5, newInvoke);
                }
            }
        }
        if (Options.v().time()) {
            Timers.v().deadCodeTimer.end();
        }
    }
}

