/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Singletons;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.NullConstant;
import soot.jimple.NumericConstant;
import soot.jimple.StringConstant;
import soot.jimple.toolkits.scalar.Evaluator;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.scalar.LocalDefs;

public class ConstantPropagatorAndFolder
extends BodyTransformer {
    public ConstantPropagatorAndFolder(Singletons.Global g) {
    }

    public static ConstantPropagatorAndFolder v() {
        return G.v().soot_jimple_toolkits_scalar_ConstantPropagatorAndFolder();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        int numFolded = 0;
        int numPropagated = 0;
        if (Options.v().verbose()) {
            G.v().out.println("[" + b.getMethod().getName() + "] Propagating and folding constants...");
        }
        ExceptionalUnitGraph g = new ExceptionalUnitGraph(b);
        LocalDefs localDefs = LocalDefs.Factory.newLocalDefs(g);
        PseudoTopologicalOrderer<Unit> orderer = new PseudoTopologicalOrderer<Unit>();
        for (Unit u : orderer.newList(g, false)) {
            Value value2;
            for (ValueBox useBox : u.getUseBoxes()) {
                CastExpr ce;
                Local local;
                List<Unit> defsOfUse;
                value2 = useBox.getValue();
                if (!(value2 instanceof Local) || (defsOfUse = localDefs.getDefsOfAt(local = (Local)value2, u)).size() != 1) continue;
                DefinitionStmt defStmt = (DefinitionStmt)defsOfUse.get(0);
                Value rhs = defStmt.getRightOp();
                if (rhs instanceof NumericConstant || rhs instanceof StringConstant) {
                    if (!useBox.canContainValue(rhs)) continue;
                    useBox.setValue(rhs);
                    ++numPropagated;
                    continue;
                }
                if (!(rhs instanceof CastExpr) || !((ce = (CastExpr)rhs).getOp() instanceof NullConstant)) continue;
                useBox.setValue(NullConstant.v());
                ++numPropagated;
            }
            for (ValueBox useBox : u.getUseBoxes()) {
                Value constValue;
                value2 = useBox.getValue();
                if (value2 instanceof Constant || !Evaluator.isValueConstantValued(value2) || !useBox.canContainValue(constValue = Evaluator.getConstantValueOf(value2))) continue;
                useBox.setValue(constValue);
                ++numFolded;
            }
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + b.getMethod().getName() + "]     Propagated: " + numPropagated + ", Folded:  " + numFolded);
        }
    }
}

