/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.purity;

import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import soot.G;
import soot.SootMethod;
import soot.SourceLocator;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.purity.DirectedCallGraph;
import soot.jimple.toolkits.annotation.purity.SootMethodFilter;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.util.dot.DotGraph;
import soot.util.dot.DotGraphEdge;
import soot.util.dot.DotGraphNode;

public abstract class AbstractInterproceduralAnalysis {
    public static final boolean doCheck = false;
    protected CallGraph cg;
    protected DirectedGraph dg;
    protected Map data;
    protected Map<Object, Integer> order;
    protected Map unanalysed;

    protected abstract Object newInitialSummary();

    protected abstract Object summaryOfUnanalysedMethod(SootMethod var1);

    protected abstract void analyseMethod(SootMethod var1, Object var2);

    protected abstract void applySummary(Object var1, Stmt var2, Object var3, Object var4);

    protected abstract void merge(Object var1, Object var2, Object var3);

    protected abstract void copy(Object var1, Object var2);

    protected void fillDotGraph(String prefix, Object o, DotGraph out) {
        throw new Error("abstract function AbstractInterproceduralAnalysis.fillDotGraph called but not implemented.");
    }

    protected void analyseCall(Object src, Stmt callStmt, Object dst) {
        Object accum = this.newInitialSummary();
        Iterator<Edge> it = this.cg.edgesOutOf(callStmt);
        this.copy(accum, dst);
        while (it.hasNext()) {
            Object elem;
            Edge edge = it.next();
            SootMethod m = edge.tgt();
            if (this.data.containsKey(m)) {
                elem = this.data.get(m);
            } else {
                if (!this.unanalysed.containsKey(m)) {
                    this.unanalysed.put(m, this.summaryOfUnanalysedMethod(m));
                }
                elem = this.unanalysed.get(m);
            }
            this.applySummary(src, callStmt, elem, accum);
            this.merge(dst, accum, dst);
        }
    }

    public AbstractInterproceduralAnalysis(CallGraph cg, SootMethodFilter filter2, Iterator heads2, boolean verbose) {
        this.cg = cg;
        this.dg = new DirectedCallGraph(cg, filter2, heads2, verbose);
        this.data = new HashMap();
        this.unanalysed = new HashMap();
        this.order = new HashMap<Object, Integer>();
        PseudoTopologicalOrderer o = new PseudoTopologicalOrderer();
        Iterator it = o.newList(this.dg, true).iterator();
        int i = 0;
        while (it.hasNext()) {
            this.order.put(it.next(), new Integer(i));
            ++i;
        }
    }

    public void drawAsOneDot(String name) {
        DotGraph dot = new DotGraph(name);
        dot.setGraphLabel(name);
        dot.setGraphAttribute("compound", "true");
        int id = 0;
        HashMap<SootMethod, Integer> idmap = new HashMap<SootMethod, Integer>();
        for (SootMethod m : this.dg) {
            DotGraph sub = dot.createSubGraph("cluster" + id);
            DotGraphNode label = sub.drawNode("head" + id);
            idmap.put(m, new Integer(id));
            sub.setGraphLabel("");
            label.setLabel("(" + this.order.get(m) + ") " + m.toString());
            label.setAttribute("fontsize", "18");
            label.setShape("box");
            if (this.data.containsKey(m)) {
                this.fillDotGraph("X" + id, this.data.get(m), sub);
            }
            ++id;
        }
        for (SootMethod m : this.dg) {
            for (SootMethod mm : this.dg.getSuccsOf(m)) {
                DotGraphEdge edge = dot.drawEdge("head" + idmap.get(m), "head" + idmap.get(mm));
                edge.setAttribute("ltail", "cluster" + idmap.get(m));
                edge.setAttribute("lhead", "cluster" + idmap.get(mm));
            }
        }
        File f = new File(SourceLocator.v().getOutputDir(), name + ".dot");
        dot.plot(f.getPath());
    }

    public void drawAsManyDot(String prefix, boolean drawUnanalysed) {
        File f;
        DotGraph dot;
        for (SootMethod m : this.data.keySet()) {
            dot = new DotGraph(m.toString());
            dot.setGraphLabel(m.toString());
            this.fillDotGraph("X", this.data.get(m), dot);
            f = new File(SourceLocator.v().getOutputDir(), prefix + m.toString() + ".dot");
            dot.plot(f.getPath());
        }
        if (drawUnanalysed) {
            for (SootMethod m : this.unanalysed.keySet()) {
                dot = new DotGraph(m.toString());
                dot.setGraphLabel(m.toString() + " (unanalysed)");
                this.fillDotGraph("X", this.unanalysed.get(m), dot);
                f = new File(SourceLocator.v().getOutputDir(), prefix + m.toString() + "_u" + ".dot");
                dot.plot(f.getPath());
            }
        }
    }

    public Object getSummaryFor(SootMethod m) {
        if (this.data.containsKey(m)) {
            return this.data.get(m);
        }
        if (this.unanalysed.containsKey(m)) {
            return this.unanalysed.get(m);
        }
        return this.newInitialSummary();
    }

    public Iterator getAnalysedMethods() {
        return this.data.keySet().iterator();
    }

    protected void doAnalysis(boolean verbose) {
        class IntComparator
        implements Comparator {
            IntComparator() {
            }

            public int compare(Object o1, Object o2) {
                Integer v1 = AbstractInterproceduralAnalysis.this.order.get(o1);
                Integer v2 = AbstractInterproceduralAnalysis.this.order.get(o2);
                return v1 - v2;
            }
        }
        TreeSet<Object> queue = new TreeSet<Object>(new IntComparator());
        for (Object o : this.order.keySet()) {
            this.data.put(o, this.newInitialSummary());
            queue.add(o);
        }
        HashMap<SootMethod, Integer> nb = new HashMap<SootMethod, Integer>();
        while (!queue.isEmpty()) {
            SootMethod m = (SootMethod)queue.first();
            queue.remove(m);
            Object newSummary = this.newInitialSummary();
            Object oldSummary = this.data.get(m);
            if (nb.containsKey(m)) {
                nb.put(m, new Integer((Integer)nb.get(m) + 1));
            } else {
                nb.put(m, new Integer(1));
            }
            if (verbose) {
                G.v().out.println(" |- processing " + m.toString() + " (" + nb.get(m) + "-st time)");
            }
            this.analyseMethod(m, newSummary);
            if (oldSummary.equals(newSummary)) continue;
            this.data.put(m, newSummary);
            queue.addAll(this.dg.getPredsOf(m));
        }
    }
}

