/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Singletons;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.Expr;
import soot.jimple.GotoStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.NaiveSideEffectTester;
import soot.jimple.NewExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.logic.Loop;
import soot.jimple.toolkits.annotation.logic.LoopFinder;
import soot.tagkit.ColorTag;
import soot.tagkit.LoopInvariantTag;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.toolkits.scalar.SmartLocalDefsPool;

public class LoopInvariantFinder
extends BodyTransformer {
    private ArrayList constants;

    public LoopInvariantFinder(Singletons.Global g) {
    }

    public static LoopInvariantFinder v() {
        return G.v().soot_jimple_toolkits_annotation_logic_LoopInvariantFinder();
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        SmartLocalDefs sld = SmartLocalDefsPool.v().getSmartLocalDefsFor(b);
        UnitGraph g = sld.getGraph();
        NaiveSideEffectTester nset = new NaiveSideEffectTester();
        LoopFinder lf = new LoopFinder();
        lf.internalTransform(b, phaseName, options);
        Collection<Loop> loops = lf.loops();
        this.constants = new ArrayList();
        if (loops.isEmpty()) {
            return;
        }
        for (Loop loop2 : loops) {
            Stmt header2 = loop2.getHead();
            List<Stmt> loopStmts = loop2.getLoopStatements();
            for (Stmt tStmt : loopStmts) {
                this.handleLoopBodyStmt(tStmt, nset, loopStmts);
            }
        }
    }

    private void handleLoopBodyStmt(Stmt s2, NaiveSideEffectTester nset, Collection<Stmt> loopStmts) {
        DefinitionStmt ds;
        if (s2 instanceof DefinitionStmt && (ds = (DefinitionStmt)s2).getLeftOp() instanceof Local && ds.getRightOp() instanceof Constant) {
            if (!this.constants.contains(ds.getLeftOp())) {
                this.constants.add(ds.getLeftOp());
            } else {
                this.constants.remove(ds.getLeftOp());
            }
        }
        if (s2 instanceof GotoStmt) {
            return;
        }
        if (s2 instanceof InvokeStmt) {
            return;
        }
        G.v().out.println("s : " + s2 + " use boxes: " + s2.getUseBoxes() + " def boxes: " + s2.getDefBoxes());
        Iterator<ValueBox> useBoxesIt = s2.getUseBoxes().iterator();
        boolean result2 = true;
        block0: while (useBoxesIt.hasNext()) {
            ValueBox vb = useBoxesIt.next();
            Value v = vb.getValue();
            if (v instanceof NewExpr) {
                result2 = false;
                G.v().out.println("break uses: due to new expr");
                break;
            }
            if (v instanceof InvokeExpr) {
                result2 = false;
                G.v().out.println("break uses: due to invoke expr");
                break;
            }
            if (v instanceof Expr) continue;
            G.v().out.println("test: " + v + " of kind: " + v.getClass());
            for (Stmt next2 : loopStmts) {
                if (!nset.unitCanWriteTo(next2, v) || this.isConstant(next2)) continue;
                G.v().out.println("result = false unit can be written to by: " + next2);
                result2 = false;
                break block0;
            }
        }
        block2: for (ValueBox vb : s2.getDefBoxes()) {
            Value v = vb.getValue();
            if (v instanceof NewExpr) {
                result2 = false;
                G.v().out.println("break defs due to new");
                break;
            }
            if (v instanceof InvokeExpr) {
                result2 = false;
                G.v().out.println("break defs due to invoke");
                break;
            }
            if (v instanceof Expr) continue;
            G.v().out.println("test: " + v + " of kind: " + v.getClass());
            for (Stmt next3 : loopStmts) {
                if (next3.equals(s2) || !nset.unitCanWriteTo(next3, v) || this.isConstant(next3)) continue;
                G.v().out.println("result false: unit can be written to by: " + next3);
                result2 = false;
                break block2;
            }
        }
        G.v().out.println("stmt: " + s2 + " result: " + result2);
        if (result2) {
            s2.addTag(new LoopInvariantTag("is loop invariant"));
            s2.addTag(new ColorTag(0, "Loop Invariant Analysis"));
        }
    }

    private boolean isConstant(Stmt s2) {
        DefinitionStmt ds;
        return s2 instanceof DefinitionStmt && this.constants.contains((ds = (DefinitionStmt)s2).getLeftOp());
    }
}

