/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import soot.Body;
import soot.BodyTransformer;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.logic.Loop;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.MHGDominatorsFinder;
import soot.toolkits.graph.UnitGraph;

public class LoopFinder
extends BodyTransformer {
    private UnitGraph g;
    private HashMap<Stmt, List<Stmt>> loops;

    public Collection<Loop> loops() {
        HashSet<Loop> result2 = new HashSet<Loop>();
        for (Map.Entry<Stmt, List<Stmt>> entry2 : this.loops.entrySet()) {
            result2.add(new Loop(entry2.getKey(), entry2.getValue(), this.g));
        }
        return result2;
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        this.g = new ExceptionalUnitGraph(b);
        MHGDominatorsFinder<Unit> a2 = new MHGDominatorsFinder<Unit>(this.g);
        this.loops = new HashMap();
        for (Stmt stmt : b.getUnits()) {
            List<Unit> succs = this.g.getSuccsOf(stmt);
            List<Unit> dominaters = a2.getDominators(stmt);
            ArrayList<Stmt> headers = new ArrayList<Stmt>();
            for (Stmt stmt2 : succs) {
                if (!dominaters.contains(stmt2)) continue;
                headers.add(stmt2);
            }
            for (Stmt header2 : headers) {
                List<Stmt> loopBody = this.getLoopBodyFor(header2, stmt);
                if (this.loops.containsKey(header2)) {
                    List<Stmt> lb1 = this.loops.get(header2);
                    this.loops.put(header2, this.union(lb1, loopBody));
                    continue;
                }
                this.loops.put(header2, loopBody);
            }
        }
    }

    private List<Stmt> getLoopBodyFor(Stmt header2, Stmt node) {
        ArrayList<Stmt> loopBody = new ArrayList<Stmt>();
        Stack<Unit> stack = new Stack<Unit>();
        loopBody.add(header2);
        stack.push(node);
        while (!stack.isEmpty()) {
            Stmt next2 = (Stmt)stack.pop();
            if (loopBody.contains(next2)) continue;
            loopBody.add(0, next2);
            Iterator<Unit> it = this.g.getPredsOf(next2).iterator();
            while (it.hasNext()) {
                stack.push(it.next());
            }
        }
        assert (node == header2 && loopBody.size() == 1 || loopBody.get(loopBody.size() - 2) == node);
        assert (loopBody.get(loopBody.size() - 1) == header2);
        return loopBody;
    }

    private List<Stmt> union(List<Stmt> l1, List<Stmt> l2) {
        for (Stmt next2 : l2) {
            if (l1.contains(next2)) continue;
            l1.add(next2);
        }
        return l1;
    }
}

