/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.TreeSet;
import soot.G;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.TopoSorter;
import soot.util.queue.QueueReader;

public final class PropWorklist
extends Propagator {
    protected final Set<VarNode> varNodeWorkList = new TreeSet<VarNode>();
    protected PAG pag;
    protected OnFlyCallGraph ofcg;

    public PropWorklist(PAG pag) {
        this.pag = pag;
    }

    @Override
    public final void propagate() {
        this.ofcg = this.pag.getOnFlyCallGraph();
        new TopoSorter(this.pag, false).sort();
        for (AllocNode object : this.pag.allocSources()) {
            this.handleAllocNode(object);
        }
        boolean verbose = this.pag.getOpts().verbose();
        do {
            if (verbose) {
                G.v().out.println("Worklist has " + this.varNodeWorkList.size() + " nodes.");
            }
            while (!this.varNodeWorkList.isEmpty()) {
                VarNode src = this.varNodeWorkList.iterator().next();
                this.varNodeWorkList.remove(src);
                this.handleVarNode(src);
            }
            if (verbose) {
                G.v().out.println("Now handling field references");
            }
            for (Object e : this.pag.storeSources()) {
                Node[] targets;
                final VarNode src = (VarNode)e;
                for (Node element0 : targets = this.pag.storeLookup(src)) {
                    final FieldRefNode target = (FieldRefNode)element0;
                    target.getBase().makeP2Set().forall(new P2SetVisitor(){

                        @Override
                        public final void visit(Node n) {
                            AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, target.getField());
                            nDotF.makeP2Set().addAll(src.getP2Set(), null);
                        }
                    });
                }
            }
            HashSet<Object[]> edgesToPropagate = new HashSet<Object[]>();
            for (FieldRefNode object3 : this.pag.loadSources()) {
                this.handleFieldRefNode(object3, edgesToPropagate);
            }
            Set<PointsToSetInternal> set2 = Collections.newSetFromMap(new IdentityHashMap());
            for (Object[] pair : edgesToPropagate) {
                PointsToSetInternal nDotF = (PointsToSetInternal)pair[0];
                PointsToSetInternal newP2Set = nDotF.getNewSet();
                VarNode loadTarget = (VarNode)pair[1];
                if (loadTarget.makeP2Set().addAll(newP2Set, null)) {
                    this.varNodeWorkList.add(loadTarget);
                }
                set2.add(nDotF);
            }
            for (PointsToSetInternal nDotF : set2) {
                nDotF.flushNew();
            }
        } while (!this.varNodeWorkList.isEmpty());
    }

    protected final boolean handleAllocNode(AllocNode src) {
        Node[] targets;
        boolean ret = false;
        for (Node element2 : targets = this.pag.allocLookup(src)) {
            if (!element2.makeP2Set().add(src)) continue;
            this.varNodeWorkList.add((VarNode)element2);
            ret = true;
        }
        return ret;
    }

    protected final boolean handleVarNode(VarNode src) {
        Node[] storeTargets;
        boolean ret = false;
        boolean flush2 = true;
        if (src.getReplacement() != src) {
            throw new RuntimeException("Got bad node " + src + " with rep " + src.getReplacement());
        }
        final PointsToSetInternal newP2Set = src.getP2Set().getNewSet();
        if (newP2Set.isEmpty()) {
            return false;
        }
        if (this.ofcg != null) {
            QueueReader<Node> addedEdges = this.pag.edgeReader();
            this.ofcg.updatedNode(src);
            this.ofcg.build();
            while (addedEdges.hasNext()) {
                VarNode edgeTgt;
                Node edgeSrc;
                Node addedSrc = addedEdges.next();
                Node addedTgt = addedEdges.next();
                ret = true;
                if (addedSrc instanceof VarNode) {
                    if (!(addedTgt instanceof VarNode)) continue;
                    edgeSrc = (VarNode)addedSrc.getReplacement();
                    edgeTgt = (VarNode)addedTgt.getReplacement();
                    if (!edgeTgt.makeP2Set().addAll(edgeSrc.getP2Set(), null)) continue;
                    this.varNodeWorkList.add(edgeTgt);
                    if (edgeTgt != src) continue;
                    flush2 = false;
                    continue;
                }
                if (!(addedSrc instanceof AllocNode)) continue;
                edgeSrc = (AllocNode)addedSrc;
                edgeTgt = (VarNode)addedTgt.getReplacement();
                if (!edgeTgt.makeP2Set().add(edgeSrc)) continue;
                this.varNodeWorkList.add(edgeTgt);
                if (edgeTgt != src) continue;
                flush2 = false;
            }
        }
        Node[] simpleTargets = this.pag.simpleLookup(src);
        for (Node element2 : simpleTargets) {
            if (!element2.makeP2Set().addAll(newP2Set, null)) continue;
            this.varNodeWorkList.add((VarNode)element2);
            if (element2 == src) {
                flush2 = false;
            }
            ret = true;
        }
        for (Node element3 : storeTargets = this.pag.storeLookup(src)) {
            FieldRefNode fr = (FieldRefNode)element3;
            final SparkField f = fr.getField();
            ret = fr.getBase().getP2Set().forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, f);
                    if (nDotF.makeP2Set().addAll(newP2Set, null)) {
                        this.returnValue = true;
                    }
                }
            }) | ret;
        }
        final HashSet storesToPropagate = new HashSet();
        final HashSet loadsToPropagate = new HashSet();
        for (FieldRefNode fr : src.getAllFieldRefs()) {
            Node[] loadTargets;
            final SparkField field2 = fr.getField();
            final Node[] storeSources = this.pag.storeInvLookup(fr);
            if (storeSources.length > 0) {
                newP2Set.forall(new P2SetVisitor(){

                    @Override
                    public final void visit(Node n) {
                        AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, field2);
                        for (Node element2 : storeSources) {
                            Node[] pair = new Node[]{element2, nDotF.getReplacement()};
                            storesToPropagate.add(pair);
                        }
                    }
                });
            }
            if ((loadTargets = this.pag.loadLookup(fr)).length <= 0) continue;
            newP2Set.forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, field2);
                    if (nDotF != null) {
                        for (Node element2 : loadTargets) {
                            Node[] pair = new Node[]{nDotF.getReplacement(), element2};
                            loadsToPropagate.add(pair);
                        }
                    }
                }
            });
        }
        if (flush2) {
            src.getP2Set().flushNew();
        }
        for (Node[] p : storesToPropagate) {
            VarNode storeSource = (VarNode)p[0];
            AllocDotField nDotF = (AllocDotField)p[1];
            if (!nDotF.makeP2Set().addAll(storeSource.getP2Set(), null)) continue;
            ret = true;
        }
        for (Node[] p : loadsToPropagate) {
            AllocDotField nDotF = (AllocDotField)p[0];
            VarNode loadTarget = (VarNode)p[1];
            if (!loadTarget.makeP2Set().addAll(nDotF.getP2Set(), null)) continue;
            this.varNodeWorkList.add(loadTarget);
            ret = true;
        }
        return ret;
    }

    protected final void handleFieldRefNode(FieldRefNode src, final HashSet<Object[]> edgesToPropagate) {
        final Node[] loadTargets = this.pag.loadLookup(src);
        if (loadTargets.length == 0) {
            return;
        }
        final SparkField field2 = src.getField();
        src.getBase().getP2Set().forall(new P2SetVisitor(){

            @Override
            public final void visit(Node n) {
                PointsToSetInternal p2Set;
                AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, field2);
                if (nDotF != null && !(p2Set = nDotF.getP2Set()).getNewSet().isEmpty()) {
                    for (Node element2 : loadTargets) {
                        Object[] pair = new Object[]{p2Set, element2};
                        edgesToPropagate.add(pair);
                    }
                }
            }
        });
    }
}

