/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.Context;
import soot.PhaseOptions;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.ContextVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.options.CGOptions;

public class AllocNode
extends Node
implements Context {
    protected Object newExpr;
    protected Map<SparkField, AllocDotField> fields;
    private SootMethod method;

    public Object getNewExpr() {
        return this.newExpr;
    }

    public Collection<AllocDotField> getAllFieldRefs() {
        if (this.fields == null) {
            return Collections.emptySet();
        }
        return this.fields.values();
    }

    public AllocDotField dot(SparkField field2) {
        return this.fields == null ? null : this.fields.get(field2);
    }

    public String toString() {
        return "AllocNode " + this.getNumber() + " " + this.newExpr + " in method " + this.method;
    }

    AllocNode(PAG pag, Object newExpr, Type t, SootMethod m) {
        super(pag, t);
        RefType rt;
        this.method = m;
        if (t instanceof RefType && (rt = (RefType)t).getSootClass().isAbstract()) {
            boolean usesReflectionLog;
            boolean bl = usesReflectionLog = new CGOptions(PhaseOptions.v().getPhaseOptions("cg")).reflection_log() != null;
            if (!usesReflectionLog) {
                throw new RuntimeException("Attempt to create allocnode with abstract type " + t);
            }
        }
        this.newExpr = newExpr;
        if (newExpr instanceof ContextVarNode) {
            throw new RuntimeException();
        }
        pag.getAllocNodeNumberer().add(this);
    }

    void addField(AllocDotField adf, SparkField field2) {
        if (this.fields == null) {
            this.fields = new HashMap<SparkField, AllocDotField>();
        }
        this.fields.put(field2, adf);
    }

    public Set<AllocDotField> getFields() {
        if (this.fields == null) {
            return Collections.emptySet();
        }
        return new HashSet<AllocDotField>(this.fields.values());
    }

    public SootMethod getMethod() {
        return this.method;
    }
}

