/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.ondemand.genericutil;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import soot.jimple.spark.ondemand.genericutil.MultiMap;

abstract class AbstractMultiMap<K, V>
implements MultiMap<K, V> {
    protected final Map<K, Set<V>> map = new HashMap<K, Set<V>>();
    protected final boolean create;

    protected AbstractMultiMap(boolean create) {
        this.create = create;
    }

    protected abstract Set<V> createSet();

    protected Set<V> emptySet() {
        return Collections.emptySet();
    }

    @Override
    public Set<V> get(K key2) {
        Set<V> ret = this.map.get(key2);
        if (ret == null) {
            if (this.create) {
                ret = this.createSet();
                this.map.put(key2, ret);
            } else {
                ret = this.emptySet();
            }
        }
        return ret;
    }

    @Override
    public boolean put(K key2, V val) {
        Set<V> vals = this.map.get(key2);
        if (vals == null) {
            vals = this.createSet();
            this.map.put(key2, vals);
        }
        return vals.add(val);
    }

    @Override
    public boolean remove(K key2, V val) {
        Set<V> elems = this.map.get(key2);
        if (elems == null) {
            return false;
        }
        boolean ret = elems.remove(val);
        if (elems.isEmpty()) {
            this.map.remove(key2);
        }
        return ret;
    }

    @Override
    public Set<V> removeAll(K key2) {
        return this.map.remove(key2);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean containsKey(K key2) {
        return this.map.containsKey(key2);
    }

    @Override
    public int size() {
        int ret = 0;
        for (K key2 : this.keySet()) {
            ret += this.get(key2).size();
        }
        return ret;
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean putAll(K key2, Collection<? extends V> vals) {
        Set<V> edges = this.map.get(key2);
        if (edges == null) {
            edges = this.createSet();
            this.map.put(key2, edges);
        }
        return edges.addAll(vals);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

