/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.builder;

import soot.AnySubType;
import soot.ArrayType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.ContextVarNode;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;
import soot.toolkits.scalar.Pair;

public class GlobalNodeFactory {
    protected PAG pag;

    public GlobalNodeFactory(PAG pag) {
        this.pag = pag;
    }

    public final Node caseDefaultClassLoader() {
        AllocNode a2 = this.pag.makeAllocNode("DEFAULT_CLASS_LOADER", AnySubType.v(RefType.v("java.lang.ClassLoader")), null);
        GlobalVarNode v = this.pag.makeGlobalVarNode("DEFAULT_CLASS_LOADER_LOCAL", RefType.v("java.lang.ClassLoader"));
        this.pag.addEdge(a2, v);
        return v;
    }

    public final Node caseMainClassNameString() {
        AllocNode a2 = this.pag.makeAllocNode("MAIN_CLASS_NAME_STRING", RefType.v("java.lang.String"), null);
        GlobalVarNode v = this.pag.makeGlobalVarNode("MAIN_CLASS_NAME_STRING_LOCAL", RefType.v("java.lang.String"));
        this.pag.addEdge(a2, v);
        return v;
    }

    public final Node caseMainThreadGroup() {
        AllocNode threadGroupNode = this.pag.makeAllocNode("MAIN_THREAD_GROUP_NODE", RefType.v("java.lang.ThreadGroup"), null);
        GlobalVarNode threadGroupNodeLocal = this.pag.makeGlobalVarNode("MAIN_THREAD_GROUP_NODE_LOCAL", RefType.v("java.lang.ThreadGroup"));
        this.pag.addEdge(threadGroupNode, threadGroupNodeLocal);
        return threadGroupNodeLocal;
    }

    public final Node casePrivilegedActionException() {
        AllocNode a2 = this.pag.makeAllocNode("PRIVILEGED_ACTION_EXCEPTION", AnySubType.v(RefType.v("java.security.PrivilegedActionException")), null);
        GlobalVarNode v = this.pag.makeGlobalVarNode("PRIVILEGED_ACTION_EXCEPTION_LOCAL", RefType.v("java.security.PrivilegedActionException"));
        this.pag.addEdge(a2, v);
        return v;
    }

    public final Node caseCanonicalPath() {
        AllocNode a2 = this.pag.makeAllocNode("CANONICAL_PATH", RefType.v("java.lang.String"), null);
        GlobalVarNode v = this.pag.makeGlobalVarNode("CANONICAL_PATH_LOCAL", RefType.v("java.lang.String"));
        this.pag.addEdge(a2, v);
        return v;
    }

    public final Node caseMainThread() {
        AllocNode threadNode = this.pag.makeAllocNode("MAIN_THREAD_NODE", RefType.v("java.lang.Thread"), null);
        GlobalVarNode threadNodeLocal = this.pag.makeGlobalVarNode("MAIN_THREAD_NODE_LOCAL", RefType.v("java.lang.Thread"));
        this.pag.addEdge(threadNode, threadNodeLocal);
        return threadNodeLocal;
    }

    public final Node caseFinalizeQueue() {
        return this.pag.makeGlobalVarNode("FINALIZE_QUEUE", RefType.v("java.lang.Object"));
    }

    public final Node caseArgv() {
        AllocNode argv = this.pag.makeAllocNode("STRING_ARRAY_NODE", ArrayType.v(RefType.v("java.lang.String"), 1), null);
        GlobalVarNode sanl = this.pag.makeGlobalVarNode("STRING_ARRAY_NODE_LOCAL", ArrayType.v(RefType.v("java.lang.String"), 1));
        AllocNode stringNode = this.pag.makeAllocNode("STRING_NODE", RefType.v("java.lang.String"), null);
        GlobalVarNode stringNodeLocal = this.pag.makeGlobalVarNode("STRING_NODE_LOCAL", RefType.v("java.lang.String"));
        this.pag.addEdge(argv, sanl);
        this.pag.addEdge(stringNode, stringNodeLocal);
        this.pag.addEdge(stringNodeLocal, this.pag.makeFieldRefNode(sanl, ArrayElement.v()));
        return sanl;
    }

    public final Node caseNewInstance(VarNode cls) {
        if (cls instanceof ContextVarNode) {
            cls = this.pag.findLocalVarNode(cls.getVariable());
        }
        GlobalVarNode local = this.pag.makeGlobalVarNode(cls, RefType.v("java.lang.Object"));
        for (SootClass cl : Scene.v().dynamicClasses()) {
            AllocNode site = this.pag.makeAllocNode(new Pair<VarNode, SootClass>(cls, cl), cl.getType(), null);
            this.pag.addEdge(site, local);
        }
        return local;
    }

    public Node caseThrow() {
        GlobalVarNode ret = this.pag.makeGlobalVarNode("EXCEPTION_NODE", RefType.v("java.lang.Throwable"));
        ret.setInterProcTarget();
        ret.setInterProcSource();
        return ret;
    }
}

