/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.MethodOrMethodContext;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.dexpler.DalvikThrowAnalysis;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.NopStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.infoflow.entryPointCreators.BaseEntryPointCreator;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.source.ISourceSinkManager;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;
import soot.options.Options;
import soot.toolkits.exceptions.ThrowableSet;
import soot.toolkits.exceptions.UnitThrowAnalysis;
import soot.util.queue.QueueReader;

public class InterproceduralConstantValuePropagator
extends SceneTransformer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IInfoflowCFG icfg;
    private final Set<SootMethod> excludedMethods;
    private final ISourceSinkManager sourceSinkManager;
    private final ITaintPropagationWrapper taintWrapper;
    private boolean removeSideEffectFreeMethods = true;
    protected final Map<SootMethod, Boolean> methodSideEffects = new ConcurrentHashMap<SootMethod, Boolean>();
    protected final Map<SootMethod, Boolean> methodSinks = new ConcurrentHashMap<SootMethod, Boolean>();
    protected final Map<SootMethod, Boolean> methodFieldReads = new ConcurrentHashMap<SootMethod, Boolean>();
    protected SootClass exceptionClass = null;
    protected final Map<SootClass, SootMethod> exceptionThrowers = new HashMap<SootClass, SootMethod>();

    public InterproceduralConstantValuePropagator(IInfoflowCFG icfg) {
        this.icfg = icfg;
        this.excludedMethods = null;
        this.sourceSinkManager = null;
        this.taintWrapper = null;
    }

    public InterproceduralConstantValuePropagator(IInfoflowCFG icfg, Collection<SootMethod> excludedMethods, ISourceSinkManager sourceSinkManager, ITaintPropagationWrapper taintWrapper) {
        this.icfg = icfg;
        this.excludedMethods = new HashSet<SootMethod>(excludedMethods);
        this.sourceSinkManager = sourceSinkManager;
        this.taintWrapper = taintWrapper;
    }

    public void setRemoveSideEffectFreeMethods(boolean removeSideEffectFreeMethods) {
        this.removeSideEffectFreeMethods = removeSideEffectFreeMethods;
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        this.logger.info("Removing side-effect free methods is " + (this.removeSideEffectFreeMethods ? "enabled" : "disabled"));
        QueueReader<MethodOrMethodContext> rdr = Scene.v().getReachableMethods().listener();
        while (rdr.hasNext()) {
            MethodOrMethodContext mom = rdr.next();
            SootMethod sm = mom.method();
            if (sm == null || !sm.hasActiveBody() || this.excludedMethods != null && this.excludedMethods.contains(sm) || SystemClassHandler.isClassInSystemPackage(sm.getDeclaringClass().getName()) || sm.getReturnType() == VoidType.v() && sm.getParameterCount() <= 0) continue;
            if (sm.getParameterCount() > 0) {
                this.propagateConstantsIntoCallee(sm);
            }
            if (!this.typeSupportsConstants(sm.getReturnType())) continue;
            this.propagateReturnValueIntoCallers(sm);
        }
        if (this.removeSideEffectFreeMethods) {
            int callEdgesRemoved = 0;
            QueueReader<MethodOrMethodContext> rdr2 = Scene.v().getReachableMethods().listener();
            while (rdr2.hasNext()) {
                MethodOrMethodContext mom = rdr2.next();
                SootMethod sm = mom.method();
                if (sm == null || !sm.hasActiveBody() || this.excludedMethods != null && this.excludedMethods.contains(sm)) continue;
                Iterator<Unit> unitIt = sm.getActiveBody().getUnits().snapshotIterator();
                while (unitIt.hasNext()) {
                    Stmt s2 = (Stmt)unitIt.next();
                    if (!sm.getActiveBody().getUnits().contains(s2) || !(s2 instanceof InvokeStmt) || this.exceptionClass != null && s2.getInvokeExpr().getMethod().getDeclaringClass() == this.exceptionClass || this.getNonConstParamCount(s2) > 0) continue;
                    boolean allCalleesRemoved = true;
                    HashSet<SootClass> exceptions = new HashSet<SootClass>();
                    Iterator<Edge> edgeIt = Scene.v().getCallGraph().edgesOutOf(s2);
                    while (edgeIt.hasNext()) {
                        Edge edge = edgeIt.next();
                        SootMethod callee = edge.tgt();
                        boolean remove = callee.getReturnType() == VoidType.v() && !this.hasSideEffectsOrReadsThis(callee);
                        if (remove |= !this.hasSideEffectsOrCallsSink(callee)) {
                            Scene.v().getCallGraph().removeEdge(edge);
                            ++callEdgesRemoved;
                            this.fixExceptions(sm, s2, exceptions);
                            continue;
                        }
                        if (sm.getName().equals("<clinit>")) continue;
                        allCalleesRemoved = false;
                    }
                    if (!allCalleesRemoved || this.isSourceSinkOrTaintWrapped(s2)) continue;
                    this.removeCallSite(s2, sm);
                }
            }
            System.out.println("Removed " + callEdgesRemoved + " call edges");
        }
        if (this.exceptionClass != null) {
            Scene.v().releaseActiveHierarchy();
            Scene.v().releaseFastHierarchy();
            Scene.v().getOrMakeFastHierarchy();
        }
    }

    private int getNonConstParamCount(Stmt s2) {
        int cnt = 0;
        for (Value val : s2.getInvokeExpr().getArgs()) {
            if (val instanceof Constant) continue;
            ++cnt;
        }
        return cnt;
    }

    private boolean isSourceSinkOrTaintWrapped(Stmt callSite) {
        if (!callSite.containsInvokeExpr()) {
            return false;
        }
        SootMethod method = callSite.getInvokeExpr().getMethod();
        if (this.sourceSinkManager != null && this.sourceSinkManager.getSourceInfo(callSite, this.icfg) != null) {
            this.methodFieldReads.put(method, true);
            return true;
        }
        if (this.sourceSinkManager != null && this.sourceSinkManager.isSink(callSite, this.icfg, null)) {
            this.methodSinks.put(method, true);
            return true;
        }
        if (this.taintWrapper != null && this.taintWrapper.supportsCallee(method)) {
            this.methodSideEffects.put(method, true);
            return true;
        }
        return false;
    }

    private void removeCallSite(Stmt callSite, SootMethod caller) {
        if (!caller.getActiveBody().getUnits().contains(callSite)) {
            return;
        }
        if (!callSite.containsInvokeExpr()) {
            return;
        }
        caller.getActiveBody().getUnits().remove(callSite);
        if (Scene.v().hasCallGraph()) {
            Scene.v().getCallGraph().removeAllEdgesOutOf(callSite);
        }
    }

    private boolean typeSupportsConstants(Type returnType) {
        if (returnType == IntType.v() || returnType == LongType.v() || returnType == FloatType.v() || returnType == DoubleType.v()) {
            return true;
        }
        return returnType instanceof RefType && ((RefType)returnType).getClassName().equals("java.lang.String");
    }

    private void propagateReturnValueIntoCallers(SootMethod sm) {
        Constant value2 = null;
        for (Unit retSite : this.icfg.getEndPointsOf(sm)) {
            if (!(retSite instanceof ReturnStmt)) continue;
            ReturnStmt retStmt = (ReturnStmt)retSite;
            if (!(retStmt.getOp() instanceof Constant)) {
                return;
            }
            if (value2 != null && retStmt.getOp() != value2) {
                return;
            }
            value2 = (Constant)retStmt.getOp();
        }
        if (value2 != null) {
            for (Unit callSite : this.icfg.getCallersOf(sm)) {
                SootMethod caller;
                if (!(callSite instanceof AssignStmt)) continue;
                AssignStmt assign = (AssignStmt)callSite;
                if (this.taintWrapper != null && this.taintWrapper.supportsCallee(assign) || this.sourceSinkManager != null && this.sourceSinkManager.getSourceInfo(assign, this.icfg) != null || !(caller = (SootMethod)this.icfg.getMethodOf(assign)).getActiveBody().getUnits().contains(assign) || this.icfg.getCalleesOfCallAt(callSite).size() > 1) continue;
                AssignStmt assignConst = Jimple.v().newAssignStmt(assign.getLeftOp(), value2);
                if (!this.hasSideEffectsOrCallsSink(sm)) {
                    this.fixExceptions(caller, callSite);
                    caller.getActiveBody().getUnits().swapWith(assign, assignConst);
                    if (this.excludedMethods == null || !this.excludedMethods.contains(caller)) {
                        ConstantPropagatorAndFolder.v().transform(caller.getActiveBody());
                    }
                    if (!Scene.v().hasCallGraph()) continue;
                    Scene.v().getCallGraph().removeAllEdgesOutOf(assign);
                    continue;
                }
                caller.getActiveBody().getUnits().insertAfter(assignConst, (Unit)assign);
                if (this.excludedMethods == null || !this.excludedMethods.contains(caller)) {
                    ConstantPropagatorAndFolder.v().transform(caller.getActiveBody());
                }
                caller.getActiveBody().getUnits().remove(assignConst);
                InvokeStmt inv = Jimple.v().newInvokeStmt(assign.getInvokeExpr());
                caller.getActiveBody().getUnits().swapWith(assign, inv);
                if (!Scene.v().hasCallGraph()) continue;
                Scene.v().getCallGraph().swapEdgesOutOf(assign, inv);
            }
        }
    }

    private void fixExceptions(SootMethod caller, Unit callSite) {
        this.fixExceptions(caller, callSite, new HashSet<SootClass>());
    }

    private void fixExceptions(SootMethod caller, Unit callSite, Set<SootClass> doneSet) {
        UnitThrowAnalysis ta = Options.v().src_prec() == 5 ? DalvikThrowAnalysis.v() : UnitThrowAnalysis.v();
        ThrowableSet throwSet = ta.mightThrow(callSite);
        for (final Trap t : caller.getActiveBody().getTraps()) {
            if (!doneSet.add(t.getException()) || !throwSet.catchableAs(t.getException().getType())) continue;
            SootMethod thrower = this.exceptionThrowers.get(t.getException());
            if (thrower == null) {
                if (this.exceptionClass == null) {
                    this.exceptionClass = new SootClass("FLOWDROID_EXCEPTIONS", 1);
                    Scene.v().addClass(this.exceptionClass);
                }
                thrower = new SootMethod("throw" + this.exceptionThrowers.size(), Collections.emptyList(), VoidType.v());
                thrower.setModifiers(9);
                final JimpleBody body = Jimple.v().newBody(thrower);
                thrower.setActiveBody(body);
                final SootMethod meth = thrower;
                BaseEntryPointCreator epc = new BaseEntryPointCreator(){

                    @Override
                    public Collection<String> getRequiredClasses() {
                        return Collections.emptySet();
                    }

                    @Override
                    protected SootMethod createDummyMainInternal(SootMethod emptySootMethod) {
                        LocalGenerator generator = new LocalGenerator(body);
                        int conditionCounter = 0;
                        Local intCounter = generator.generateLocal(IntType.v());
                        JAssignStmt assignStmt = new JAssignStmt(intCounter, IntConstant.v(conditionCounter));
                        body.getUnits().add(assignStmt);
                        NopStmt afterEx = Jimple.v().newNopStmt();
                        IfStmt ifStmt = Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr(intCounter, IntConstant.v(conditionCounter)), afterEx);
                        body.getUnits().add(ifStmt);
                        ++conditionCounter;
                        Local lcEx = generator.generateLocal(t.getException().getType());
                        AssignStmt assignNewEx = Jimple.v().newAssignStmt(lcEx, Jimple.v().newNewExpr(t.getException().getType()));
                        body.getUnits().add(assignNewEx);
                        InvokeStmt consNewEx = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(lcEx, Scene.v().makeConstructorRef(InterproceduralConstantValuePropagator.this.exceptionClass, Collections.emptyList())));
                        body.getUnits().add(consNewEx);
                        ThrowStmt throwNewEx = Jimple.v().newThrowStmt(lcEx);
                        body.getUnits().add(throwNewEx);
                        body.getUnits().add(afterEx);
                        return meth;
                    }
                };
                epc.createDummyMain(thrower);
                this.exceptionThrowers.put(t.getException(), thrower);
                this.exceptionClass.addMethod(thrower);
            }
            InvokeStmt throwCall = Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(thrower.makeRef()));
            caller.getActiveBody().getUnits().insertBefore(throwCall, callSite);
        }
    }

    private boolean hasSideEffectsOrCallsSink(SootMethod method) {
        return this.hasSideEffectsOrCallsSink(method, new HashSet<SootMethod>());
    }

    private boolean hasSideEffectsOrCallsSink(SootMethod method, Set<SootMethod> runList) {
        if (!method.hasActiveBody()) {
            return false;
        }
        Boolean hasSideEffects = this.methodSideEffects.get(method);
        if (hasSideEffects != null) {
            return hasSideEffects;
        }
        Boolean hasSink = this.methodSinks.get(method);
        if (hasSink != null) {
            return hasSink;
        }
        if (!runList.add(method)) {
            return false;
        }
        if (this.methodIsAndroidStub(method)) {
            this.methodSideEffects.put(method, false);
            return false;
        }
        for (Unit u : method.getActiveBody().getUnits()) {
            AssignStmt assign;
            if (u instanceof AssignStmt && ((assign = (AssignStmt)u).getLeftOp() instanceof FieldRef || assign.getLeftOp() instanceof ArrayRef)) {
                this.methodSideEffects.put(method, true);
                return true;
            }
            Stmt s2 = (Stmt)u;
            if (this.taintWrapper != null && this.taintWrapper.supportsCallee(s2)) {
                this.methodSideEffects.put(method, true);
                return true;
            }
            if (!s2.containsInvokeExpr()) continue;
            if (this.sourceSinkManager != null && this.sourceSinkManager.isSink((Stmt)u, this.icfg, null)) {
                this.methodSinks.put(method, true);
                return true;
            }
            Iterator<Edge> edgeIt = Scene.v().getCallGraph().edgesOutOf(u);
            while (edgeIt.hasNext()) {
                Edge e = edgeIt.next();
                if (!this.hasSideEffectsOrCallsSink(e.getTgt().method(), runList)) continue;
                return true;
            }
        }
        this.methodSideEffects.put(method, false);
        return false;
    }

    private boolean hasSideEffectsOrReadsThis(SootMethod method) {
        return this.hasSideEffectsOrReadsThis(method, new HashSet<SootMethod>());
    }

    private boolean hasSideEffectsOrReadsThis(SootMethod method, Set<SootMethod> runList) {
        if (!method.hasActiveBody()) {
            return false;
        }
        Boolean hasSideEffects = this.methodSideEffects.get(method);
        if (hasSideEffects != null) {
            return hasSideEffects;
        }
        if (!runList.add(method)) {
            return false;
        }
        if (this.methodIsAndroidStub(method)) {
            this.methodSideEffects.put(method, false);
            return false;
        }
        Local thisLocal = method.isStatic() ? null : method.getActiveBody().getThisLocal();
        for (Unit u : method.getActiveBody().getUnits()) {
            AssignStmt assign;
            if (u instanceof AssignStmt && ((assign = (AssignStmt)u).getLeftOp() instanceof FieldRef || assign.getLeftOp() instanceof ArrayRef)) {
                this.methodSideEffects.put(method, true);
                return true;
            }
            Stmt s2 = (Stmt)u;
            if (thisLocal != null) {
                for (ValueBox vb : s2.getUseBoxes()) {
                    if (vb.getValue() != thisLocal) continue;
                    return true;
                }
            }
            if (!s2.containsInvokeExpr()) continue;
            Iterator<Edge> edgeIt = Scene.v().getCallGraph().edgesOutOf(u);
            while (edgeIt.hasNext()) {
                Edge e = edgeIt.next();
                if (!this.hasSideEffectsOrReadsThis(e.getTgt().method(), runList)) continue;
                return true;
            }
        }
        this.methodSideEffects.put(method, false);
        return false;
    }

    private boolean methodIsAndroidStub(SootMethod method) {
        if (Options.v().src_prec() != 5 || !method.getDeclaringClass().isLibraryClass() || !SystemClassHandler.isClassInSystemPackage(method.getDeclaringClass().getName())) {
            return false;
        }
        for (Unit u : method.getActiveBody().getUnits()) {
            InvokeStmt stmt;
            SootMethod callee;
            DefinitionStmt defStmt;
            if (!(u instanceof DefinitionStmt ? !((defStmt = (DefinitionStmt)u).getRightOp() instanceof ThisRef) && !(defStmt.getRightOp() instanceof ParameterRef) && !(defStmt.getRightOp() instanceof NewExpr) : (u instanceof InvokeStmt ? !(callee = (stmt = (InvokeStmt)u).getInvokeExpr().getMethod()).getSubSignature().equals("void <init>(java.lang.String)") && (!method.getDeclaringClass().hasSuperclass() || callee.getDeclaringClass() != method.getDeclaringClass().getSuperclass() || !callee.getName().equals("<init>")) : !(u instanceof ThrowStmt)))) continue;
            return false;
        }
        return true;
    }

    private void propagateConstantsIntoCallee(SootMethod sm) {
        Collection callSites = this.icfg.getCallersOf(sm);
        if (callSites.isEmpty()) {
            return;
        }
        boolean[] isConstant = new boolean[sm.getParameterCount()];
        Constant[] values2 = new Constant[sm.getParameterCount()];
        for (int i = 0; i < isConstant.length; ++i) {
            isConstant[i] = true;
        }
        boolean hasCallSites = false;
        for (Unit callSite : callSites) {
            if (this.excludedMethods != null && this.excludedMethods.contains(this.icfg.getMethodOf(callSite))) continue;
            InvokeExpr invokeExpr = ((Stmt)callSite).getInvokeExpr();
            hasCallSites = true;
            for (int i = 0; i < invokeExpr.getArgCount(); ++i) {
                Value argVal = invokeExpr.getArg(i);
                if (argVal instanceof Constant) {
                    if (values2[i] != null && !values2[i].equals(argVal)) {
                        isConstant[i] = false;
                        continue;
                    }
                    values2[i] = (Constant)argVal;
                    continue;
                }
                isConstant[i] = false;
            }
        }
        if (hasCallSites) {
            ArrayList<AssignStmt> inserted = null;
            for (int i = 0; i < isConstant.length; ++i) {
                if (!isConstant[i]) continue;
                Local local = sm.getActiveBody().getParameterLocal(i);
                Unit point = this.getFirstNonIdentityStmt(sm);
                AssignStmt assignConst = Jimple.v().newAssignStmt(local, values2[i]);
                sm.getActiveBody().getUnits().insertBefore(assignConst, point);
                if (inserted == null) {
                    inserted = new ArrayList<AssignStmt>();
                }
                inserted.add(assignConst);
            }
            if (inserted != null) {
                ConstantPropagatorAndFolder.v().transform(sm.getActiveBody());
                for (Unit unit : inserted) {
                    sm.getActiveBody().getUnits().remove(unit);
                }
            }
        }
    }

    private Unit getFirstNonIdentityStmt(SootMethod sm) {
        for (Unit u : sm.getActiveBody().getUnits()) {
            if (!(u instanceof IdentityStmt)) {
                return u;
            }
            IdentityStmt id = (IdentityStmt)u;
            if (id.getRightOp() instanceof ThisRef || id.getRightOp() instanceof ParameterRef) continue;
            return u;
        }
        return null;
    }
}

