/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.entryPointCreators;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import soot.Body;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.Jimple;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.entryPointCreators.BaseEntryPointCreator;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;

public class SequentialEntryPointCreator
extends BaseEntryPointCreator {
    private final Collection<String> methodsToCall;

    public SequentialEntryPointCreator(Collection<String> methodsToCall) {
        this.methodsToCall = methodsToCall;
    }

    @Override
    public Collection<String> getRequiredClasses() {
        return SootMethodRepresentationParser.v().parseClassNames(this.methodsToCall, false).keySet();
    }

    @Override
    protected SootMethod createDummyMainInternal(SootMethod mainMethod) {
        HashMap<String, Set<String>> classMap = SootMethodRepresentationParser.v().parseClassNames(this.methodsToCall, false);
        Body body = mainMethod.getActiveBody();
        LocalGenerator generator = new LocalGenerator(body);
        for (String className : classMap.keySet()) {
            SootClass createdClass = Scene.v().forceResolve(className, 3);
            createdClass.setApplicationClass();
            Local localVal = this.generateClassConstructor(createdClass, body);
            if (localVal == null) {
                this.logger.warn("Cannot generate constructor for class: {}", (Object)createdClass);
                continue;
            }
            for (String method : (Set)classMap.get(className)) {
                SootMethodAndClass methodAndClass = SootMethodRepresentationParser.v().parseSootMethodString(method);
                SootMethod methodToInvoke = this.findMethod(Scene.v().getSootClass(methodAndClass.getClassName()), methodAndClass.getSubSignature());
                if (methodToInvoke == null) {
                    System.err.println("Method " + methodAndClass + " not found, skipping");
                    continue;
                }
                if (!methodToInvoke.isConcrete()) continue;
                methodToInvoke.retrieveActiveBody();
                this.buildMethodCall(methodToInvoke, body, localVal, generator);
            }
        }
        body.getUnits().add(Jimple.v().newReturnVoidStmt());
        return mainMethod;
    }
}

