/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.entryPointCreators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.k33nteam.JadeCfg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.IntType;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.entryPointCreators.AndroidEntryPointConstants;
import soot.jimple.infoflow.entryPointCreators.BaseEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JEqExpr;
import soot.jimple.internal.JIfStmt;
import soot.jimple.internal.JNopStmt;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.options.Options;

public class AndroidEntryPointCreator
extends BaseEntryPointCreator
implements IEntryPointCreator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final boolean DEBUG = false;
    private JimpleBody body;
    private LocalGenerator generator;
    private int conditionCounter;
    private Value intCounter;
    private SootClass applicationClass = null;
    private Local applicationLocal = null;
    private Set<SootClass> applicationCallbackClasses = new HashSet<SootClass>();
    private final Collection<String> androidClasses;
    private final Collection<String> additionalEntryPoints;
    private Map<String, List<String>> callbackFunctions;
    private boolean modelAdditionalMethods = false;
    private Map<SootClass, ComponentType> componentTypeCache = new HashMap<SootClass, ComponentType>();

    public AndroidEntryPointCreator(Collection<String> androidClasses) {
        this.androidClasses = androidClasses;
        this.additionalEntryPoints = Collections.emptySet();
        this.callbackFunctions = new HashMap<String, List<String>>();
    }

    public AndroidEntryPointCreator(Collection<String> androidClasses, Collection<String> additionalEntryPoints) {
        this.androidClasses = androidClasses;
        this.additionalEntryPoints = additionalEntryPoints;
        this.callbackFunctions = new HashMap<String, List<String>>();
    }

    public void setCallbackFunctions(Map<String, List<String>> callbackFunctions) {
        this.callbackFunctions = callbackFunctions;
    }

    public Map<String, List<String>> getCallbackFunctions() {
        return this.callbackFunctions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    protected SootMethod createDummyMainInternal(SootMethod emptySootMethod) {
        classMap = SootMethodRepresentationParser.v().parseClassNames(this.additionalEntryPoints, false);
        for (String androidClass : this.androidClasses) {
            if (classMap.containsKey(androidClass)) continue;
            classMap.put(androidClass, new HashSet<E>());
        }
        mainMethod = emptySootMethod;
        this.body = (JimpleBody)emptySootMethod.getActiveBody();
        this.generator = new LocalGenerator(this.body);
        this.conditionCounter = 0;
        this.intCounter = this.generator.generateLocal(IntType.v());
        assignStmt = new JAssignStmt(this.intCounter, IntConstant.v(this.conditionCounter));
        this.body.getUnits().add(assignStmt);
        for (Iterator<Object> className : classMap.keySet()) {
            Scene.v().forceResolve((String)className, 2);
        }
        System.out.println("startchecking in prepareSImpleFlow");
        tomark = new ArrayList<SootClass>();
        for (SootClass sc : Scene.v().getClasses()) {
            if (sc.resolvingLevel() > 0) continue;
            tomark.add(sc);
        }
        for (SootClass sc : tomark) {
            sc.setPhantom(true);
            Scene.v().removeClass(sc);
        }
        if (JadeCfg.custom_clinit_enabled()) {
            System.out.println("adding clinit into dummyMain");
            for (SootClass currentClass : Scene.v().getClasses()) {
                if (currentClass.getName().startsWith("android") || currentClass.getName().startsWith("com.android") || currentClass.getName().startsWith("java.") || currentClass.getName().startsWith("javax.") || currentClass.getName().startsWith("org.chromium") || currentClass.getName().startsWith("org.apache") || currentClass.isPhantom()) continue;
                for (SootMethod method : currentClass.getMethods()) {
                    if (!method.getName().equals("<clinit>")) continue;
                    this.buildMethodCall(method, this.body, null, this.generator);
                }
            }
        }
        hasContentProviders = false;
        beforeContentProvidersStmt = new JNopStmt();
        this.body.getUnits().add(beforeContentProvidersStmt);
        for (String className : classMap.keySet()) {
            currentClass = Scene.v().getSootClass(className);
            if (this.getComponentType((SootClass)currentClass) != ComponentType.ContentProvider) continue;
            localVal = this.generateClassConstructor((SootClass)currentClass, this.body);
            if (localVal == null) {
                this.logger.warn("Constructor cannot be generated for {}", (Object)currentClass.getName());
                continue;
            }
            this.localVarsForClasses.put(currentClass.getName(), localVal);
            thenStmt = new JNopStmt();
            this.createIfStmt(thenStmt);
            this.buildMethodCall(this.findMethod((SootClass)currentClass, "boolean onCreate()"), this.body, localVal, this.generator);
            this.body.getUnits().add(thenStmt);
            hasContentProviders = true;
        }
        if (hasContentProviders) {
            this.createIfStmt(beforeContentProvidersStmt);
        }
        block18: for (Object entry : classMap.entrySet()) {
            currentClass = Scene.v().getSootClass((String)entry.getKey());
            extendedClasses = Scene.v().getActiveHierarchy().getSuperclassesOf(currentClass);
            for (SootClass sc : extendedClasses) {
                if (!sc.getName().equals("android.app.Application")) continue;
                if (this.applicationClass != null) {
                    throw new RuntimeException("Multiple application classes in app");
                }
                this.applicationClass = currentClass;
                this.applicationCallbackClasses.add(this.applicationClass);
                this.applicationLocal = this.generateClassConstructor(this.applicationClass, this.body);
                if (this.applicationLocal == null) {
                    this.logger.warn("Constructor cannot be generated for application class {}", (Object)this.applicationClass.getName());
                    continue;
                }
                this.localVarsForClasses.put(this.applicationClass.getName(), this.applicationLocal);
                if (this.callbackFunctions.containsKey(this.applicationClass.getName())) {
                    beforeCbCons = new JNopStmt();
                    this.body.getUnits().add(beforeCbCons);
                    for (String appCallback : this.callbackFunctions.get(this.applicationClass.getName())) {
                        thenStmt = new JNopStmt();
                        this.createIfStmt(thenStmt);
                        callbackClass = SootMethodRepresentationParser.v().parseSootMethodString(appCallback).getClassName();
                        l = (Local)this.localVarsForClasses.get(callbackClass);
                        if (l == null) {
                            theClass = Scene.v().getSootClass(callbackClass);
                            this.applicationCallbackClasses.add(theClass);
                            l = this.generateClassConstructor(theClass, this.body, Collections.singleton(this.applicationClass));
                            if (l != null) {
                                this.localVarsForClasses.put(callbackClass, l);
                            }
                        }
                        this.body.getUnits().add(thenStmt);
                    }
                    this.createIfStmt(beforeCbCons);
                }
                this.searchAndBuildMethod("void onCreate()", this.applicationClass, (Set)entry.getValue(), this.applicationLocal);
                continue block18;
            }
        }
        outerStartStmt = new JNopStmt();
        this.body.getUnits().add(outerStartStmt);
lbl107:
        // 9 sources

        block21: for (Map.Entry entry : classMap.entrySet()) {
            entryExitStmt = new JNopStmt();
            this.createIfStmt(entryExitStmt);
            currentClass = Scene.v().getSootClass((String)entry.getKey());
            currentClass.setApplicationClass();
            endClassStmt = new JNopStmt();
            try {
                componentType = this.getComponentType((SootClass)currentClass);
                instanceNeeded = componentType == ComponentType.Activity || componentType == ComponentType.Service || componentType == ComponentType.BroadcastReceiver || componentType == ComponentType.ContentProvider;
                plainMethods = new HashMap<String, SootMethod>();
                if (!instanceNeeded) {
                    for (String method : (Set)entry.getValue()) {
                        sm = null;
                        if (Scene.v().containsMethod(method)) {
                            sm = Scene.v().getMethod(method);
                        } else {
                            methodAndClass = SootMethodRepresentationParser.v().parseSootMethodString(method);
                            if (!Scene.v().containsClass(methodAndClass.getClassName())) {
                                this.logger.warn("Class for entry point {} not found, skipping...", (Object)method);
                                continue;
                            }
                            sm = this.findMethod(Scene.v().getSootClass(methodAndClass.getClassName()), methodAndClass.getSubSignature());
                            if (sm == null) {
                                this.logger.warn("Method for entry point {} not found in class, skipping...", (Object)method);
                                continue;
                            }
                        }
                        plainMethods.put(method, sm);
                        if (sm.isStatic()) continue;
                        instanceNeeded = true;
                    }
                }
                if (instanceNeeded && !this.localVarsForClasses.containsKey(currentClass.getName())) {
                    localVal = this.generateClassConstructor((SootClass)currentClass, this.body);
                    if (localVal == null) {
                        this.logger.warn("Constructor cannot be generated for {}", (Object)currentClass.getName());
                        continue;
                    }
                    this.localVarsForClasses.put(currentClass.getName(), localVal);
                }
                classLocal = (Local)this.localVarsForClasses.get(entry.getKey());
                switch (1.$SwitchMap$soot$jimple$infoflow$entryPointCreators$AndroidEntryPointCreator$ComponentType[componentType.ordinal()]) {
                    case 1: {
                        this.generateActivityLifecycle((Set)entry.getValue(), (SootClass)currentClass, endClassStmt, classLocal);
                        ** break;
                    }
                    case 2: {
                        this.generateServiceLifecycle((Set)entry.getValue(), (SootClass)currentClass, endClassStmt, classLocal);
                        ** break;
                    }
                    case 3: {
                        this.generateBroadcastReceiverLifecycle((Set)entry.getValue(), (SootClass)currentClass, endClassStmt, classLocal);
                        ** break;
                    }
                    case 4: {
                        this.generateContentProviderLifecycle((Set)entry.getValue(), (SootClass)currentClass, endClassStmt, classLocal);
                        ** break;
                    }
                    case 5: {
                        this.createIfStmt(endClassStmt);
                        beforeClassStmt = new JNopStmt();
                        this.body.getUnits().add(beforeClassStmt);
                        for (SootMethod currentMethod : plainMethods.values()) {
                            if (!currentMethod.isStatic() && classLocal == null) {
                                this.logger.warn("Skipping method {} because we have no instance", (Object)currentMethod);
                                continue;
                            }
                            thenStmt = new JNopStmt();
                            this.createIfStmt(thenStmt);
                            this.buildMethodCall(currentMethod, this.body, classLocal, this.generator);
                            this.body.getUnits().add(thenStmt);
                            this.createIfStmt(beforeClassStmt);
                        }
                        continue block21;
                    }
                    ** default:
lbl176:
                    // 1 sources

                    continue block21;
                }
            }
            finally {
                this.body.getUnits().add(endClassStmt);
                this.body.getUnits().add(entryExitStmt);
            }
        }
        if (this.applicationLocal != null) {
            beforeAppCallbacks = Jimple.v().newNopStmt();
            this.body.getUnits().add(beforeAppCallbacks);
            this.addApplicationCallbackMethods();
            this.createIfStmt(beforeAppCallbacks);
        }
        this.createIfStmt(outerStartStmt);
        if (this.applicationLocal != null) {
            this.searchAndBuildMethod("void onTerminate()", this.applicationClass, (Set)classMap.get(this.applicationClass.getName()), this.applicationLocal);
        }
        this.body.getUnits().add(Jimple.v().newReturnVoidStmt());
        NopEliminator.v().transform(this.body);
        this.eliminateSelfLoops(this.body);
        this.eliminateFallthroughIfs(this.body);
        if (Options.v().validate()) {
            mainMethod.getActiveBody().validate();
        }
        this.logger.info("Generated main method:\n{}", (Object)this.body);
        return mainMethod;
    }

    private void eliminateFallthroughIfs(Body body) {
        boolean changed = false;
        do {
            changed = false;
            IfStmt ifs = null;
            Iterator<Unit> unitIt = body.getUnits().snapshotIterator();
            while (unitIt.hasNext()) {
                Unit u = unitIt.next();
                if (ifs != null && ifs.getTarget() == u) {
                    body.getUnits().remove(ifs);
                    changed = true;
                }
                ifs = null;
                if (!(u instanceof IfStmt)) continue;
                ifs = (IfStmt)u;
            }
        } while (changed);
    }

    public ComponentType getComponentType(SootClass currentClass) {
        if (this.componentTypeCache.containsKey(currentClass)) {
            return this.componentTypeCache.get(currentClass);
        }
        ComponentType ctype = ComponentType.Plain;
        List<SootClass> extendedClasses = Scene.v().getActiveHierarchy().getSuperclassesOf(currentClass);
        for (SootClass sc : extendedClasses) {
            if (sc.getName().equals("android.app.Application")) {
                ctype = ComponentType.Application;
                break;
            }
            if (sc.getName().equals("android.app.Activity")) {
                ctype = ComponentType.Activity;
                break;
            }
            if (sc.getName().equals("android.app.Service")) {
                ctype = ComponentType.Service;
                break;
            }
            if (sc.getName().equals("android.content.BroadcastReceiver")) {
                ctype = ComponentType.BroadcastReceiver;
                break;
            }
            if (!sc.getName().equals("android.content.ContentProvider")) continue;
            ctype = ComponentType.ContentProvider;
            break;
        }
        this.componentTypeCache.put(currentClass, ctype);
        return ctype;
    }

    private void generateContentProviderLifecycle(Set<String> entryPoints, SootClass currentClass, JNopStmt endClassStmt, Local classLocal) {
        this.createIfStmt(endClassStmt);
        JNopStmt startWhileStmt = new JNopStmt();
        JNopStmt endWhileStmt = new JNopStmt();
        this.body.getUnits().add(startWhileStmt);
        this.createIfStmt(endWhileStmt);
        boolean hasAdditionalMethods = false;
        if (this.modelAdditionalMethods) {
            for (SootMethod currentMethod : currentClass.getMethods()) {
                if (!entryPoints.contains(currentMethod.toString())) continue;
                hasAdditionalMethods |= this.createPlainMethodCall(classLocal, currentMethod);
            }
        }
        this.addCallbackMethods(currentClass);
        this.body.getUnits().add(endWhileStmt);
        if (hasAdditionalMethods) {
            this.createIfStmt(startWhileStmt);
        }
    }

    private void generateBroadcastReceiverLifecycle(Set<String> entryPoints, SootClass currentClass, JNopStmt endClassStmt, Local classLocal) {
        this.createIfStmt(endClassStmt);
        Stmt onReceiveStmt = this.searchAndBuildMethod("void onReceive(android.content.Context,android.content.Intent)", currentClass, entryPoints, classLocal);
        JNopStmt startWhileStmt = new JNopStmt();
        JNopStmt endWhileStmt = new JNopStmt();
        this.body.getUnits().add(startWhileStmt);
        this.createIfStmt(endWhileStmt);
        boolean hasAdditionalMethods = false;
        if (this.modelAdditionalMethods) {
            for (SootMethod currentMethod : currentClass.getMethods()) {
                if (!entryPoints.contains(currentMethod.toString())) continue;
                hasAdditionalMethods |= this.createPlainMethodCall(classLocal, currentMethod);
            }
        }
        this.addCallbackMethods(currentClass);
        this.body.getUnits().add(endWhileStmt);
        if (hasAdditionalMethods) {
            this.createIfStmt(startWhileStmt);
        }
        this.createIfStmt(onReceiveStmt);
    }

    private void generateServiceLifecycle(Set<String> entryPoints, SootClass currentClass, JNopStmt endClassStmt, Local classLocal) {
        boolean isGCMBaseIntentService = this.isGCMBaseIntentService(currentClass);
        this.searchAndBuildMethod("void onCreate()", currentClass, entryPoints, classLocal);
        this.searchAndBuildMethod("void onStart(android.content.Intent,int)", currentClass, entryPoints, classLocal);
        JNopStmt beforeStartCommand = new JNopStmt();
        JNopStmt afterStartCommand = new JNopStmt();
        this.body.getUnits().add(beforeStartCommand);
        this.createIfStmt(afterStartCommand);
        this.searchAndBuildMethod("int onStartCommand(android.content.Intent,int,int)", currentClass, entryPoints, classLocal);
        this.createIfStmt(beforeStartCommand);
        this.body.getUnits().add(afterStartCommand);
        JNopStmt startWhileStmt = new JNopStmt();
        JNopStmt endWhileStmt = new JNopStmt();
        this.body.getUnits().add(startWhileStmt);
        this.createIfStmt(endWhileStmt);
        boolean hasAdditionalMethods = false;
        if (this.modelAdditionalMethods) {
            for (SootMethod currentMethod : currentClass.getMethods()) {
                if (!entryPoints.contains(currentMethod.toString())) continue;
                hasAdditionalMethods |= this.createPlainMethodCall(classLocal, currentMethod);
            }
        }
        if (isGCMBaseIntentService) {
            for (String sig : AndroidEntryPointConstants.getGCMIntentServiceMethods()) {
                SootMethod sm = this.findMethod(currentClass, sig);
                if (sm == null || sm.getName().equals("com.google.android.gcm.GCMBaseIntentService")) continue;
                hasAdditionalMethods |= this.createPlainMethodCall(classLocal, sm);
            }
        }
        this.addCallbackMethods(currentClass);
        this.body.getUnits().add(endWhileStmt);
        if (hasAdditionalMethods) {
            this.createIfStmt(startWhileStmt);
        }
        this.searchAndBuildMethod("android.os.IBinder onBind(android.content.Intent)", currentClass, entryPoints, classLocal);
        JNopStmt beforemethodsStmt = new JNopStmt();
        this.body.getUnits().add(beforemethodsStmt);
        JNopStmt startWhile2Stmt = new JNopStmt();
        JNopStmt endWhile2Stmt = new JNopStmt();
        this.body.getUnits().add(startWhile2Stmt);
        hasAdditionalMethods = false;
        if (this.modelAdditionalMethods) {
            for (SootMethod currentMethod : currentClass.getMethods()) {
                if (!entryPoints.contains(currentMethod.toString())) continue;
                hasAdditionalMethods |= this.createPlainMethodCall(classLocal, currentMethod);
            }
        }
        if (isGCMBaseIntentService) {
            for (String sig : AndroidEntryPointConstants.getGCMIntentServiceMethods()) {
                SootMethod sm = this.findMethod(currentClass, sig);
                if (sm == null || sm.getName().equals("com.google.android.gcm.GCMBaseIntentService")) continue;
                hasAdditionalMethods |= this.createPlainMethodCall(classLocal, sm);
            }
        }
        this.addCallbackMethods(currentClass);
        this.body.getUnits().add(endWhile2Stmt);
        if (hasAdditionalMethods) {
            this.createIfStmt(startWhile2Stmt);
        }
        NopStmt onDestroyStmt = Jimple.v().newNopStmt();
        this.searchAndBuildMethod("boolean onUnbind(android.content.Intent)", currentClass, entryPoints, classLocal);
        this.createIfStmt(onDestroyStmt);
        this.searchAndBuildMethod("void onRebind(android.content.Intent)", currentClass, entryPoints, classLocal);
        this.createIfStmt(beforemethodsStmt);
        this.body.getUnits().add(onDestroyStmt);
        this.searchAndBuildMethod("void onDestroy()", currentClass, entryPoints, classLocal);
    }

    private boolean createPlainMethodCall(Local classLocal, SootMethod currentMethod) {
        if (AndroidEntryPointConstants.getServiceLifecycleMethods().contains(currentMethod.getSubSignature())) {
            return false;
        }
        JNopStmt beforeStmt = new JNopStmt();
        JNopStmt thenStmt = new JNopStmt();
        this.body.getUnits().add(beforeStmt);
        this.createIfStmt(thenStmt);
        this.buildMethodCall(currentMethod, this.body, classLocal, this.generator);
        this.body.getUnits().add(thenStmt);
        this.createIfStmt(beforeStmt);
        return true;
    }

    private boolean isGCMBaseIntentService(SootClass currentClass) {
        while (currentClass.hasSuperclass()) {
            if (currentClass.getSuperclass().getName().equals("com.google.android.gcm.GCMBaseIntentService")) {
                return true;
            }
            currentClass = currentClass.getSuperclass();
        }
        return false;
    }

    private void generateActivityLifecycle(Set<String> entryPoints, SootClass currentClass, JNopStmt endClassStmt, Local classLocal) {
        this.createIfStmt(endClassStmt);
        HashSet<SootClass> referenceClasses = new HashSet<SootClass>();
        if (this.applicationClass != null) {
            referenceClasses.add(this.applicationClass);
        }
        for (SootClass callbackClass : this.applicationCallbackClasses) {
            referenceClasses.add(callbackClass);
        }
        referenceClasses.add(currentClass);
        JNopStmt onCreateStmt = new JNopStmt();
        this.body.getUnits().add(onCreateStmt);
        Stmt onCreateStmt2 = this.searchAndBuildMethod("void onCreate(android.os.Bundle)", currentClass, entryPoints, classLocal);
        boolean found = this.addCallbackMethods(this.applicationClass, referenceClasses, "void onActivityCreated(android.app.Activity,android.os.Bundle)");
        if (found && onCreateStmt2 != null) {
            this.createIfStmt(onCreateStmt2);
        }
        JNopStmt onStartStmt = new JNopStmt();
        this.body.getUnits().add(onStartStmt);
        Stmt onStartStmt2 = this.searchAndBuildMethod("void onStart()", currentClass, entryPoints, classLocal);
        boolean found2 = this.addCallbackMethods(this.applicationClass, referenceClasses, "void onActivityStarted(android.app.Activity)");
        if (found2 && onStartStmt2 != null) {
            this.createIfStmt(onStartStmt2);
        }
        this.searchAndBuildMethod("void onRestoreInstanceState(android.os.Bundle)", currentClass, entryPoints, classLocal);
        this.searchAndBuildMethod("void onPostCreate(android.os.Bundle)", currentClass, entryPoints, classLocal);
        JNopStmt onResumeStmt = new JNopStmt();
        this.body.getUnits().add(onResumeStmt);
        Stmt onResumeStmt2 = this.searchAndBuildMethod("void onResume()", currentClass, entryPoints, classLocal);
        boolean found3 = this.addCallbackMethods(this.applicationClass, referenceClasses, "void onActivityResumed(android.app.Activity)");
        if (found3 && onResumeStmt2 != null) {
            this.createIfStmt(onResumeStmt2);
        }
        this.searchAndBuildMethod("void onPostResume()", currentClass, entryPoints, classLocal);
        this.searchAndBuildMethodWithGetIntent("void onNewIntent(android.content.Intent)", currentClass, entryPoints, classLocal);
        HashSet<SootMethod> methodsToInvoke = new HashSet<SootMethod>();
        if (this.modelAdditionalMethods) {
            for (SootMethod currentMethod : currentClass.getMethods()) {
                if (!entryPoints.contains(currentMethod.toString()) || AndroidEntryPointConstants.getActivityLifecycleMethods().contains(currentMethod.getSubSignature())) continue;
                methodsToInvoke.add(currentMethod);
            }
        }
        if (!JadeCfg.isEnhance_callback_body()) {
            System.out.println("jade body enhancement not enabled, fallback to default callback impl.");
            boolean hasCallbacks = this.callbackFunctions.containsKey(currentClass.getName());
            if (!methodsToInvoke.isEmpty() || hasCallbacks) {
                JNopStmt startWhileStmt = new JNopStmt();
                JNopStmt endWhileStmt = new JNopStmt();
                this.body.getUnits().add(startWhileStmt);
                this.createIfStmt(endWhileStmt);
                this.addCallbackMethods(currentClass);
                boolean hasAdditionalMethods = false;
                for (SootMethod currentMethod : currentClass.getMethods()) {
                    if (!entryPoints.contains(currentMethod.toString())) continue;
                    hasAdditionalMethods |= this.createPlainMethodCall(classLocal, currentMethod);
                }
                this.body.getUnits().add(endWhileStmt);
                if (hasAdditionalMethods) {
                    this.createIfStmt(startWhileStmt);
                }
            }
        } else {
            System.out.println("jade body enhancement enabled, not enabling default callback impl in dummyMain.");
        }
        Stmt onPause = this.searchAndBuildMethod("void onPause()", currentClass, entryPoints, classLocal);
        boolean hasAppOnPause = this.addCallbackMethods(this.applicationClass, referenceClasses, "void onActivityPaused(android.app.Activity)");
        if (hasAppOnPause && onPause != null) {
            this.createIfStmt(onPause);
        }
        this.searchAndBuildMethod("java.lang.CharSequence onCreateDescription()", currentClass, entryPoints, classLocal);
        Stmt onSaveInstance = this.searchAndBuildMethod("void onSaveInstanceState(android.os.Bundle)", currentClass, entryPoints, classLocal);
        boolean hasAppOnSaveInstance = this.addCallbackMethods(this.applicationClass, referenceClasses, "void onActivitySaveInstanceState(android.app.Activity,android.os.Bundle)");
        if (hasAppOnSaveInstance && onSaveInstance != null) {
            this.createIfStmt(onSaveInstance);
        }
        this.createIfStmt(onResumeStmt);
        Stmt onStop = this.searchAndBuildMethod("void onStop()", currentClass, entryPoints, classLocal);
        boolean hasAppOnStop = this.addCallbackMethods(this.applicationClass, referenceClasses, "void onActivityStopped(android.app.Activity)");
        if (hasAppOnStop && onStop != null) {
            this.createIfStmt(onStop);
        }
        JNopStmt stopToDestroyStmt = new JNopStmt();
        this.createIfStmt(stopToDestroyStmt);
        this.searchAndBuildMethod("void onRestart()", currentClass, entryPoints, classLocal);
        this.createIfStmt(onStartStmt);
        this.body.getUnits().add(stopToDestroyStmt);
        Stmt onDestroy = this.searchAndBuildMethod("void onDestroy()", currentClass, entryPoints, classLocal);
        boolean hasAppOnDestroy = this.addCallbackMethods(this.applicationClass, referenceClasses, "void onActivityDestroyed(android.app.Activity)");
        if (hasAppOnDestroy && onDestroy != null) {
            this.createIfStmt(onDestroy);
        }
        this.createIfStmt(endClassStmt);
    }

    private void addApplicationCallbackMethods() {
        if (!this.callbackFunctions.containsKey(this.applicationClass.getName())) {
            return;
        }
        if (this.applicationClass.isAbstract()) {
            return;
        }
        if (this.applicationClass.isPhantom()) {
            System.err.println("Skipping possible application callbacks in phantom class " + this.applicationClass);
            return;
        }
        for (String methodSig : this.callbackFunctions.get(this.applicationClass.getName())) {
            SootMethod method;
            SootMethodAndClass methodAndClass = SootMethodRepresentationParser.v().parseSootMethodString(methodSig);
            if (AndroidEntryPointConstants.getApplicationLifecycleMethods().contains(methodAndClass.getSubSignature()) || (method = this.findMethod(Scene.v().getSootClass(methodAndClass.getClassName()), methodAndClass.getSubSignature())) == null || method.getDeclaringClass().getName().startsWith("android.") || method.getDeclaringClass().getName().startsWith("java.")) continue;
            Local local = (Local)this.localVarsForClasses.get(methodAndClass.getClassName());
            if (local == null) {
                System.err.println("Could not create call to application callback " + method.getSignature() + ". Local was null.");
                continue;
            }
            JNopStmt thenStmt = new JNopStmt();
            this.createIfStmt(thenStmt);
            this.buildMethodCall(method, this.body, local, this.generator);
            this.body.getUnits().add(thenStmt);
        }
    }

    private boolean addCallbackMethods(SootClass currentClass) {
        return this.addCallbackMethods(currentClass, null, "");
    }

    private boolean addCallbackMethods(SootClass currentClass, Set<SootClass> referenceClasses, String callbackSignature) {
        if (currentClass == null) {
            return false;
        }
        if (!this.callbackFunctions.containsKey(currentClass.getName())) {
            return false;
        }
        boolean callbackFound = false;
        HashMap callbackClasses = new HashMap();
        for (String methodSig : this.callbackFunctions.get(currentClass.getName())) {
            SootClass theClass;
            Object theMethod;
            SootMethodAndClass methodAndClass = SootMethodRepresentationParser.v().parseSootMethodString(methodSig);
            if (!callbackSignature.isEmpty() && !callbackSignature.equals(methodAndClass.getSubSignature()) || (theMethod = this.findMethod(theClass = Scene.v().getSootClass(methodAndClass.getClassName()), methodAndClass.getSubSignature())) == null || this.getComponentType(theClass) == ComponentType.Activity && AndroidEntryPointConstants.getActivityLifecycleMethods().contains(((SootMethod)theMethod).getSubSignature()) || this.getComponentType(theClass) == ComponentType.Service && AndroidEntryPointConstants.getServiceLifecycleMethods().contains(((SootMethod)theMethod).getSubSignature()) || this.getComponentType(theClass) == ComponentType.BroadcastReceiver && AndroidEntryPointConstants.getBroadcastLifecycleMethods().contains(((SootMethod)theMethod).getSubSignature()) || this.getComponentType(theClass) == ComponentType.ContentProvider && AndroidEntryPointConstants.getContentproviderLifecycleMethods().contains(((SootMethod)theMethod).getSubSignature())) continue;
            if (callbackClasses.containsKey(theClass)) {
                ((Set)callbackClasses.get(theClass)).add(theMethod);
                continue;
            }
            HashSet<Object> methods = new HashSet<Object>();
            methods.add(theMethod);
            callbackClasses.put(theClass, methods);
        }
        if (referenceClasses == null || referenceClasses.isEmpty()) {
            referenceClasses = Collections.singleton(currentClass);
        } else {
            referenceClasses = new HashSet<SootClass>(referenceClasses);
            referenceClasses.add(currentClass);
        }
        NopStmt beforeCallbacks = Jimple.v().newNopStmt();
        this.body.getUnits().add(beforeCallbacks);
        for (SootClass callbackClass : callbackClasses.keySet()) {
            HashSet<Local> classLocals = new HashSet<Local>();
            for (SootClass parentClass : referenceClasses) {
                Local parentLocal = (Local)this.localVarsForClasses.get(parentClass.getName());
                if (!this.isCompatible(parentClass, callbackClass)) continue;
                classLocals.add(parentLocal);
            }
            if (classLocals.isEmpty()) {
                Local classLocal = this.generateClassConstructor(callbackClass, this.body, referenceClasses);
                if (classLocal == null) {
                    this.logger.warn("Constructor cannot be generated for callback class {}", (Object)callbackClass.getName());
                    continue;
                }
                classLocals.add(classLocal);
            }
            for (Local classLocal : classLocals) {
                for (SootMethod callbackMethod : (Set)callbackClasses.get(callbackClass)) {
                    JNopStmt thenStmt = new JNopStmt();
                    this.createIfStmt(thenStmt);
                    this.buildMethodCall(callbackMethod, this.body, classLocal, this.generator, referenceClasses);
                    this.body.getUnits().add(thenStmt);
                }
                callbackFound = true;
            }
        }
        if (callbackFound) {
            this.createIfStmt(beforeCallbacks);
        }
        return callbackFound;
    }

    private Stmt searchAndBuildMethod(String subsignature, SootClass currentClass, Set<String> entryPoints, Local classLocal) {
        if (currentClass == null || classLocal == null) {
            return null;
        }
        SootMethod method = this.findMethod(currentClass, subsignature);
        if (method == null) {
            this.logger.warn("Could not find Android entry point method: {}", (Object)subsignature);
            return null;
        }
        entryPoints.remove(method.getSignature());
        if (AndroidEntryPointConstants.isLifecycleClass(method.getDeclaringClass().getName())) {
            return null;
        }
        if (method.getDeclaringClass().getName().startsWith("android.")) {
            return null;
        }
        assert (method.isStatic() || classLocal != null) : "Class local was null for non-static method " + method.getSignature();
        return this.buildMethodCall(method, this.body, classLocal, this.generator);
    }

    private Stmt searchAndBuildMethodWithGetIntent(String subsignature, SootClass currentClass, Set<String> entryPoints, Local classLocal) {
        if (currentClass == null || classLocal == null) {
            return null;
        }
        SootMethod method = this.findMethod(currentClass, subsignature);
        if (method == null) {
            this.logger.warn("Could not find Android entry point method: {}", (Object)subsignature);
            return null;
        }
        entryPoints.remove(method.getSignature());
        assert (method.isStatic() || classLocal != null) : "Class local was null for non-static method " + method.getSignature();
        if (AndroidEntryPointConstants.isLifecycleClass(method.getDeclaringClass().getName())) {
            return null;
        }
        if (method.getDeclaringClass().getName().startsWith("android.")) {
            return null;
        }
        SootMethod methodToCall = method;
        LocalGenerator gen = this.generator;
        RefType intentType = (RefType)methodToCall.getParameterType(0);
        Local intentRetLocal = null;
        intentRetLocal = this.localVarsForClasses.containsKey(intentType.getClassName()) ? (Local)this.localVarsForClasses.get(intentType.getClassName()) : gen.generateLocal(intentType);
        SootMethod getIntentMethod = this.findMethod(currentClass, "android.content.Intent getIntent()");
        VirtualInvokeExpr getIntentExpr = Jimple.v().newVirtualInvokeExpr(classLocal, getIntentMethod.makeRef());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(intentRetLocal, getIntentExpr);
        VirtualInvokeExpr onNewIntentExpr = Jimple.v().newVirtualInvokeExpr(classLocal, methodToCall.makeRef(), Collections.singletonList(intentRetLocal));
        InvokeStmt onNewIntentStmt = Jimple.v().newInvokeStmt(onNewIntentExpr);
        this.body.getUnits().add(assignStmt);
        this.body.getUnits().add(onNewIntentStmt);
        this.body.getUnits().add(Jimple.v().newAssignStmt(intentRetLocal, NullConstant.v()));
        return onNewIntentStmt;
    }

    private void createIfStmt(Unit target) {
        if (target == null) {
            return;
        }
        JEqExpr cond = new JEqExpr(this.intCounter, IntConstant.v(this.conditionCounter++));
        JIfStmt ifStmt = new JIfStmt((Value)cond, target);
        this.body.getUnits().add(ifStmt);
    }

    public void setModelAdditionalMethods(boolean modelAdditionalMethods) {
        this.modelAdditionalMethods = modelAdditionalMethods;
    }

    public boolean getModelAdditionalMethods() {
        return this.modelAdditionalMethods;
    }

    @Override
    public Collection<String> getRequiredClasses() {
        HashSet<String> requiredClasses = new HashSet<String>(this.androidClasses);
        requiredClasses.addAll(SootMethodRepresentationParser.v().parseClassNames(this.additionalEntryPoints, false).keySet());
        return requiredClasses;
    }

    public static enum ComponentType {
        Application,
        Activity,
        Service,
        BroadcastReceiver,
        ContentProvider,
        Plain;

    }
}

