/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.pathBuilders;

import heros.solver.CountingThreadPoolExecutor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.pathBuilders.AbstractAbstractionPathBuilder;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;

public class ContextInsensitiveSourceFinder
extends AbstractAbstractionPathBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InfoflowResults results = new InfoflowResults();
    private final CountingThreadPoolExecutor executor;
    private static int lastTaskId = 0;
    private int numTasks = 0;

    public ContextInsensitiveSourceFinder(IInfoflowCFG icfg, int maxThreadNum) {
        super(icfg, false);
        int numThreads = Runtime.getRuntime().availableProcessors();
        this.executor = this.createExecutor(maxThreadNum == -1 ? numThreads : Math.min(maxThreadNum, numThreads));
    }

    private CountingThreadPoolExecutor createExecutor(int numThreads) {
        return new CountingThreadPoolExecutor(numThreads, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public void computeTaintPaths(Set<AbstractionAtSink> res) {
        if (res.isEmpty()) {
            return;
        }
        long beforePathTracking = System.nanoTime();
        this.logger.info("Obtainted {} connections between sources and sinks", (Object)res.size());
        int curResIdx = 0;
        this.numTasks = res.size() + 1;
        for (AbstractionAtSink abs : res) {
            this.logger.info("Building path " + ++curResIdx);
            this.executor.execute(new SourceFindingTask(lastTaskId++, abs, abs.getAbstraction()));
        }
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException ex) {
            this.logger.error("Could not wait for path executor completion: {0}", (Object)ex.getMessage());
            ex.printStackTrace();
        }
        this.logger.info("Path processing took {} seconds in total", (Object)((double)(System.nanoTime() - beforePathTracking) / 1.0E9));
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public InfoflowResults getResults() {
        return this.results;
    }

    private class SourceFindingTask
    implements Runnable {
        private final int taskId;
        private final AbstractionAtSink flagAbs;
        private final List<Abstraction> abstractionQueue = new LinkedList<Abstraction>();

        public SourceFindingTask(int taskId, AbstractionAtSink flagAbs, Abstraction abstraction) {
            this.taskId = taskId;
            this.flagAbs = flagAbs;
            this.abstractionQueue.add(abstraction);
        }

        @Override
        public void run() {
            while (!this.abstractionQueue.isEmpty()) {
                Abstraction abstraction = this.abstractionQueue.remove(0);
                if (abstraction.getSourceContext() != null) {
                    ContextInsensitiveSourceFinder.this.results.addResult(this.flagAbs.getAbstraction().getAccessPath(), this.flagAbs.getSinkStmt(), abstraction.getSourceContext().getAccessPath(), abstraction.getSourceContext().getStmt(), abstraction.getSourceContext().getUserData(), Collections.emptyList());
                    assert (abstraction.getPredecessor() == null);
                } else if (abstraction.getPredecessor().registerPathFlag(this.taskId, ContextInsensitiveSourceFinder.this.numTasks)) {
                    this.abstractionQueue.add(abstraction.getPredecessor());
                }
                if (abstraction.getNeighbors() == null) continue;
                for (Abstraction nb : abstraction.getNeighbors()) {
                    if (!nb.registerPathFlag(this.taskId, ContextInsensitiveSourceFinder.this.numTasks)) continue;
                    this.abstractionQueue.add(nb);
                }
            }
        }
    }
}

