/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.resources;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.PackManager;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.Transform;
import soot.jimple.infoflow.android.axml.AXmlAttribute;
import soot.jimple.infoflow.android.axml.AXmlHandler;
import soot.jimple.infoflow.android.axml.AXmlNode;
import soot.jimple.infoflow.android.axml.parsers.AXML20Parser;
import soot.jimple.infoflow.android.resources.ARSCFileParser;
import soot.jimple.infoflow.android.resources.AbstractResourceParser;
import soot.jimple.infoflow.android.resources.IResourceHandler;
import soot.jimple.infoflow.android.resources.LayoutControl;

public class LayoutFileParser
extends AbstractResourceParser {
    private static final boolean DEBUG = true;
    private final Map<String, Set<LayoutControl>> userControls = new HashMap<String, Set<LayoutControl>>();
    private final Map<String, Set<String>> callbackMethods = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> includeDependencies = new HashMap<String, Set<String>>();
    private final String packageName;
    private final ARSCFileParser resParser;
    private static final int TYPE_NUMBER_VARIATION_PASSWORD = 16;
    private static final int TYPE_TEXT_VARIATION_PASSWORD = 128;
    private static final int TYPE_TEXT_VARIATION_VISIBLE_PASSWORD = 144;
    private static final int TYPE_TEXT_VARIATION_WEB_PASSWORD = 224;

    public LayoutFileParser(String packageName, ARSCFileParser resParser) {
        this.packageName = packageName;
        this.resParser = resParser;
    }

    private SootClass getLayoutClass(String className) {
        if (className.startsWith(";")) {
            className = className.substring(1);
        }
        if (className.contains("(") || className.contains("<") || className.contains("/")) {
            System.err.println("Invalid class name " + className);
            return null;
        }
        SootClass sc = Scene.v().forceResolve(className, 3);
        if ((sc == null || sc.isPhantom()) && !this.packageName.isEmpty()) {
            sc = Scene.v().forceResolve(this.packageName + "." + className, 3);
        }
        if (sc == null || sc.isPhantom()) {
            sc = Scene.v().forceResolve("android.view." + className, 3);
        }
        if (sc == null || sc.isPhantom()) {
            sc = Scene.v().forceResolve("android.widget." + className, 3);
        }
        if (sc == null || sc.isPhantom()) {
            sc = Scene.v().forceResolve("android.webkit." + className, 3);
        }
        if (sc == null || sc.isPhantom()) {
            System.err.println("Could not find layout class " + className);
            return null;
        }
        return sc;
    }

    private boolean isLayoutClass(SootClass theClass) {
        if (theClass == null) {
            return false;
        }
        boolean found = false;
        for (SootClass parent : Scene.v().getActiveHierarchy().getSuperclassesOf(theClass)) {
            if (!parent.getName().equals("android.view.ViewGroup")) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean isViewClass(SootClass theClass) {
        if (theClass == null) {
            return false;
        }
        boolean found = false;
        for (SootClass parent : Scene.v().getActiveHierarchy().getSuperclassesOfIncluding(theClass)) {
            if (!parent.getName().equals("android.view.View") && !parent.getName().equals("android.webkit.WebView")) continue;
            found = true;
            break;
        }
        if (!found) {
            System.err.println("Layout class " + theClass.getName() + " is not derived from " + "android.view.View");
            return false;
        }
        return true;
    }

    private boolean isAndroidNamespace(String ns) {
        if (ns == null) {
            return false;
        }
        if ((ns = ns.trim()).startsWith("*")) {
            ns = ns.substring(1);
        }
        return ns.equals("http://schemas.android.com/apk/res/android");
    }

    private <X, Y> void addToMapSet(Map<X, Set<Y>> target, X layoutFile, Y callback) {
        if (target.containsKey(layoutFile)) {
            target.get(layoutFile).add(callback);
        } else {
            HashSet<Y> callbackSet = new HashSet<Y>();
            callbackSet.add(callback);
            target.put(layoutFile, callbackSet);
        }
    }

    private void addCallbackMethod(String layoutFile, String callback) {
        this.addToMapSet(this.callbackMethods, layoutFile, callback);
        if (this.includeDependencies.containsKey(layoutFile)) {
            for (String target : this.includeDependencies.get(layoutFile)) {
                this.addCallbackMethod(target, callback);
            }
        }
    }

    public void parseLayoutFile(final String fileName, Set<String> classes) {
        Transform transform2 = new Transform("wjtp.lfp", new SceneTransformer(){

            protected void internalTransform(String phaseName, Map options) {
                LayoutFileParser.this.handleAndroidResourceFiles(fileName, null, new IResourceHandler(){

                    @Override
                    public void handleResourceFile(String fileName, Set<String> fileNameFilter, InputStream stream) {
                        if (!fileName.startsWith("res/layout")) {
                            return;
                        }
                        if (!fileName.endsWith(".xml")) {
                            System.err.println("Skipping file " + fileName + " in layout folder...");
                            return;
                        }
                        String entryClass = fileName.substring(0, fileName.lastIndexOf("."));
                        if (!LayoutFileParser.this.packageName.isEmpty()) {
                            entryClass = LayoutFileParser.this.packageName + "." + entryClass;
                        }
                        if (!fileName.startsWith("res/layout")) {
                            return;
                        }
                        if (fileNameFilter != null) {
                            boolean found = false;
                            for (String s2 : fileNameFilter) {
                                if (!s2.equalsIgnoreCase(entryClass)) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                return;
                            }
                        }
                        try {
                            AXmlHandler handler = new AXmlHandler(stream, new AXML20Parser());
                            LayoutFileParser.this.parseLayoutNode(fileName, handler.getDocument().getRootNode());
                            System.out.println("Found " + LayoutFileParser.this.userControls.size() + " layout controls in file " + fileName);
                        }
                        catch (Exception ex) {
                            System.err.println("Could not read binary XML file: " + ex.getMessage());
                            ex.printStackTrace();
                        }
                    }
                });
            }
        });
        PackManager.v().getPack("wjtp").add(transform2);
    }

    private void parseLayoutNode(String layoutFile, AXmlNode rootNode) {
        if (rootNode.getTag() == null || rootNode.getTag().isEmpty()) {
            System.err.println("Encountered a null or empty node name in file " + layoutFile + ", skipping node...");
            return;
        }
        String tname = rootNode.getTag().trim();
        if (!tname.equals("dummy")) {
            if (tname.equals("include")) {
                this.parseIncludeAttributes(layoutFile, rootNode);
            } else if (!tname.equals("merge")) {
                if (tname.equals("fragment")) {
                    AXmlAttribute<?> attr2 = rootNode.getAttribute("name");
                    if (attr2 == null) {
                        System.err.println("Fragment without class name detected");
                    } else {
                        if (attr2.getType() != 3) {
                            System.err.println("Invalid targer resource " + attr2.getValue() + "for fragment class value");
                        }
                        this.getLayoutClass(attr2.getValue().toString());
                    }
                } else {
                    SootClass childClass = this.getLayoutClass(tname);
                    if (childClass != null && (this.isLayoutClass(childClass) || this.isViewClass(childClass))) {
                        this.parseLayoutAttributes(layoutFile, childClass, rootNode);
                    }
                }
            }
        }
        for (AXmlNode childNode : rootNode.getChildren()) {
            this.parseLayoutNode(layoutFile, childNode);
        }
    }

    private void parseIncludeAttributes(String layoutFile, AXmlNode rootNode) {
        for (Map.Entry<String, AXmlAttribute<?>> entry2 : rootNode.getAttributes().entrySet()) {
            String attrName = entry2.getKey().trim();
            AXmlAttribute<?> attr2 = entry2.getValue();
            if (!attrName.equals("layout") || attr2.getType() != 1 && attr2.getType() != 17 || !(attr2.getValue() instanceof Integer)) continue;
            ARSCFileParser.AbstractResource targetRes = this.resParser.findResource((Integer)attr2.getValue());
            if (targetRes == null) {
                System.err.println("Target resource " + attr2.getValue() + " for layout include not found");
                return;
            }
            if (!(targetRes instanceof ARSCFileParser.StringResource)) {
                System.err.println("Invalid target node for include tag in layout XML, was " + targetRes.getClass().getName());
                return;
            }
            String targetFile = ((ARSCFileParser.StringResource)targetRes).getValue();
            if (this.callbackMethods.containsKey(targetFile)) {
                for (String callback : this.callbackMethods.get(targetFile)) {
                    this.addCallbackMethod(layoutFile, callback);
                }
                continue;
            }
            this.addToMapSet(this.includeDependencies, targetFile, layoutFile);
        }
    }

    private void parseLayoutAttributes(String layoutFile, SootClass layoutClass, AXmlNode rootNode) {
        boolean isSensitive = false;
        int id = -1;
        for (Map.Entry<String, AXmlAttribute<?>> entry2 : rootNode.getAttributes().entrySet()) {
            String attrName = entry2.getKey().trim();
            AXmlAttribute<?> attr2 = entry2.getValue();
            if (attrName.isEmpty() || !this.isAndroidNamespace(attr2.getNamespace())) continue;
            if (attrName.equals("id") && (attr2.getType() == 1 || attr2.getType() == 17)) {
                id = (Integer)attr2.getValue();
                continue;
            }
            if (attrName.equals("password")) {
                if (attr2.getType() == 17) {
                    isSensitive = (Integer)attr2.getValue() != 0;
                    continue;
                }
                if (attr2.getType() == 18) {
                    isSensitive = (Boolean)attr2.getValue();
                    continue;
                }
                throw new RuntimeException("Unknown representation of boolean data type");
            }
            if (!isSensitive && attrName.equals("inputType") && attr2.getType() == 17) {
                int tp = (Integer)attr2.getValue();
                isSensitive = (tp & 0x10) == 16 || (tp & 0x80) == 128 || (tp & 0x90) == 144 || (tp & 0xE0) == 224;
                continue;
            }
            if (this.isActionListener(attrName) && attr2.getType() == 3 && attr2.getValue() instanceof String) {
                String strData = ((String)attr2.getValue()).trim();
                this.addCallbackMethod(layoutFile, strData);
                continue;
            }
            if (attr2.getType() == 3 && attrName.equals("text") || attr2.getType() != 3) continue;
            System.out.println("Found unrecognized XML attribute:  " + attrName);
        }
        this.addToMapSet(this.userControls, layoutFile, new LayoutControl(id, layoutClass, isSensitive));
    }

    private boolean isActionListener(String name) {
        return name.equals("onClick");
    }

    public Map<Integer, LayoutControl> getUserControlsByID() {
        HashMap<Integer, LayoutControl> res = new HashMap<Integer, LayoutControl>();
        for (Set<LayoutControl> controls : this.userControls.values()) {
            for (LayoutControl lc : controls) {
                res.put(lc.getID(), lc);
            }
        }
        return res;
    }

    public Map<String, Set<LayoutControl>> getUserControls() {
        return this.userControls;
    }

    public Map<String, Set<String>> getCallbackMethods() {
        return this.callbackMethods;
    }
}

