/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.axml;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ApkHandler {
    protected File apk;
    protected ZipFile zip;

    public ApkHandler(String path) throws ZipException, IOException {
        this(new File(path));
    }

    public ApkHandler(File apk) throws ZipException, IOException {
        this.apk = apk;
    }

    public String getAbsolutePath() {
        return this.apk.getAbsolutePath();
    }

    public String getPath() {
        return this.apk.getPath();
    }

    public String getFilename() {
        return this.apk.getName();
    }

    public InputStream getInputStream(String filename) throws IOException {
        InputStream is2 = null;
        if (this.zip == null) {
            this.zip = new ZipFile(this.apk);
        }
        Enumeration<? extends ZipEntry> entries = this.zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry2 = entries.nextElement();
            String entryName = entry2.getName();
            if (!entryName.equals(filename)) continue;
            is2 = this.zip.getInputStream(entry2);
            break;
        }
        return is2;
    }

    public void addFilesToApk(List<File> files) throws IOException {
        this.addFilesToApk(files, new HashMap<String, String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilesToApk(List<File> files, Map<String, String> paths) throws IOException {
        if (this.zip != null) {
            this.zip.close();
            this.zip = null;
        }
        for (File file : files) {
            if (paths.containsKey(file.getPath())) continue;
            paths.put(file.getPath(), file.getName());
        }
        File tempFile = File.createTempFile(this.apk.getName(), null);
        tempFile.delete();
        boolean renameOk = this.apk.renameTo(tempFile);
        if (!renameOk) {
            try {
                Files.move(this.apk, tempFile);
            }
            catch (IOException ex) {
                throw new IOException("could not rename the file " + this.apk.getAbsolutePath() + " to " + tempFile.getAbsolutePath(), ex);
            }
        }
        ZipInputStream zin = null;
        DeflaterOutputStream out = null;
        byte[] buf = new byte[1024];
        try {
            ZipEntry entry2;
            zin = new ZipInputStream(new FileInputStream(tempFile));
            out = new ZipOutputStream(new FileOutputStream(this.apk));
            block9: while ((entry2 = zin.getNextEntry()) != null) {
                int len;
                for (String path : paths.values()) {
                    if (!entry2.getName().equals(path)) continue;
                    continue block9;
                }
                if (entry2.getName().startsWith("META-INF/") && (entry2.getName().endsWith(".RSA") || entry2.getName().endsWith(".SF"))) continue;
                ZipEntry ze = new ZipEntry(entry2.getName());
                ze.setMethod(entry2.getMethod());
                if (entry2.getTime() != -1L) {
                    ze.setTime(entry2.getTime());
                }
                if (entry2.getSize() != -1L) {
                    ze.setSize(entry2.getSize());
                }
                if (entry2.getCrc() != -1L) {
                    ze.setCrc(entry2.getCrc());
                }
                ((ZipOutputStream)out).putNextEntry(ze);
                while ((len = zin.read(buf)) > 0) {
                    ((ZipOutputStream)out).write(buf, 0, len);
                }
                zin.closeEntry();
                ((ZipOutputStream)out).closeEntry();
            }
            for (File file : files) {
                FileInputStream in = null;
                try {
                    int len;
                    in = new FileInputStream(file);
                    ((ZipOutputStream)out).putNextEntry(new ZipEntry(paths.get(file.getPath())));
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        ((ZipOutputStream)out).write(buf, 0, len);
                    }
                    ((ZipOutputStream)out).closeEntry();
                }
                finally {
                    if (in == null) continue;
                    ((InputStream)in).close();
                }
            }
        }
        finally {
            if (zin != null) {
                zin.close();
            }
            if (out != null) {
                out.flush();
                ((ZipOutputStream)out).close();
            }
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    public void close() {
        if (this.zip != null) {
            try {
                this.zip.close();
            }
            catch (IOException e) {
                System.err.println("Could not close apk file: " + e.getMessage());
                e.printStackTrace();
            }
            this.zip = null;
        }
    }
}

