/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import soot.ArrayType;
import soot.Local;
import soot.RefType;
import soot.Value;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.Constant;
import soot.jimple.Expr;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;

public abstract class PointerStmtSwitch
extends AbstractStmtSwitch {
    Stmt statement;

    protected abstract void caseAssignConstStmt(Value var1, Constant var2);

    protected abstract void caseCopyStmt(Local var1, Local var2);

    protected void caseCastStmt(Local dest, Local src, CastExpr c) {
        this.caseCopyStmt(dest, src);
    }

    protected abstract void caseIdentityStmt(Local var1, IdentityRef var2);

    protected abstract void caseLoadStmt(Local var1, InstanceFieldRef var2);

    protected abstract void caseStoreStmt(InstanceFieldRef var1, Local var2);

    protected abstract void caseArrayLoadStmt(Local var1, ArrayRef var2);

    protected abstract void caseArrayStoreStmt(ArrayRef var1, Local var2);

    protected abstract void caseGlobalLoadStmt(Local var1, StaticFieldRef var2);

    protected abstract void caseGlobalStoreStmt(StaticFieldRef var1, Local var2);

    protected abstract void caseReturnStmt(Local var1);

    protected void caseReturnConstStmt(Constant val) {
        this.caseUninterestingStmt(this.statement);
    }

    protected abstract void caseAnyNewStmt(Local var1, Expr var2);

    protected void caseNewStmt(Local dest, NewExpr e) {
        this.caseAnyNewStmt(dest, e);
    }

    protected void caseNewArrayStmt(Local dest, NewArrayExpr e) {
        this.caseAnyNewStmt(dest, e);
    }

    protected void caseNewMultiArrayStmt(Local dest, NewMultiArrayExpr e) {
        this.caseAnyNewStmt(dest, e);
    }

    protected abstract void caseInvokeStmt(Local var1, InvokeExpr var2);

    protected void caseThrowStmt(Local thrownException) {
        this.caseUninterestingStmt(this.statement);
    }

    protected void caseCatchStmt(Local dest, CaughtExceptionRef cer) {
        this.caseUninterestingStmt(this.statement);
    }

    protected void caseUninterestingStmt(Stmt s2) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void caseAssignStmt(AssignStmt s2) {
        this.statement = s2;
        Value lhs = s2.getLeftOp();
        Value rhs = s2.getRightOp();
        if (!(lhs.getType() instanceof RefType) && !(lhs.getType() instanceof ArrayType)) {
            if (rhs instanceof InvokeExpr) {
                this.caseInvokeStmt(null, (InvokeExpr)rhs);
                return;
            }
            this.caseUninterestingStmt(s2);
            return;
        }
        if (rhs instanceof InvokeExpr) {
            this.caseInvokeStmt((Local)lhs, (InvokeExpr)rhs);
            return;
        }
        if (lhs instanceof Local) {
            if (rhs instanceof Local) {
                this.caseCopyStmt((Local)lhs, (Local)rhs);
                return;
            } else if (rhs instanceof InstanceFieldRef) {
                this.caseLoadStmt((Local)lhs, (InstanceFieldRef)rhs);
                return;
            } else if (rhs instanceof ArrayRef) {
                this.caseArrayLoadStmt((Local)lhs, (ArrayRef)rhs);
                return;
            } else if (rhs instanceof StaticFieldRef) {
                this.caseGlobalLoadStmt((Local)lhs, (StaticFieldRef)rhs);
                return;
            } else if (rhs instanceof NewExpr) {
                this.caseNewStmt((Local)lhs, (NewExpr)rhs);
                return;
            } else if (rhs instanceof NewArrayExpr) {
                this.caseNewArrayStmt((Local)lhs, (NewArrayExpr)rhs);
                return;
            } else if (rhs instanceof NewMultiArrayExpr) {
                this.caseNewMultiArrayStmt((Local)lhs, (NewMultiArrayExpr)rhs);
                return;
            } else if (rhs instanceof CastExpr) {
                CastExpr r = (CastExpr)rhs;
                Value rv = r.getOp();
                if (rv instanceof Constant) {
                    this.caseAssignConstStmt(lhs, (Constant)rv);
                    return;
                } else {
                    this.caseCastStmt((Local)lhs, (Local)rv, r);
                }
                return;
            } else {
                if (!(rhs instanceof Constant)) throw new RuntimeException("unhandled stmt " + s2);
                this.caseAssignConstStmt(lhs, (Constant)rhs);
            }
            return;
        } else if (lhs instanceof InstanceFieldRef) {
            if (rhs instanceof Local) {
                this.caseStoreStmt((InstanceFieldRef)lhs, (Local)rhs);
                return;
            } else {
                if (!(rhs instanceof Constant)) throw new RuntimeException("unhandled stmt " + s2);
                this.caseAssignConstStmt(lhs, (Constant)rhs);
            }
            return;
        } else if (lhs instanceof ArrayRef) {
            if (rhs instanceof Local) {
                this.caseArrayStoreStmt((ArrayRef)lhs, (Local)rhs);
                return;
            } else {
                if (!(rhs instanceof Constant)) throw new RuntimeException("unhandled stmt " + s2);
                this.caseAssignConstStmt(lhs, (Constant)rhs);
            }
            return;
        } else if (lhs instanceof StaticFieldRef) {
            if (rhs instanceof Local) {
                this.caseGlobalStoreStmt((StaticFieldRef)lhs, (Local)rhs);
                return;
            } else {
                if (!(rhs instanceof Constant)) throw new RuntimeException("unhandled stmt " + s2);
                this.caseAssignConstStmt(lhs, (Constant)rhs);
            }
            return;
        } else {
            if (!(rhs instanceof Constant)) throw new RuntimeException("unhandled stmt " + s2);
            this.caseAssignConstStmt(lhs, (Constant)rhs);
        }
    }

    @Override
    public final void caseReturnStmt(ReturnStmt s2) {
        this.statement = s2;
        Value op = s2.getOp();
        if (op.getType() instanceof RefType || op.getType() instanceof ArrayType) {
            if (op instanceof Constant) {
                this.caseReturnConstStmt((Constant)op);
            } else {
                this.caseReturnStmt((Local)op);
            }
        } else {
            this.caseReturnStmt((Local)null);
        }
    }

    @Override
    public final void caseReturnVoidStmt(ReturnVoidStmt s2) {
        this.statement = s2;
        this.caseReturnStmt((Local)null);
    }

    @Override
    public final void caseInvokeStmt(InvokeStmt s2) {
        this.statement = s2;
        this.caseInvokeStmt(null, s2.getInvokeExpr());
    }

    @Override
    public final void caseIdentityStmt(IdentityStmt s2) {
        this.statement = s2;
        Value lhs = s2.getLeftOp();
        Value rhs = s2.getRightOp();
        if (!(lhs.getType() instanceof RefType) && !(lhs.getType() instanceof ArrayType)) {
            this.caseUninterestingStmt(s2);
            return;
        }
        Local llhs = (Local)lhs;
        if (rhs instanceof CaughtExceptionRef) {
            this.caseCatchStmt(llhs, (CaughtExceptionRef)rhs);
        } else {
            IdentityRef rrhs = (IdentityRef)rhs;
            this.caseIdentityStmt(llhs, rrhs);
        }
    }

    @Override
    public final void caseThrowStmt(ThrowStmt s2) {
        this.statement = s2;
        this.caseThrowStmt((Local)s2.getOp());
    }
}

