/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import soot.FloatType;
import soot.Type;
import soot.jimple.ConstantSwitch;
import soot.jimple.IntConstant;
import soot.jimple.NumericConstant;
import soot.jimple.RealConstant;
import soot.util.Switch;

public class FloatConstant
extends RealConstant {
    public final float value;

    private FloatConstant(float value2) {
        this.value = value2;
    }

    public static FloatConstant v(float value2) {
        return new FloatConstant(value2);
    }

    public boolean equals(Object c) {
        return c instanceof FloatConstant && ((FloatConstant)c).value == this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public NumericConstant add(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return FloatConstant.v(this.value + ((FloatConstant)c).value);
    }

    @Override
    public NumericConstant subtract(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return FloatConstant.v(this.value - ((FloatConstant)c).value);
    }

    @Override
    public NumericConstant multiply(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return FloatConstant.v(this.value * ((FloatConstant)c).value);
    }

    @Override
    public NumericConstant divide(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return FloatConstant.v(this.value / ((FloatConstant)c).value);
    }

    @Override
    public NumericConstant remainder(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return FloatConstant.v(this.value % ((FloatConstant)c).value);
    }

    @Override
    public NumericConstant equalEqual(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return IntConstant.v(this.value == ((FloatConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant notEqual(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return IntConstant.v(this.value != ((FloatConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant lessThan(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return IntConstant.v(this.value < ((FloatConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant lessThanOrEqual(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return IntConstant.v(this.value <= ((FloatConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant greaterThan(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return IntConstant.v(this.value > ((FloatConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant greaterThanOrEqual(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return IntConstant.v(this.value >= ((FloatConstant)c).value ? 1 : 0);
    }

    @Override
    public IntConstant cmpg(RealConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        float cValue = ((FloatConstant)c).value;
        if (this.value < cValue) {
            return IntConstant.v(-1);
        }
        if (this.value == cValue) {
            return IntConstant.v(0);
        }
        return IntConstant.v(1);
    }

    @Override
    public IntConstant cmpl(RealConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        float cValue = ((FloatConstant)c).value;
        if (this.value > cValue) {
            return IntConstant.v(1);
        }
        if (this.value == cValue) {
            return IntConstant.v(0);
        }
        return IntConstant.v(-1);
    }

    @Override
    public NumericConstant negate() {
        return FloatConstant.v(-this.value);
    }

    public String toString() {
        String floatString = new Float(this.value).toString();
        if (floatString.equals("NaN") || floatString.equals("Infinity") || floatString.equals("-Infinity")) {
            return "#" + floatString + "F";
        }
        return floatString + "F";
    }

    @Override
    public Type getType() {
        return FloatType.v();
    }

    @Override
    public void apply(Switch sw) {
        ((ConstantSwitch)sw).caseFloatConstant(this);
    }
}

