/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.util;

public class StringTrie {
    private char[] startChars = new char[0];
    private StringTrie[] tries = new StringTrie[0];

    public void add(char[] chars, int index) {
        if (chars.length == index) {
            return;
        }
        if (this.startChars.length == 0) {
            this.startChars = new char[1];
            this.startChars[0] = chars[0];
            this.tries = new StringTrie[1];
            this.tries[0].add(chars, index++);
        } else {
            int i = this.findStart(chars[index], 0, this.startChars.length - 1);
            if (i >= 0) {
                this.tries[i].add(chars, index++);
            } else {
                i = this.addChar(chars[index]);
                this.tries[i].add(chars, index++);
            }
        }
    }

    private int addChar(char c) {
        int oldLength = this.startChars.length;
        int i = this.findSpot(c, 0, oldLength - 1);
        char[] tmp = (char[])this.startChars.clone();
        StringTrie[] t = (StringTrie[])this.tries.clone();
        this.startChars = new char[oldLength + 1];
        this.tries = new StringTrie[oldLength + 1];
        if (i > 0) {
            System.arraycopy(tmp, 0, this.startChars, 0, i);
            System.arraycopy(t, 0, this.tries, 0, i);
        }
        if (i < oldLength) {
            System.arraycopy(tmp, i, this.startChars, i + 1, oldLength - i);
            System.arraycopy(t, i, this.tries, i + 1, oldLength - i);
        }
        this.startChars[i] = c;
        this.tries[i] = new StringTrie();
        return i;
    }

    private int findSpot(char c, int first, int last2) {
        int diff2 = last2 - first;
        if (diff2 == 1) {
            return c < this.startChars[first] ? first : (c < this.startChars[last2] ? last2 : last2 + 1);
        }
        if (this.startChars[first + (diff2 /= 2)] < c) {
            return this.findSpot(c, first + diff2, last2);
        }
        return this.findSpot(c, first, last2 - diff2);
    }

    public boolean contains(char[] chars, int index) {
        if (chars.length == index) {
            return true;
        }
        if (this.startChars.length == 0) {
            return false;
        }
        int i = this.findStart(chars[index], 0, this.startChars.length - 1);
        if (i >= 0) {
            return this.tries[i].contains(chars, index++);
        }
        return false;
    }

    private int findStart(char c, int first, int last2) {
        int diff2 = last2 - first;
        if (diff2 <= 1) {
            return c == this.startChars[first] ? first : (c == this.startChars[last2] ? last2 : -1);
        }
        if (this.startChars[first + (diff2 /= 2)] <= c) {
            return this.findStart(c, first + diff2, last2);
        }
        return this.findStart(c, first, last2 - diff2);
    }
}

