/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.TwoRegisterInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction12x;
import soot.Local;
import soot.dexpler.DexBody;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.LengthExpr;

public class ArrayLengthInstruction
extends DexlibAbstractInstruction {
    AssignStmt assign = null;

    public ArrayLengthInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        if (!(this.instruction instanceof Instruction12x)) {
            throw new IllegalArgumentException("Expected Instruction12x but got: " + this.instruction.getClass());
        }
        Instruction12x lengthOfArrayInstruction = (Instruction12x)this.instruction;
        int dest = lengthOfArrayInstruction.getRegisterA();
        Local arrayReference = body.getRegisterLocal(lengthOfArrayInstruction.getRegisterB());
        LengthExpr lengthExpr = Jimple.v().newLengthExpr(arrayReference);
        this.assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), lengthExpr);
        this.setUnit(this.assign);
        this.addTags(this.assign);
        body.add(this.assign);
    }

    @Override
    boolean overridesRegister(int register2) {
        TwoRegisterInstruction i = (TwoRegisterInstruction)this.instruction;
        int dest = i.getRegisterA();
        return register2 == dest;
    }
}

