/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.traversals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import soot.Local;
import soot.Value;
import soot.ValueBox;
import soot.dava.internal.AST.ASTAggregatedCondition;
import soot.dava.internal.AST.ASTBinaryCondition;
import soot.dava.internal.AST.ASTCondition;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTForLoopNode;
import soot.dava.internal.AST.ASTIfElseNode;
import soot.dava.internal.AST.ASTIfNode;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTSwitchNode;
import soot.dava.internal.AST.ASTSynchronizedBlockNode;
import soot.dava.internal.AST.ASTUnaryCondition;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.dava.toolkits.base.AST.structuredAnalysis.ReachingDefs;
import soot.jimple.ConditionExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;

public class ASTUsesAndDefs
extends DepthFirstAdapter {
    public static boolean DEBUG = false;
    HashMap<Object, List<DefinitionStmt>> uD = new HashMap();
    HashMap<Object, List> dU = new HashMap();
    ReachingDefs reaching;

    public ASTUsesAndDefs(ASTNode AST2) {
        this.reaching = new ReachingDefs(AST2);
    }

    public ASTUsesAndDefs(boolean verbose, ASTNode AST2) {
        super(verbose);
        this.reaching = new ReachingDefs(AST2);
    }

    private List<Value> getUsesFromBoxes(List useBoxes) {
        ArrayList<Value> toReturn = new ArrayList<Value>();
        Iterator it = useBoxes.iterator();
        while (it.hasNext()) {
            Value val = ((ValueBox)it.next()).getValue();
            if (!(val instanceof Local)) continue;
            toReturn.add(val);
        }
        return toReturn;
    }

    public void checkStatementUses(Stmt s2, Object useNodeOrStatement) {
        List<ValueBox> useBoxes = s2.getUseBoxes();
        List<Value> uses = this.getUsesFromBoxes(useBoxes);
        for (Local local : uses) {
            this.createUDDUChain(local, useNodeOrStatement);
        }
        if (s2 instanceof DefinitionStmt && this.dU.get(s2) == null) {
            this.dU.put(s2, new ArrayList());
        }
    }

    public void createUDDUChain(Local local, Object useNodeOrStatement) {
        List<DefinitionStmt> tempObj;
        List<DefinitionStmt> reachingDefs = this.reaching.getReachingDefs(local, useNodeOrStatement);
        if (DEBUG) {
            System.out.println("Reaching def for:" + local + " are:" + reachingDefs);
        }
        if ((tempObj = this.uD.get(useNodeOrStatement)) != null) {
            List<DefinitionStmt> tempList = tempObj;
            tempList.addAll(reachingDefs);
            this.uD.put(useNodeOrStatement, tempList);
        } else {
            this.uD.put(useNodeOrStatement, reachingDefs);
        }
        for (DefinitionStmt defStmt : reachingDefs) {
            ArrayList<Object> useObj = this.dU.get(defStmt);
            ArrayList<Object> uses = null;
            uses = useObj == null ? new ArrayList<Object>() : useObj;
            uses.add(useNodeOrStatement);
            this.dU.put(defStmt, uses);
        }
    }

    public List<Value> getUseList(ASTCondition cond) {
        ArrayList<Value> useList = new ArrayList<Value>();
        if (cond instanceof ASTAggregatedCondition) {
            useList.addAll(this.getUseList(((ASTAggregatedCondition)cond).getLeftOp()));
            useList.addAll(this.getUseList(((ASTAggregatedCondition)cond).getRightOp()));
            return useList;
        }
        if (cond instanceof ASTUnaryCondition) {
            ArrayList<Value> uses = new ArrayList<Value>();
            Value val = ((ASTUnaryCondition)cond).getValue();
            if (val instanceof Local) {
                if (DEBUG) {
                    System.out.println("adding local from unary condition as a use" + val);
                }
                uses.add(val);
            } else {
                List<ValueBox> useBoxes = val.getUseBoxes();
                uses = this.getUsesFromBoxes(useBoxes);
            }
            return uses;
        }
        if (cond instanceof ASTBinaryCondition) {
            ConditionExpr val = ((ASTBinaryCondition)cond).getConditionExpr();
            List<ValueBox> useBoxes = val.getUseBoxes();
            return this.getUsesFromBoxes(useBoxes);
        }
        throw new RuntimeException("Method getUseList in ASTUsesAndDefs encountered unknown condition type");
    }

    public void checkConditionalUses(ASTCondition cond, ASTNode node) {
        List<Value> useList = this.getUseList(cond);
        for (Local local : useList) {
            this.createUDDUChain(local, node);
        }
    }

    @Override
    public void inASTSwitchNode(ASTSwitchNode node) {
        Value val = node.get_Key();
        List<Value> uses = new ArrayList<Value>();
        if (val instanceof Local) {
            uses.add(val);
        } else {
            List<ValueBox> useBoxes = val.getUseBoxes();
            uses = this.getUsesFromBoxes(useBoxes);
        }
        for (Local local : uses) {
            this.createUDDUChain(local, node);
        }
    }

    @Override
    public void inASTSynchronizedBlockNode(ASTSynchronizedBlockNode node) {
        Local local = node.getLocal();
        this.createUDDUChain(local, node);
    }

    @Override
    public void inASTIfNode(ASTIfNode node) {
        ASTCondition cond = node.get_Condition();
        this.checkConditionalUses(cond, node);
    }

    @Override
    public void inASTIfElseNode(ASTIfElseNode node) {
        ASTCondition cond = node.get_Condition();
        this.checkConditionalUses(cond, node);
    }

    @Override
    public void inASTWhileNode(ASTWhileNode node) {
        ASTCondition cond = node.get_Condition();
        this.checkConditionalUses(cond, node);
    }

    @Override
    public void inASTDoWhileNode(ASTDoWhileNode node) {
        ASTCondition cond = node.get_Condition();
        this.checkConditionalUses(cond, node);
    }

    @Override
    public void inASTForLoopNode(ASTForLoopNode node) {
        List<Object> init2 = node.getInit();
        for (AugmentedStmt augmentedStmt : init2) {
            Stmt s2 = augmentedStmt.get_Stmt();
            this.checkStatementUses(s2, node);
        }
        ASTCondition aSTCondition = node.get_Condition();
        this.checkConditionalUses(aSTCondition, node);
        List<Object> update2 = node.getUpdate();
        for (AugmentedStmt augmentedStmt : update2) {
            Stmt s3 = augmentedStmt.get_Stmt();
            this.checkStatementUses(s3, node);
        }
    }

    @Override
    public void inASTStatementSequenceNode(ASTStatementSequenceNode node) {
        List<Object> statements = node.getStatements();
        for (AugmentedStmt augmentedStmt : statements) {
            Stmt s2 = augmentedStmt.get_Stmt();
            this.checkStatementUses(s2, s2);
        }
    }

    public List getUDChain(Object node) {
        return this.uD.get(node);
    }

    public List getDUChain(Object node) {
        return this.dU.get(node);
    }

    public HashMap<Object, List> getDUHashMap() {
        return this.dU;
    }

    @Override
    public void outASTMethodNode(ASTMethodNode node) {
    }

    public void print() {
        System.out.println("\n\n\nPRINTING uD dU CHAINS ______________________________");
        for (DefinitionStmt definitionStmt : this.dU.keySet()) {
            System.out.println("*****The def  " + definitionStmt + " has following uses:");
            List obj = this.dU.get(definitionStmt);
            if (obj == null) continue;
            ArrayList list = (ArrayList)obj;
            for (Object tempUse : list) {
                System.out.println("-----------Use  " + tempUse);
                System.out.println("----------------Defs of this use:   " + this.uD.get(tempUse));
            }
        }
        System.out.println("END --------PRINTING uD dU CHAINS ______________________________");
    }
}

