/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.internal.javaRep;

import java.util.ArrayList;
import java.util.List;
import soot.Type;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.util.Switch;

public class DArrayInitExpr
implements Value {
    ValueBox[] elements;
    Type type;

    public DArrayInitExpr(ValueBox[] elements, Type type) {
        this.elements = elements;
        this.type = type;
    }

    @Override
    public List<ValueBox> getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        for (ValueBox element2 : this.elements) {
            list.addAll(element2.getValue().getUseBoxes());
            list.add(element2);
        }
        return list;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("{");
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].toString(up);
            if (i + 1 >= this.elements.length) continue;
            up.literal(" , ");
        }
        up.literal("}");
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("{");
        for (int i = 0; i < this.elements.length; ++i) {
            b.append(this.elements[i].toString());
            if (i + 1 >= this.elements.length) continue;
            b.append(" , ");
        }
        b.append("}");
        return b.toString();
    }

    @Override
    public void apply(Switch sw) {
    }

    @Override
    public boolean equivTo(Object o) {
        return false;
    }

    @Override
    public int equivHashCode() {
        int toReturn = 0;
        for (ValueBox element2 : this.elements) {
            toReturn += element2.getValue().equivHashCode();
        }
        return toReturn;
    }

    public ValueBox[] getElements() {
        return this.elements;
    }
}

