/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.axml;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import pxb.android.StringItem;
import pxb.android.StringItems;
import pxb.android.axml.AxmlVisitor;
import pxb.android.axml.NodeVisitor;
import pxb.android.axml.ValueWrapper;

public class AxmlWriter
extends AxmlVisitor {
    static final Comparator<Attr> ATTR_CMP = new Comparator<Attr>(){

        @Override
        public int compare(Attr a2, Attr b) {
            int x = a2.resourceId - b.resourceId;
            if (x == 0 && (x = a2.name.data.compareTo(b.name.data)) == 0) {
                boolean bNsIsnull;
                boolean aNsIsnull = a2.ns == null;
                boolean bl = bNsIsnull = b.ns == null;
                x = aNsIsnull ? (bNsIsnull ? 0 : -1) : (bNsIsnull ? 1 : a2.ns.data.compareTo(b.ns.data));
            }
            return x;
        }
    };
    private List<NodeImpl> firsts = new ArrayList<NodeImpl>(3);
    private Map<String, Ns> nses = new HashMap<String, Ns>();
    private List<StringItem> otherString = new ArrayList<StringItem>();
    private Map<String, StringItem> resourceId2Str = new HashMap<String, StringItem>();
    private List<Integer> resourceIds = new ArrayList<Integer>();
    private List<StringItem> resourceString = new ArrayList<StringItem>();
    private StringItems stringItems = new StringItems();

    @Override
    public NodeVisitor child(String ns, String name) {
        NodeImpl first = new NodeImpl(ns, name);
        this.firsts.add(first);
        return first;
    }

    @Override
    public void end() {
    }

    @Override
    public void ns(String prefix, String uri, int ln) {
        this.nses.put(uri, new Ns(prefix == null ? null : new StringItem(prefix), new StringItem(uri), ln));
    }

    private int prepare() throws IOException {
        int size2 = 0;
        for (NodeImpl first : this.firsts) {
            size2 += first.prepare(this);
        }
        int a2 = 0;
        for (Map.Entry<String, Ns> e : this.nses.entrySet()) {
            Ns ns = e.getValue();
            if (ns == null) {
                ns = new Ns(null, new StringItem(e.getKey()), 0);
                e.setValue(ns);
            }
            if (ns.prefix == null) {
                ns.prefix = new StringItem(String.format("axml_auto_%02d", a2++));
            }
            ns.prefix = this.update(ns.prefix);
            ns.uri = this.update(ns.uri);
        }
        size2 += this.nses.size() * 24 * 2;
        this.stringItems.addAll(this.resourceString);
        this.resourceString = null;
        this.stringItems.addAll(this.otherString);
        this.otherString = null;
        this.stringItems.prepare();
        int stringSize = this.stringItems.getSize();
        if (stringSize % 4 != 0) {
            stringSize += 4 - stringSize % 4;
        }
        size2 += 8 + stringSize;
        return size2 += 8 + this.resourceIds.size() * 4;
    }

    public byte[] toByteArray() throws IOException {
        int size2 = 8 + this.prepare();
        ByteBuffer out = ByteBuffer.allocate(size2).order(ByteOrder.LITTLE_ENDIAN);
        out.putInt(524291);
        out.putInt(size2);
        int stringSize = this.stringItems.getSize();
        int padding2 = 0;
        if (stringSize % 4 != 0) {
            padding2 = 4 - stringSize % 4;
        }
        out.putInt(0x1C0001);
        out.putInt(stringSize + padding2 + 8);
        this.stringItems.write(out);
        out.put(new byte[padding2]);
        out.putInt(524672);
        out.putInt(8 + this.resourceIds.size() * 4);
        for (Integer i : this.resourceIds) {
            out.putInt(i);
        }
        Stack<Ns> stack = new Stack<Ns>();
        for (Map.Entry<String, Ns> e : this.nses.entrySet()) {
            Ns ns = e.getValue();
            stack.push(ns);
            out.putInt(0x100100);
            out.putInt(24);
            out.putInt(-1);
            out.putInt(-1);
            out.putInt(ns.prefix.index);
            out.putInt(ns.uri.index);
        }
        for (NodeImpl first : this.firsts) {
            first.write(out);
        }
        while (stack.size() > 0) {
            Ns ns = (Ns)stack.pop();
            out.putInt(0x100101);
            out.putInt(24);
            out.putInt(ns.ln);
            out.putInt(-1);
            out.putInt(ns.prefix.index);
            out.putInt(ns.uri.index);
        }
        return out.array();
    }

    StringItem update(StringItem item) {
        if (item == null) {
            return null;
        }
        int i = this.otherString.indexOf(item);
        if (i < 0) {
            StringItem copy = new StringItem(item.data);
            this.otherString.add(copy);
            return copy;
        }
        return this.otherString.get(i);
    }

    StringItem updateNs(StringItem item) {
        if (item == null) {
            return null;
        }
        String ns = item.data;
        if (!this.nses.containsKey(ns)) {
            this.nses.put(ns, null);
        }
        return this.update(item);
    }

    StringItem updateWithResourceId(StringItem name, int resourceId) {
        String key2 = name.data + resourceId;
        StringItem item = this.resourceId2Str.get(key2);
        if (item != null) {
            return item;
        }
        StringItem copy = new StringItem(name.data);
        this.resourceIds.add(resourceId);
        this.resourceString.add(copy);
        this.resourceId2Str.put(key2, copy);
        return copy;
    }

    static class Ns {
        int ln;
        StringItem prefix;
        StringItem uri;

        public Ns(StringItem prefix, StringItem uri, int ln) {
            this.prefix = prefix;
            this.uri = uri;
            this.ln = ln;
        }
    }

    static class NodeImpl
    extends NodeVisitor {
        private Set<Attr> attrs = new TreeSet<Attr>(ATTR_CMP);
        private List<NodeImpl> children = new ArrayList<NodeImpl>();
        private int line;
        private StringItem name;
        private StringItem ns;
        private StringItem text;
        private int textLineNumber;
        Attr id;
        Attr style;
        Attr clz;

        public NodeImpl(String ns, String name) {
            super(null);
            this.ns = ns == null ? null : new StringItem(ns);
            this.name = name == null ? null : new StringItem(name);
        }

        @Override
        public void attr(String ns, String name, int resourceId, int type, Object value2) {
            if (name == null) {
                throw new RuntimeException("name can't be null");
            }
            Attr a2 = new Attr(ns == null ? null : new StringItem(ns), new StringItem(name), resourceId);
            a2.type = type;
            if (value2 instanceof ValueWrapper) {
                ValueWrapper valueWrapper = (ValueWrapper)value2;
                if (valueWrapper.raw != null) {
                    a2.raw = new StringItem(valueWrapper.raw);
                }
                a2.value = valueWrapper.ref;
                switch (valueWrapper.type) {
                    case 3: {
                        this.clz = a2;
                        break;
                    }
                    case 1: {
                        this.id = a2;
                        break;
                    }
                    case 2: {
                        this.style = a2;
                    }
                }
            } else if (type == 3) {
                StringItem raw2;
                a2.raw = raw2 = new StringItem((String)value2);
                a2.value = raw2;
            } else {
                a2.raw = null;
                a2.value = value2;
            }
            this.attrs.add(a2);
        }

        @Override
        public NodeVisitor child(String ns, String name) {
            NodeImpl child = new NodeImpl(ns, name);
            this.children.add(child);
            return child;
        }

        @Override
        public void end() {
        }

        @Override
        public void line(int ln) {
            this.line = ln;
        }

        public int prepare(AxmlWriter axmlWriter) {
            this.ns = axmlWriter.updateNs(this.ns);
            this.name = axmlWriter.update(this.name);
            int attrIndex = 0;
            for (Attr attr2 : this.attrs) {
                attr2.index = attrIndex++;
                attr2.prepare(axmlWriter);
            }
            this.text = axmlWriter.update(this.text);
            int size2 = 60 + this.attrs.size() * 20;
            for (NodeImpl child : this.children) {
                size2 += child.prepare(axmlWriter);
            }
            if (this.text != null) {
                size2 += 28;
            }
            return size2;
        }

        @Override
        public void text(int ln, String value2) {
            this.text = new StringItem(value2);
            this.textLineNumber = ln;
        }

        void write(ByteBuffer out) throws IOException {
            out.putInt(0x100102);
            out.putInt(36 + this.attrs.size() * 20);
            out.putInt(this.line);
            out.putInt(-1);
            out.putInt(this.ns != null ? this.ns.index : -1);
            out.putInt(this.name.index);
            out.putInt(0x140014);
            out.putShort((short)this.attrs.size());
            out.putShort((short)(this.id == null ? 0 : this.id.index + 1));
            out.putShort((short)(this.clz == null ? 0 : this.clz.index + 1));
            out.putShort((short)(this.style == null ? 0 : this.style.index + 1));
            for (Attr attr2 : this.attrs) {
                out.putInt(attr2.ns == null ? -1 : attr2.ns.index);
                out.putInt(attr2.name.index);
                out.putInt(attr2.raw != null ? attr2.raw.index : -1);
                out.putInt(attr2.type << 24 | 8);
                Object v = attr2.value;
                if (v instanceof StringItem) {
                    out.putInt(((StringItem)attr2.value).index);
                    continue;
                }
                if (v instanceof Boolean) {
                    out.putInt(Boolean.TRUE.equals(v) ? -1 : 0);
                    continue;
                }
                out.putInt((Integer)attr2.value);
            }
            if (this.text != null) {
                out.putInt(0x100104);
                out.putInt(28);
                out.putInt(this.textLineNumber);
                out.putInt(-1);
                out.putInt(this.text.index);
                out.putInt(8);
                out.putInt(0);
            }
            for (NodeImpl child : this.children) {
                child.write(out);
            }
            out.putInt(0x100103);
            out.putInt(24);
            out.putInt(-1);
            out.putInt(-1);
            out.putInt(this.ns != null ? this.ns.index : -1);
            out.putInt(this.name.index);
        }
    }

    static class Attr {
        public int index;
        public StringItem name;
        public StringItem ns;
        public int resourceId;
        public int type;
        public Object value;
        public StringItem raw;

        public Attr(StringItem ns, StringItem name, int resourceId) {
            this.ns = ns;
            this.name = name;
            this.resourceId = resourceId;
        }

        public void prepare(AxmlWriter axmlWriter) {
            this.ns = axmlWriter.updateNs(this.ns);
            if (this.name != null) {
                this.name = this.resourceId != -1 ? axmlWriter.updateWithResourceId(this.name, this.resourceId) : axmlWriter.update(this.name);
            }
            if (this.value instanceof StringItem) {
                this.value = axmlWriter.update((StringItem)this.value);
            }
            if (this.raw != null) {
                this.raw = axmlWriter.update(this.raw);
            }
        }
    }
}

