/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import polyglot.ast.Block;
import polyglot.ast.Catch;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Import;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.SourceFile;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.util.CodeWriter;
import polyglot.visit.NodeVisitor;

public class NodeScrambler
extends NodeVisitor {
    public FirstPass fp = new FirstPass();
    protected HashMap pairs = new HashMap();
    protected LinkedList nodes = new LinkedList();
    protected LinkedList currentParents = new LinkedList();
    protected long seed;
    protected Random ran;
    protected boolean scrambled = false;
    protected CodeWriter cw = new CodeWriter(System.err, 72);
    static /* synthetic */ Class class$polyglot$ast$Node;
    static /* synthetic */ Class class$polyglot$ast$Import;
    static /* synthetic */ Class class$polyglot$ast$TypeNode;
    static /* synthetic */ Class class$polyglot$ast$ClassDecl;
    static /* synthetic */ Class class$polyglot$ast$ClassMember;
    static /* synthetic */ Class class$polyglot$ast$Formal;
    static /* synthetic */ Class class$polyglot$ast$Expr;
    static /* synthetic */ Class class$polyglot$ast$Block;
    static /* synthetic */ Class class$polyglot$ast$Catch;
    static /* synthetic */ Class class$polyglot$ast$LocalDecl;
    static /* synthetic */ Class class$polyglot$ast$Stmt;

    public NodeScrambler() {
        Random ran = new Random();
        this.seed = ran.nextLong();
        System.err.println("Using seed: " + this.seed);
        this.ran = new Random(this.seed);
    }

    public NodeScrambler(long seed) {
        this.seed = seed;
        this.ran = new Random(seed);
    }

    public long getSeed() {
        return this.seed;
    }

    public Node override(Node n) {
        if (this.coinFlip()) {
            Node m = this.potentialScramble(n);
            if (m == null) {
                return null;
            }
            this.scrambled = true;
            try {
                System.err.println("Replacing:");
                n.dump(this.cw);
                this.cw.newline();
                this.cw.flush();
                System.err.println("With:");
                m.dump(this.cw);
                this.cw.newline();
                this.cw.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            return m;
        }
        return null;
    }

    protected boolean coinFlip() {
        if (this.scrambled) {
            return false;
        }
        return this.ran.nextDouble() > 0.9;
    }

    protected Node potentialScramble(Node n) {
        Class required;
        Class clazz = required = class$polyglot$ast$Node == null ? (class$polyglot$ast$Node = NodeScrambler.class$("polyglot.ast.Node")) : class$polyglot$ast$Node;
        if (n instanceof SourceFile) {
            return null;
        }
        if (n instanceof Import) {
            required = class$polyglot$ast$Import == null ? (class$polyglot$ast$Import = NodeScrambler.class$("polyglot.ast.Import")) : class$polyglot$ast$Import;
        } else if (n instanceof TypeNode) {
            required = class$polyglot$ast$TypeNode == null ? (class$polyglot$ast$TypeNode = NodeScrambler.class$("polyglot.ast.TypeNode")) : class$polyglot$ast$TypeNode;
        } else if (n instanceof ClassDecl) {
            required = class$polyglot$ast$ClassDecl == null ? (class$polyglot$ast$ClassDecl = NodeScrambler.class$("polyglot.ast.ClassDecl")) : class$polyglot$ast$ClassDecl;
        } else if (n instanceof ClassMember) {
            required = class$polyglot$ast$ClassMember == null ? (class$polyglot$ast$ClassMember = NodeScrambler.class$("polyglot.ast.ClassMember")) : class$polyglot$ast$ClassMember;
        } else if (n instanceof Formal) {
            required = class$polyglot$ast$Formal == null ? (class$polyglot$ast$Formal = NodeScrambler.class$("polyglot.ast.Formal")) : class$polyglot$ast$Formal;
        } else if (n instanceof Expr) {
            required = class$polyglot$ast$Expr == null ? (class$polyglot$ast$Expr = NodeScrambler.class$("polyglot.ast.Expr")) : class$polyglot$ast$Expr;
        } else if (n instanceof Block) {
            required = class$polyglot$ast$Block == null ? (class$polyglot$ast$Block = NodeScrambler.class$("polyglot.ast.Block")) : class$polyglot$ast$Block;
        } else if (n instanceof Catch) {
            required = class$polyglot$ast$Catch == null ? (class$polyglot$ast$Catch = NodeScrambler.class$("polyglot.ast.Catch")) : class$polyglot$ast$Catch;
        } else if (n instanceof LocalDecl) {
            required = class$polyglot$ast$LocalDecl == null ? (class$polyglot$ast$LocalDecl = NodeScrambler.class$("polyglot.ast.LocalDecl")) : class$polyglot$ast$LocalDecl;
        } else if (n instanceof Stmt) {
            required = class$polyglot$ast$Stmt == null ? (class$polyglot$ast$Stmt = NodeScrambler.class$("polyglot.ast.Stmt")) : class$polyglot$ast$Stmt;
        }
        LinkedList parents = (LinkedList)this.pairs.get(n);
        Iterator iter1 = this.nodes.iterator();
        while (iter1.hasNext()) {
            Node m = (Node)iter1.next();
            if (!required.isAssignableFrom(m.getClass())) continue;
            boolean isParent = false;
            Iterator iter2 = parents.iterator();
            while (iter2.hasNext()) {
                if (m != iter2.next()) continue;
                isParent = true;
            }
            if (isParent || m == n) continue;
            return m;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class FirstPass
    extends NodeVisitor {
        public NodeVisitor enter(Node n) {
            NodeScrambler.this.pairs.put(n, NodeScrambler.this.currentParents.clone());
            NodeScrambler.this.nodes.add(n);
            NodeScrambler.this.currentParents.add(n);
            return this;
        }

        public Node leave(Node old, Node n, NodeVisitor v) {
            NodeScrambler.this.currentParents.remove(n);
            return n;
        }
    }
}

