/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.CompoundStmt;
import polyglot.ast.Do;
import polyglot.ast.Empty;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.For;
import polyglot.ast.If;
import polyglot.ast.Local;
import polyglot.ast.LocalAssign;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Stmt;
import polyglot.ast.Switch;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.ast.While;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;
import polyglot.visit.HaltingVisitor;
import polyglot.visit.NodeVisitor;

public class DeadCodeEliminator
extends DataFlow {
    public DeadCodeEliminator(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, false, true);
    }

    public DataFlow.Item createInitialItem(FlowGraph graph, Term node) {
        return new DataFlowItem();
    }

    public DataFlow.Item confluence(List inItems, Term node, FlowGraph graph) {
        DataFlowItem result2 = null;
        Iterator it = inItems.iterator();
        while (it.hasNext()) {
            DataFlowItem inItem = (DataFlowItem)it.next();
            if (result2 == null) {
                result2 = new DataFlowItem(inItem);
                continue;
            }
            result2.union(inItem);
        }
        return result2;
    }

    public Map flow(DataFlow.Item in, FlowGraph graph, Term t, Set succEdgeKeys) {
        return DeadCodeEliminator.itemToMap(this.flow(in, graph, t), succEdgeKeys);
    }

    protected DataFlowItem flow(DataFlow.Item in, FlowGraph graph, Term t) {
        DataFlowItem result2 = new DataFlowItem((DataFlowItem)in);
        Set[] du = null;
        if (t instanceof LocalDecl) {
            LocalDecl n = (LocalDecl)t;
            LocalInstance to2 = n.localInstance();
            result2.removeDecl(to2);
            du = this.getDefUse(n.init());
        } else if (t instanceof Stmt && !(t instanceof CompoundStmt)) {
            du = this.getDefUse((Stmt)t);
        } else if (t instanceof CompoundStmt) {
            if (t instanceof If) {
                du = this.getDefUse(((If)t).cond());
            } else if (t instanceof Switch) {
                du = this.getDefUse(((Switch)t).expr());
            } else if (t instanceof Do) {
                du = this.getDefUse(((Do)t).cond());
            } else if (t instanceof For) {
                du = this.getDefUse(((For)t).cond());
            } else if (t instanceof While) {
                du = this.getDefUse(((While)t).cond());
            }
        }
        if (du != null) {
            result2.removeAll(du[0]);
            result2.addAll(du[1]);
        }
        return result2;
    }

    public void post(FlowGraph graph, Term root) throws SemanticException {
        if (Report.should_report("cfg", 2)) {
            this.dumpFlowGraph(graph, root);
        }
    }

    public void check(FlowGraph graph, Term n, DataFlow.Item inItem, Map outItems) throws SemanticException {
        throw new InternalCompilerError("DeadCodeEliminator.check should never be called.");
    }

    private DataFlowItem getItem(Term n) {
        FlowGraph g = this.currentFlowGraph();
        if (g == null) {
            return null;
        }
        Collection peers = g.peers(n);
        if (peers == null || peers.isEmpty()) {
            return null;
        }
        ArrayList<DataFlow.Item> items = new ArrayList<DataFlow.Item>();
        Iterator it = peers.iterator();
        while (it.hasNext()) {
            FlowGraph.Peer p = (FlowGraph.Peer)it.next();
            if (p.inItem() == null) continue;
            items.add(p.inItem());
        }
        return (DataFlowItem)this.confluence(items, n, g);
    }

    public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof LocalDecl) {
            LocalDecl ld = (LocalDecl)n;
            DataFlowItem in = this.getItem(ld);
            if (in == null || in.needDecl(ld.localInstance())) {
                return n;
            }
            return this.getEffects(ld.init());
        }
        if (n instanceof Eval) {
            Local local;
            Eval eval = (Eval)n;
            Expr expr = eval.expr();
            Expr right = null;
            if (expr instanceof Assign) {
                Assign assign = (Assign)expr;
                Expr left = assign.left();
                right = assign.right();
                if (!(left instanceof Local)) {
                    return n;
                }
                local = (Local)left;
            } else if (expr instanceof Unary) {
                Unary unary = (Unary)expr;
                if (!((expr = unary.expr()) instanceof Local)) {
                    return n;
                }
                local = (Local)expr;
            } else {
                return n;
            }
            DataFlowItem in = this.getItem(eval);
            if (in == null || in.needDef(local.localInstance())) {
                return n;
            }
            if (right != null) {
                return this.getEffects(right);
            }
            return this.nf.Empty(Position.COMPILER_GENERATED);
        }
        if (n instanceof Block) {
            Block b = (Block)n;
            ArrayList stmts = new ArrayList(b.statements());
            Iterator it = stmts.iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof Empty)) continue;
                it.remove();
            }
            return b.statements(stmts);
        }
        return n;
    }

    protected Set[] getDefUse(Node n) {
        HashSet def = new HashSet();
        HashSet use = new HashSet();
        if (n != null) {
            n.visit(this.createDefUseFinder(def, use));
        }
        return new Set[]{def, use};
    }

    protected NodeVisitor createDefUseFinder(Set def, Set use) {
        return new DefUseFinder(def, use);
    }

    protected Stmt getEffects(Expr expr) {
        Empty empty = this.nf.Empty(Position.COMPILER_GENERATED);
        if (expr == null) {
            return empty;
        }
        final LinkedList result2 = new LinkedList();
        final Position pos = Position.COMPILER_GENERATED;
        HaltingVisitor v = new HaltingVisitor(){

            public NodeVisitor enter(Node n) {
                Unary.Operator op;
                if (n instanceof Assign || n instanceof ProcedureCall) {
                    return this.bypassChildren(n);
                }
                if (n instanceof Unary && ((op = ((Unary)n).operator()) == Unary.POST_INC || op == Unary.POST_DEC || op == Unary.PRE_INC || op == Unary.PRE_INC)) {
                    return this.bypassChildren(n);
                }
                return this;
            }

            public Node leave(Node old, Node n, NodeVisitor v) {
                Unary.Operator op;
                if (n instanceof Assign || n instanceof ProcedureCall) {
                    result2.add(DeadCodeEliminator.this.nf.Eval(pos, (Expr)n));
                } else if (n instanceof Unary && ((op = ((Unary)n).operator()) == Unary.POST_INC || op == Unary.POST_DEC || op == Unary.PRE_INC || op == Unary.PRE_INC)) {
                    result2.add(DeadCodeEliminator.this.nf.Eval(pos, (Expr)n));
                }
                return n;
            }
        };
        expr.visit(v);
        if (result2.isEmpty()) {
            return empty;
        }
        if (result2.size() == 1) {
            return (Stmt)result2.get(0);
        }
        return this.nf.Block(Position.COMPILER_GENERATED, result2);
    }

    protected static class DefUseFinder
    extends HaltingVisitor {
        protected Set def;
        protected Set use;

        public DefUseFinder(Set def, Set use) {
            this.def = def;
            this.use = use;
        }

        public NodeVisitor enter(Node n) {
            if (n instanceof LocalAssign) {
                return this.bypass(((Assign)n).left());
            }
            return super.enter(n);
        }

        public Node leave(Node old, Node n, NodeVisitor v) {
            Expr left;
            if (n instanceof Local) {
                this.use.add(((Local)n).localInstance());
            } else if (n instanceof Assign && (left = ((Assign)n).left()) instanceof Local) {
                this.def.add(((Local)left).localInstance());
            }
            return n;
        }
    }

    protected static class DataFlowItem
    extends DataFlow.Item {
        private Set liveVars;
        private Set liveDecls;

        protected DataFlowItem() {
            this.liveVars = new HashSet();
            this.liveDecls = new HashSet();
        }

        protected DataFlowItem(DataFlowItem dfi) {
            this.liveVars = new HashSet(dfi.liveVars);
            this.liveDecls = new HashSet(dfi.liveDecls);
        }

        public void add(LocalInstance li) {
            this.liveVars.add(li);
            this.liveDecls.add(li);
        }

        public void addAll(Set lis) {
            this.liveVars.addAll(lis);
            this.liveDecls.addAll(lis);
        }

        public void remove(LocalInstance li) {
            this.liveVars.remove(li);
        }

        public void removeAll(Set lis) {
            this.liveVars.removeAll(lis);
        }

        public void removeDecl(LocalInstance li) {
            this.liveVars.remove(li);
            this.liveDecls.remove(li);
        }

        public void union(DataFlowItem dfi) {
            this.liveVars.addAll(dfi.liveVars);
            this.liveDecls.addAll(dfi.liveDecls);
        }

        protected boolean needDecl(LocalInstance li) {
            return this.liveDecls.contains(li);
        }

        protected boolean needDef(LocalInstance li) {
            return this.liveVars.contains(li);
        }

        public int hashCode() {
            int result2 = 0;
            Iterator it = this.liveVars.iterator();
            while (it.hasNext()) {
                result2 = 31 * result2 + it.next().hashCode();
            }
            it = this.liveDecls.iterator();
            while (it.hasNext()) {
                result2 = 31 * result2 + it.next().hashCode();
            }
            return result2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DataFlowItem)) {
                return false;
            }
            DataFlowItem dfi = (DataFlowItem)o;
            return ((Object)this.liveVars).equals(dfi.liveVars) && ((Object)this.liveDecls).equals(dfi.liveDecls);
        }

        public String toString() {
            return "<vars=" + this.liveVars + " ; decls=" + this.liveDecls + ">";
        }
    }
}

