/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;

public class SubtypeSet
implements Set {
    Vector v;
    TypeSystem ts;
    Type topType;

    public SubtypeSet(TypeSystem ts) {
        this(ts.Object());
    }

    public SubtypeSet(Type top) {
        this.v = new Vector();
        this.ts = top.typeSystem();
        this.topType = top;
    }

    public SubtypeSet(SubtypeSet s2) {
        this.v = new Vector(s2.v);
        this.ts = s2.ts;
        this.topType = s2.topType;
    }

    public SubtypeSet(TypeSystem ts, Collection c) {
        this(ts);
        this.addAll(c);
    }

    public SubtypeSet(Type top, Collection c) {
        this(top);
        this.addAll(c);
    }

    public boolean add(Object o) {
        Type type;
        if (o == null) {
            return false;
        }
        if (o instanceof Type && this.ts.isSubtype(type = (Type)o, this.topType)) {
            boolean haveToAdd = true;
            Iterator i = this.v.iterator();
            while (i.hasNext()) {
                Type t = (Type)i.next();
                if (this.ts.descendsFrom(t, type)) {
                    i.remove();
                }
                if (!this.ts.isSubtype(type, t)) continue;
                haveToAdd = false;
                break;
            }
            if (haveToAdd) {
                this.v.add(type);
            }
            return haveToAdd;
        }
        throw new InternalCompilerError("Can only add " + this.topType + "s to the set. Got a " + o);
    }

    public boolean addAll(Collection c) {
        if (c == null) {
            return false;
        }
        boolean changed = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            changed |= this.add(i.next());
        }
        return changed;
    }

    public void clear() {
        this.v.clear();
    }

    public boolean contains(Object o) {
        if (o instanceof Type) {
            Type type = (Type)o;
            Iterator i = this.v.iterator();
            while (i.hasNext()) {
                Type t = (Type)i.next();
                if (!this.ts.isSubtype(type, t)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsSubtype(Type type) {
        Iterator i = this.v.iterator();
        while (i.hasNext()) {
            Type t = (Type)i.next();
            if (!this.ts.isSubtype(type, t) && !this.ts.isSubtype(t, type)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.v.isEmpty();
    }

    public Iterator iterator() {
        return this.v.iterator();
    }

    public boolean remove(Object o) {
        Type type = (Type)o;
        boolean removed = false;
        Iterator i = this.v.iterator();
        while (i.hasNext()) {
            Type t = (Type)i.next();
            if (!this.ts.isSubtype(t, type)) continue;
            removed = true;
            i.remove();
        }
        return removed;
    }

    public boolean removeAll(Collection c) {
        boolean changed = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            changed |= this.remove(o);
        }
        return changed;
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("Not supported");
    }

    public int size() {
        return this.v.size();
    }

    public Object[] toArray() {
        return this.v.toArray();
    }

    public Object[] toArray(Object[] a2) {
        return this.v.toArray(a2);
    }

    public String toString() {
        return this.v.toString();
    }
}

