/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types.reflect;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Report;
import polyglot.types.CachingResolver;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.LazyClassInitializer;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.Attribute;
import polyglot.types.reflect.ClassFileLoader;
import polyglot.types.reflect.Constant;
import polyglot.types.reflect.Field;
import polyglot.types.reflect.InnerClasses;
import polyglot.types.reflect.JLCInfo;
import polyglot.types.reflect.Method;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.StringUtil;

public class ClassFile
implements LazyClassInitializer {
    protected Constant[] constants;
    int modifiers;
    int thisClass;
    int superClass;
    int[] interfaces;
    protected Field[] fields;
    protected Method[] methods;
    protected Attribute[] attrs;
    protected InnerClasses innerClasses;
    File classFileSource;
    private ExtensionInfo extensionInfo;
    static Collection verbose = ClassFileLoader.verbose;
    Map jlcInfo = new HashMap();

    public ClassFile(File classFileSource, byte[] code, ExtensionInfo ext) {
        this.classFileSource = classFileSource;
        this.extensionInfo = ext;
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(code);
            DataInputStream in = new DataInputStream(bin);
            this.read(in);
            in.close();
            bin.close();
        }
        catch (IOException e) {
            throw new InternalCompilerError("I/O exception on ByteArrayInputStream");
        }
    }

    public Method createMethod(DataInputStream in) throws IOException {
        Method m = new Method(in, this);
        m.initialize();
        return m;
    }

    public Field createField(DataInputStream in) throws IOException {
        Field f = new Field(in, this);
        f.initialize();
        return f;
    }

    public Attribute createAttribute(DataInputStream in, String name, int nameIndex, int length2) throws IOException {
        if (name.equals("InnerClasses")) {
            this.innerClasses = new InnerClasses(in, nameIndex, length2);
            return this.innerClasses;
        }
        return null;
    }

    public Constant[] constants() {
        return this.constants;
    }

    public boolean fromClassFile() {
        return true;
    }

    JLCInfo getJLCInfo(String ts) {
        JLCInfo jlc = (JLCInfo)this.jlcInfo.get(ts);
        if (jlc != null) {
            return jlc;
        }
        jlc = new JLCInfo();
        this.jlcInfo.put(ts, jlc);
        try {
            int mask = 0;
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i].name().equals("jlc$SourceLastModified$" + ts)) {
                    jlc.sourceLastModified = this.fields[i].getLong();
                    mask |= 1;
                    continue;
                }
                if (this.fields[i].name().equals("jlc$CompilerVersion$" + ts)) {
                    jlc.compilerVersion = this.fields[i].getString();
                    mask |= 2;
                    continue;
                }
                if (!this.fields[i].name().equals("jlc$ClassType$" + ts)) continue;
                jlc.encodedClassType = this.fields[i].getString();
                mask |= 4;
            }
            if (mask != 7) {
                jlc.sourceLastModified = 0L;
                jlc.compilerVersion = null;
                jlc.encodedClassType = null;
            }
        }
        catch (SemanticException e) {
            jlc.sourceLastModified = 0L;
            jlc.compilerVersion = null;
            jlc.encodedClassType = null;
        }
        return jlc;
    }

    public long sourceLastModified(String ts) {
        JLCInfo jlc = this.getJLCInfo(ts);
        return jlc.sourceLastModified;
    }

    public long rawSourceLastModified() {
        return this.classFileSource.lastModified();
    }

    public String compilerVersion(String ts) {
        JLCInfo jlc = this.getJLCInfo(ts);
        return jlc.compilerVersion;
    }

    public String encodedClassType(String ts) {
        JLCInfo jlc = this.getJLCInfo(ts);
        return jlc.encodedClassType;
    }

    void read(DataInputStream in) throws IOException {
        this.readHeader(in);
        this.readConstantPool(in);
        this.readAccessFlags(in);
        this.readClassInfo(in);
        this.readFields(in);
        this.readMethods(in);
        this.readAttributes(in);
    }

    public ParsedClassType type(TypeSystem ts) throws SemanticException {
        ParsedClassType ct = this.createType(ts);
        if (ts.equals(ct, ts.Object())) {
            ct.superType(null);
        } else {
            String superName = this.classNameCP(this.superClass);
            if (superName != null) {
                ct.superType(this.typeForName(ts, superName));
            } else {
                ct.superType(ts.Object());
            }
        }
        return ct;
    }

    public void initMemberClasses(ParsedClassType ct) {
        if (this.innerClasses == null) {
            return;
        }
        TypeSystem ts = ct.typeSystem();
        for (int i = 0; i < this.innerClasses.classes.length; ++i) {
            String name;
            int index;
            InnerClasses.Info c = this.innerClasses.classes[i];
            if (c.outerClassIndex != this.thisClass || c.classIndex == 0 || (index = (name = this.classNameCP(c.classIndex)).lastIndexOf(36)) >= 0 && Character.isDigit(name.charAt(index + 1))) continue;
            ClassType t = this.quietTypeForName(ts, name);
            if (t.isMember()) {
                if (Report.should_report(verbose, 3)) {
                    Report.report(3, "adding member " + t + " to " + ct);
                }
                ct.addMemberClass(t);
                if (!(t instanceof ParsedClassType)) continue;
                ParsedClassType pt = (ParsedClassType)t;
                pt.flags(ts.flagsForBits(c.modifiers));
                continue;
            }
            throw new InternalCompilerError(name + " should be a member class.");
        }
    }

    public void initInterfaces(ParsedClassType ct) {
        TypeSystem ts = ct.typeSystem();
        for (int i = 0; i < this.interfaces.length; ++i) {
            String name = this.classNameCP(this.interfaces[i]);
            ct.addInterface(this.quietTypeForName(ts, name));
        }
    }

    public void initFields(ParsedClassType ct) {
        TypeSystem ts = ct.typeSystem();
        LazyClassInitializer init2 = ts.defaultClassInitializer();
        init2.initFields(ct);
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].name().startsWith("jlc$") || this.fields[i].isSynthetic()) continue;
            FieldInstance fi = this.fields[i].fieldInstance(ts, ct);
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "adding " + fi + " to " + ct);
            }
            ct.addField(fi);
        }
    }

    public void initMethods(ParsedClassType ct) {
        TypeSystem ts = ct.typeSystem();
        for (int i = 0; i < this.methods.length; ++i) {
            if (this.methods[i].name().equals("<init>") || this.methods[i].name().equals("<clinit>") || this.methods[i].isSynthetic()) continue;
            MethodInstance mi = this.methods[i].methodInstance(ts, ct);
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "adding " + mi + " to " + ct);
            }
            ct.addMethod(mi);
        }
    }

    public void initConstructors(ParsedClassType ct) {
        TypeSystem ts = ct.typeSystem();
        for (int i = 0; i < this.methods.length; ++i) {
            if (!this.methods[i].name().equals("<init>") || this.methods[i].isSynthetic()) continue;
            ConstructorInstance ci = this.methods[i].constructorInstance(ts, ct, this.fields);
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "adding " + ci + " to " + ct);
            }
            ct.addConstructor(ci);
        }
    }

    Type arrayOf(Type t, int dims) {
        if (dims == 0) {
            return t;
        }
        return t.typeSystem().arrayOf(t, dims);
    }

    List typeListForString(TypeSystem ts, String str) {
        ArrayList<Type> types = new ArrayList<Type>();
        block12: for (int i = 0; i < str.length(); ++i) {
            int dims = 0;
            while (str.charAt(i) == '[') {
                ++dims;
                ++i;
            }
            switch (str.charAt(i)) {
                case 'Z': {
                    types.add(this.arrayOf(ts.Boolean(), dims));
                    continue block12;
                }
                case 'B': {
                    types.add(this.arrayOf(ts.Byte(), dims));
                    continue block12;
                }
                case 'S': {
                    types.add(this.arrayOf(ts.Short(), dims));
                    continue block12;
                }
                case 'C': {
                    types.add(this.arrayOf(ts.Char(), dims));
                    continue block12;
                }
                case 'I': {
                    types.add(this.arrayOf(ts.Int(), dims));
                    continue block12;
                }
                case 'J': {
                    types.add(this.arrayOf(ts.Long(), dims));
                    continue block12;
                }
                case 'F': {
                    types.add(this.arrayOf(ts.Float(), dims));
                    continue block12;
                }
                case 'D': {
                    types.add(this.arrayOf(ts.Double(), dims));
                    continue block12;
                }
                case 'V': {
                    types.add(this.arrayOf(ts.Void(), dims));
                    continue block12;
                }
                case 'L': {
                    int start = ++i;
                    while (i < str.length()) {
                        if (str.charAt(i) == ';') {
                            String s2 = str.substring(start, i);
                            s2 = s2.replace('/', '.');
                            types.add(this.arrayOf(this.quietTypeForName(ts, s2), dims));
                            continue block12;
                        }
                        ++i;
                    }
                    continue block12;
                }
            }
        }
        if (Report.should_report(verbose, 4)) {
            Report.report(4, "parsed \"" + str + "\" -> " + types);
        }
        return types;
    }

    Type typeForString(TypeSystem ts, String str) {
        List l = this.typeListForString(ts, str);
        if (l.size() == 1) {
            return (Type)l.get(0);
        }
        throw new InternalCompilerError("Bad type string: \"" + str + "\"");
    }

    ClassType quietTypeForName(TypeSystem ts, String name) {
        if (Report.should_report(verbose, 2)) {
            Report.report(2, "resolving " + name);
        }
        try {
            return (ClassType)ts.systemResolver().find(name);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("could not load " + name);
        }
    }

    public ClassType typeForName(TypeSystem ts, String name) throws SemanticException {
        if (Report.should_report(verbose, 2)) {
            Report.report(2, "resolving " + name);
        }
        return (ClassType)ts.systemResolver().find(name);
    }

    ParsedClassType createType(TypeSystem ts) throws SemanticException {
        String name = this.classNameCP(this.thisClass);
        if (Report.should_report(verbose, 2)) {
            Report.report(2, "creating ClassType for " + name);
        }
        ParsedClassType ct = ts.createClassType(this);
        ct.flags(ts.flagsForBits(this.modifiers));
        ct.position(this.position());
        ((CachingResolver)ts.systemResolver()).install(name, ct);
        String packageName = StringUtil.getPackageComponent(name);
        if (!packageName.equals("")) {
            ct.package_(ts.packageForName(packageName));
        }
        String className = StringUtil.getShortNameComponent(name);
        String outerName = name;
        String innerName = null;
        while (true) {
            int dollar;
            if ((dollar = outerName.lastIndexOf(36)) < 0) {
                outerName = name;
                innerName = null;
                break;
            }
            outerName = name.substring(0, dollar);
            innerName = name.substring(dollar + 1);
            try {
                if (Report.should_report(verbose, 2)) {
                    Report.report(2, "resolving " + outerName + " for " + name);
                }
                ct.outer(this.typeForName(ts, outerName));
            }
            catch (SemanticException e) {
                if (!Report.should_report(verbose, 3)) continue;
                Report.report(2, "error resolving " + outerName);
                continue;
            }
            break;
        }
        ClassType.Kind kind = ClassType.TOP_LEVEL;
        if (innerName != null) {
            StringTokenizer st = new StringTokenizer(className, "$");
            while (st.hasMoreTokens()) {
                String s2 = st.nextToken();
                if (Character.isDigit(s2.charAt(0))) {
                    kind = ClassType.ANONYMOUS;
                    continue;
                }
                if (kind == ClassType.ANONYMOUS) {
                    kind = ClassType.LOCAL;
                    continue;
                }
                kind = ClassType.MEMBER;
            }
        }
        if (Report.should_report(verbose, 3)) {
            Report.report(3, name + " is " + kind);
        }
        ct.kind(kind);
        if (ct.isTopLevel()) {
            ct.name(className);
        } else if (ct.isMember() || ct.isLocal()) {
            ct.name(innerName);
        }
        return ct;
    }

    public Position position() {
        return new Position(this.name() + ".class");
    }

    String classNameCP(int index) {
        Integer nameIndex;
        Constant c = this.constants[index];
        if (c != null && c.tag() == 7 && (nameIndex = (Integer)c.value()) != null && (c = this.constants[nameIndex]).tag() == 1) {
            String s2 = (String)c.value();
            return s2.replace('/', '.');
        }
        return null;
    }

    public String name() {
        Integer nameIndex;
        Constant c = this.constants[this.thisClass];
        if (c.tag() == 7 && (nameIndex = (Integer)c.value()) != null && (c = this.constants[nameIndex]).tag() == 1) {
            return (String)c.value();
        }
        throw new ClassFormatError("Couldn't find class name in file");
    }

    /*
     * WARNING - void declaration
     */
    Constant readConstant(DataInputStream in) throws IOException {
        void var3_3;
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 7: 
            case 8: {
                Object value2 = new Integer(in.readUnsignedShort());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                Object value2 = new int[]{in.readUnsignedShort(), in.readUnsignedShort()};
                break;
            }
            case 3: {
                Object value2 = new Integer(in.readInt());
                break;
            }
            case 4: {
                Object value2 = new Float(in.readFloat());
                break;
            }
            case 5: {
                Object value2 = new Long(in.readLong());
                break;
            }
            case 6: {
                Object value2 = new Double(in.readDouble());
                break;
            }
            case 1: {
                Object value2 = in.readUTF();
                break;
            }
            default: {
                throw new ClassFormatError("Invalid constant tag: " + tag);
            }
        }
        return new Constant(tag, var3_3);
    }

    void readHeader(DataInputStream in) throws IOException {
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new ClassFormatError("Bad magic number.");
        }
        int major = in.readUnsignedShort();
        int minor = in.readUnsignedShort();
    }

    void readConstantPool(DataInputStream in) throws IOException {
        int count2 = in.readUnsignedShort();
        this.constants = new Constant[count2];
        this.constants[0] = null;
        for (int i = 1; i < count2; ++i) {
            this.constants[i] = this.readConstant(in);
            switch (this.constants[i].tag()) {
                case 5: 
                case 6: {
                    this.constants[++i] = null;
                }
            }
        }
    }

    void readAccessFlags(DataInputStream in) throws IOException {
        this.modifiers = in.readUnsignedShort();
    }

    void readClassInfo(DataInputStream in) throws IOException {
        this.thisClass = in.readUnsignedShort();
        this.superClass = in.readUnsignedShort();
        int numInterfaces = in.readUnsignedShort();
        this.interfaces = new int[numInterfaces];
        for (int i = 0; i < numInterfaces; ++i) {
            this.interfaces[i] = in.readUnsignedShort();
        }
    }

    void readFields(DataInputStream in) throws IOException {
        int numFields = in.readUnsignedShort();
        this.fields = new Field[numFields];
        for (int i = 0; i < numFields; ++i) {
            this.fields[i] = this.createField(in);
        }
    }

    void readMethods(DataInputStream in) throws IOException {
        int numMethods = in.readUnsignedShort();
        this.methods = new Method[numMethods];
        for (int i = 0; i < numMethods; ++i) {
            this.methods[i] = this.createMethod(in);
        }
    }

    public void readAttributes(DataInputStream in) throws IOException {
        int numAttributes = in.readUnsignedShort();
        this.attrs = new Attribute[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            int nameIndex = in.readUnsignedShort();
            int length2 = in.readInt();
            String name = (String)this.constants[nameIndex].value();
            Attribute a2 = this.createAttribute(in, name, nameIndex, length2);
            if (a2 != null) {
                this.attrs[i] = a2;
                continue;
            }
            long n = in.skip(length2);
            if (n == (long)length2) continue;
            throw new EOFException();
        }
    }
}

