/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.BarrierPass;
import polyglot.frontend.Compiler;
import polyglot.frontend.CyclicDependencyException;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileSource;
import polyglot.frontend.GlobalBarrierPass;
import polyglot.frontend.InnerJob;
import polyglot.frontend.Job;
import polyglot.frontend.JobExt;
import polyglot.frontend.Parser;
import polyglot.frontend.Pass;
import polyglot.frontend.Source;
import polyglot.frontend.SourceJob;
import polyglot.frontend.SourceLoader;
import polyglot.frontend.Stats;
import polyglot.frontend.TargetFactory;
import polyglot.main.Options;
import polyglot.main.Report;
import polyglot.types.Context;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.ClassFile;
import polyglot.util.CodeWriter;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.visit.DumpAst;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public abstract class AbstractExtensionInfo
implements ExtensionInfo {
    protected Compiler compiler;
    private Options options;
    protected TypeSystem ts = null;
    protected NodeFactory nf = null;
    protected SourceLoader source_loader = null;
    protected TargetFactory target_factory = null;
    protected Stats stats;
    protected LinkedList worklist;
    protected Map jobs;
    protected static final Object COMPLETED_JOB = "COMPLETED JOB";
    protected Job currentJob;

    public Options getOptions() {
        if (this.options == null) {
            this.options = this.createOptions();
        }
        return this.options;
    }

    protected Options createOptions() {
        return new Options(this);
    }

    public Stats getStats() {
        if (this.stats == null) {
            this.stats = new Stats(this);
        }
        return this.stats;
    }

    public Compiler compiler() {
        return this.compiler;
    }

    public void initCompiler(Compiler compiler) {
        this.compiler = compiler;
        this.jobs = new HashMap();
        this.worklist = new LinkedList();
        compiler.addExtension(this);
        this.currentJob = null;
        this.typeSystem();
        this.nodeFactory();
        this.initTypeSystem();
    }

    protected abstract void initTypeSystem();

    public boolean runToCompletion() {
        boolean okay = true;
        while (okay && !this.worklist.isEmpty()) {
            SourceJob job = this.selectJobFromWorklist();
            if (Report.should_report("frontend", 1)) {
                Report.report(1, "Running job " + job);
            }
            okay &= this.runAllPasses(job);
            if (job.completed()) {
                this.jobs.put(job.source(), COMPLETED_JOB);
                if (!Report.should_report("frontend", 1)) continue;
                Report.report(1, "Completed job " + job);
                continue;
            }
            if (Report.should_report("frontend", 1)) {
                Report.report(1, "Failed to complete job " + job);
            }
            this.worklist.add(job);
        }
        if (Report.should_report("frontend", 1)) {
            Report.report(1, "Finished all passes -- " + (okay ? "okay" : "failed"));
        }
        return okay;
    }

    protected SourceJob selectJobFromWorklist() {
        return (SourceJob)this.worklist.remove(0);
    }

    public boolean readSource(FileSource source) {
        Pass.ID barrier;
        SourceJob job = this.addJob(source);
        if (job == null) {
            return true;
        }
        if (this.currentJob != null) {
            if (this.currentJob.sourceJob().lastBarrier() == null) {
                throw new InternalCompilerError("A Source Job which has not reached a barrier cannot read another source file.");
            }
            barrier = this.currentJob.sourceJob().lastBarrier().id();
        } else {
            barrier = Pass.FIRST_BARRIER;
        }
        return this.runToPass((Job)job, barrier) && this.runToPass((Job)job, Pass.FIRST_BARRIER);
    }

    public boolean runAllPasses(Job job) {
        List pending = job.pendingPasses();
        if (!pending.isEmpty()) {
            Pass lastPass = (Pass)pending.get(pending.size() - 1);
            return this.runToPass(job, lastPass);
        }
        return true;
    }

    public boolean runToPass(Job job, Pass.ID goal) {
        if (Report.should_report("frontend", 1)) {
            Report.report(1, "Running " + job + " to pass named " + goal);
        }
        if (job.completed(goal)) {
            return true;
        }
        Pass pass = job.passByID(goal);
        return this.runToPass(job, pass);
    }

    public boolean runToPass(Job job, Pass goal) {
        if (Report.should_report("frontend", 1)) {
            Report.report(1, "Running " + job + " to pass " + goal);
        }
        while (!job.pendingPasses().isEmpty()) {
            Pass pass = (Pass)job.pendingPasses().get(0);
            try {
                this.runPass(job, pass);
            }
            catch (CyclicDependencyException e) {
                job.finishPass(pass, false);
            }
            if (pass != goal) continue;
            break;
        }
        if (job.completed() && Report.should_report("frontend", 1)) {
            Report.report(1, "Job " + job + " completed");
        }
        return job.status();
    }

    protected void runPass(Job job, Pass pass) throws CyclicDependencyException {
        try {
            this.enforceInvariants(job, pass);
        }
        catch (CyclicDependencyException e) {
            return;
        }
        if (this.getOptions().disable_passes.contains(pass.name())) {
            if (Report.should_report("frontend", 1)) {
                Report.report(1, "Skipping pass " + pass);
            }
            job.finishPass(pass, true);
            return;
        }
        if (Report.should_report("frontend", 1)) {
            Report.report(1, "Trying to run pass " + pass + " in " + job);
        }
        if (job.isRunning()) {
            throw new CyclicDependencyException(job + " cannot reach pass " + pass);
        }
        pass.resetTimers();
        boolean result2 = false;
        if (job.status()) {
            Pass oldPass;
            Job oldCurrentJob = this.currentJob;
            this.currentJob = job;
            Report.should_report.push(pass.name());
            Pass pass2 = oldPass = oldCurrentJob != null ? oldCurrentJob.runningPass() : null;
            if (oldPass != null) {
                oldPass.toggleTimers(true);
            }
            job.setRunningPass(pass);
            pass.toggleTimers(false);
            result2 = pass.run();
            pass.toggleTimers(false);
            job.setRunningPass(null);
            Report.should_report.pop();
            this.currentJob = oldCurrentJob;
            if (oldPass != null) {
                oldPass.toggleTimers(true);
            }
            if (this.getOptions().print_ast.contains(pass.name())) {
                System.err.println("----------------------------------------------------------------");
                System.err.println("Pretty-printing AST for " + job + " after " + pass.name());
                PrettyPrinter pp = new PrettyPrinter();
                pp.printAst(job.ast(), new CodeWriter(System.err, 78));
            }
            if (this.getOptions().dump_ast.contains(pass.name())) {
                System.err.println("----------------------------------------------------------------");
                System.err.println("Dumping AST for " + job + " after " + pass.name());
                NodeVisitor dumper = new DumpAst(new CodeWriter(System.err, 78));
                dumper = dumper.begin();
                job.ast().visit(dumper);
                dumper.finish();
            }
        }
        Stats stats = this.getStats();
        stats.accumPassTimes(pass.id(), pass.inclusiveTime(), pass.exclusiveTime());
        if (Report.should_report("time", 2)) {
            Report.report(2, "Finished " + pass + " status=" + AbstractExtensionInfo.str(result2) + " inclusive_time=" + pass.inclusiveTime() + " exclusive_time=" + pass.exclusiveTime());
        } else if (Report.should_report("frontend", 1)) {
            Report.report(1, "Finished " + pass + " status=" + AbstractExtensionInfo.str(result2));
        }
        job.finishPass(pass, result2);
    }

    protected void enforceInvariants(Job job, Pass pass) throws CyclicDependencyException {
        SourceJob srcJob = job.sourceJob();
        if (srcJob == null) {
            return;
        }
        BarrierPass lastBarrier = srcJob.lastBarrier();
        if (lastBarrier != null) {
            ArrayList allDependentSrcs = new ArrayList(srcJob.dependencies());
            Iterator i = allDependentSrcs.iterator();
            while (i.hasNext()) {
                Source s2 = (Source)i.next();
                Object o = this.jobs.get(s2);
                if (o == COMPLETED_JOB) continue;
                if (o == null) {
                    throw new InternalCompilerError("Unknown source " + s2);
                }
                SourceJob sj = (SourceJob)o;
                if (!sj.pending(lastBarrier.id())) continue;
                if (Report.should_report("frontend", 3)) {
                    Report.report(3, "Running " + sj + " to " + lastBarrier.id() + " for " + srcJob);
                }
                this.runToPass((Job)sj, lastBarrier.id());
            }
        }
        if (pass instanceof GlobalBarrierPass) {
            LinkedList barrierWorklist = new LinkedList(this.jobs.values());
            block1: while (!barrierWorklist.isEmpty()) {
                SourceJob sj;
                Object o = barrierWorklist.removeFirst();
                if (o == COMPLETED_JOB || (sj = (SourceJob)o).completed(pass.id()) || sj.nextPass() == sj.passByID(pass.id())) continue;
                Pass beforeGlobal = sj.getPreviousTo(pass.id());
                if (Report.should_report("frontend", 3)) {
                    Report.report(3, "Running " + sj + " to " + beforeGlobal.id() + " for " + srcJob);
                }
                while (!sj.pendingPasses().isEmpty()) {
                    Pass p = (Pass)sj.pendingPasses().get(0);
                    this.runPass(sj, p);
                    if (p != beforeGlobal) continue;
                    continue block1;
                }
            }
        }
    }

    private static String str(boolean okay) {
        if (okay) {
            return "done";
        }
        return "failed";
    }

    public String[] fileExtensions() {
        String[] sx;
        String[] stringArray = sx = this.getOptions() == null ? null : this.getOptions().source_ext;
        if (sx == null) {
            sx = this.defaultFileExtensions();
        }
        if (sx.length == 0) {
            return this.defaultFileExtensions();
        }
        return sx;
    }

    public String[] defaultFileExtensions() {
        String ext = this.defaultFileExtension();
        return new String[]{ext};
    }

    public SourceLoader sourceLoader() {
        if (this.source_loader == null) {
            this.source_loader = new SourceLoader(this, this.getOptions().source_path);
        }
        return this.source_loader;
    }

    public TargetFactory targetFactory() {
        if (this.target_factory == null) {
            this.target_factory = new TargetFactory(this.getOptions().output_directory, this.getOptions().output_ext, this.getOptions().output_stdout);
        }
        return this.target_factory;
    }

    protected abstract TypeSystem createTypeSystem();

    public TypeSystem typeSystem() {
        if (this.ts == null) {
            this.ts = this.createTypeSystem();
        }
        return this.ts;
    }

    protected abstract NodeFactory createNodeFactory();

    public NodeFactory nodeFactory() {
        if (this.nf == null) {
            this.nf = this.createNodeFactory();
        }
        return this.nf;
    }

    public JobExt jobExt() {
        return null;
    }

    public void addDependencyToCurrentJob(Source s2) {
        if (s2 == null) {
            return;
        }
        if (this.currentJob != null) {
            Object o = this.jobs.get(s2);
            if (o != COMPLETED_JOB) {
                if (Report.should_report("frontend", 2)) {
                    Report.report(2, "Adding dependency from " + this.currentJob.source() + " to " + s2);
                }
                this.currentJob.sourceJob().addDependency(s2);
            }
        } else {
            throw new InternalCompilerError("No current job!");
        }
    }

    public SourceJob addJob(Source source) {
        return this.addJob(source, null);
    }

    public SourceJob addJob(Source source, Node ast) {
        Object o = this.jobs.get(source);
        SourceJob job = null;
        if (o == COMPLETED_JOB) {
            return null;
        }
        if (o == null) {
            job = this.createSourceJob(source, ast);
            this.jobs.put(source, job);
            this.worklist.addLast(job);
            if (Report.should_report("frontend", 3)) {
                Report.report(3, "Adding job for " + source + " at the " + "request of job " + this.currentJob);
            }
        } else {
            job = (SourceJob)o;
        }
        if (this.currentJob instanceof SourceJob) {
            ((SourceJob)this.currentJob).addDependency(source);
        }
        return job;
    }

    protected SourceJob createSourceJob(Source source, Node ast) {
        return new SourceJob(this, this.jobExt(), source, ast);
    }

    protected Job createJob(Node ast, Context context, Job outer, Pass.ID begin, Pass.ID end) {
        return new InnerJob(this, this.jobExt(), ast, context, outer, begin, end);
    }

    public Job spawnJob(Context c, Node ast, Job outerJob, Pass.ID begin, Pass.ID end) {
        Job j = this.createJob(ast, c, outerJob, begin, end);
        if (Report.should_report("frontend", 1)) {
            Report.report(1, this + " spawning " + j);
        }
        this.runAllPasses(j);
        return j;
    }

    public abstract Parser parser(Reader var1, FileSource var2, ErrorQueue var3);

    public void replacePass(List passes, Pass.ID id, List newPasses) {
        ListIterator i = passes.listIterator();
        while (i.hasNext()) {
            Pass p = (Pass)i.next();
            if (p.id() != id) continue;
            if (p instanceof BarrierPass) {
                throw new InternalCompilerError("Cannot replace a barrier pass.");
            }
            i.remove();
            Iterator j = newPasses.iterator();
            while (j.hasNext()) {
                i.add(j.next());
            }
            return;
        }
        throw new InternalCompilerError("Pass " + id + " not found.");
    }

    public void removePass(List passes, Pass.ID id) {
        ListIterator i = passes.listIterator();
        while (i.hasNext()) {
            Pass p = (Pass)i.next();
            if (p.id() != id) continue;
            if (p instanceof BarrierPass) {
                throw new InternalCompilerError("Cannot remove a barrier pass.");
            }
            i.remove();
            return;
        }
        throw new InternalCompilerError("Pass " + id + " not found.");
    }

    public void beforePass(List passes, Pass.ID id, List newPasses) {
        ListIterator i = passes.listIterator();
        while (i.hasNext()) {
            Pass p = (Pass)i.next();
            if (p.id() != id) continue;
            i.previous();
            Iterator j = newPasses.iterator();
            while (j.hasNext()) {
                i.add(j.next());
            }
            return;
        }
        throw new InternalCompilerError("Pass " + id + " not found.");
    }

    public void afterPass(List passes, Pass.ID id, List newPasses) {
        ListIterator i = passes.listIterator();
        while (i.hasNext()) {
            Pass p = (Pass)i.next();
            if (p.id() != id) continue;
            Iterator j = newPasses.iterator();
            while (j.hasNext()) {
                i.add(j.next());
            }
            return;
        }
        throw new InternalCompilerError("Pass " + id + " not found.");
    }

    public void replacePass(List passes, Pass.ID id, Pass pass) {
        this.replacePass(passes, id, Collections.singletonList(pass));
    }

    public void beforePass(List passes, Pass.ID id, Pass pass) {
        this.beforePass(passes, id, Collections.singletonList(pass));
    }

    public void afterPass(List passes, Pass.ID id, Pass pass) {
        this.afterPass(passes, id, Collections.singletonList(pass));
    }

    public abstract List passes(Job var1);

    public List passes(Job job, Pass.ID begin, Pass.ID end) {
        List l = this.passes(job);
        Pass p = null;
        Iterator i = l.iterator();
        while (i.hasNext() && begin != (p = (Pass)i.next()).id()) {
            if (p instanceof BarrierPass) continue;
            i.remove();
        }
        while (p.id() != end && i.hasNext()) {
            p = (Pass)i.next();
        }
        while (i.hasNext()) {
            p = (Pass)i.next();
            i.remove();
        }
        return l;
    }

    public String toString() {
        return this.getClass().getName() + " worklist=" + this.worklist;
    }

    public ClassFile createClassFile(File classFileSource, byte[] code) {
        return new ClassFile(classFileSource, code, this);
    }
}

