/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.ast;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Node;
import polyglot.ast.StringLit;
import polyglot.ext.jl.ast.Lit_c;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.StringUtil;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class StringLit_c
extends Lit_c
implements StringLit {
    protected String value;
    protected int MAX_LENGTH = 60;

    public StringLit_c(Position pos, String value2) {
        super(pos);
        this.value = value2;
    }

    public String value() {
        return this.value;
    }

    public StringLit value(String value2) {
        StringLit_c n = (StringLit_c)this.copy();
        n.value = value2;
        return n;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        return this.type(tc.typeSystem().String());
    }

    public String toString() {
        if (StringUtil.unicodeEscape(this.value).length() > 11) {
            return "\"" + StringUtil.unicodeEscape(this.value).substring(0, 8) + "...\"";
        }
        return "\"" + StringUtil.unicodeEscape(this.value) + "\"";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        String s2;
        List l = this.breakupString();
        if (l.size() > 1) {
            w.write("(");
        }
        Iterator i = l.iterator();
        while (i.hasNext()) {
            s2 = (String)i.next();
            w.begin(0);
        }
        i = l.iterator();
        while (i.hasNext()) {
            s2 = (String)i.next();
            w.write("\"");
            w.write(StringUtil.escape(s2));
            w.write("\"");
            w.end();
            if (!i.hasNext()) continue;
            w.write(" +");
            w.allowBreak(0, " ");
        }
        if (l.size() > 1) {
            w.write(")");
        }
    }

    public List breakupString() {
        LinkedList<String> result2 = new LinkedList<String>();
        int n = this.value.length();
        int i = 0;
        while (i < n) {
            char c;
            int k;
            int j;
            int len = 0;
            for (j = i; j < n && len + (k = StringUtil.unicodeEscape(c = this.value.charAt(j)).length()) <= this.MAX_LENGTH; ++j) {
                len += k;
            }
            result2.add(this.value.substring(i, j));
            i = j;
        }
        if (result2.isEmpty()) {
            if (!this.value.equals("")) {
                throw new InternalCompilerError("breakupString failed");
            }
            result2.add(this.value);
        }
        return result2;
    }

    public Object constantValue() {
        return this.value;
    }
}

