/*
 * Decompiled with CFR 0.152.
 */
package org.k33nteam.jade.solver;

class DataObject
implements Cloneable {
    String key;
    DataObject data;
    DataObject father;
    int status = 3;
    boolean clear = true;

    public static DataObject getRecurTail(DataObject object) {
        while (!object.clear) {
            object = object.data;
        }
        return object;
    }

    public static DataObject getRecurSecondTail(DataObject object) {
        DataObject second = null;
        while (!object.clear) {
            second = object;
            object = object.data;
        }
        return second;
    }

    public static DataObject getRecurThirdTail(DataObject object) {
        DataObject tail = DataObject.getRecurTail(object);
        return tail.father.father;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getKey() {
        return this.key;
    }

    public void setKeyAndData(String key2, DataObject data) {
        this.key = key2;
        this.data = data;
        this.clear = false;
        data.father = this;
    }

    public boolean isClear() {
        return this.clear;
    }

    public DataObject getData() {
        return this.data;
    }

    private DataObject() {
    }

    public static DataObject newInstance() {
        return new DataObject();
    }

    protected DataObject clone() {
        DataObject object = new DataObject();
        if (!this.clear) {
            object.key = this.key;
            object.data = this.data.clone();
            object.status = this.status;
            object.clear = false;
            object.data.father = object;
            object.father = this.father;
        }
        return object;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[ ");
        builder.append(this.key);
        builder.append(" : ");
        builder.append(this.data == null ? "null" : this.data.toString());
        String statusString = "";
        switch (this.status) {
            case 0: {
                statusString = "unknown";
                break;
            }
            case 1: {
                statusString = "empty";
                break;
            }
            case 2: {
                statusString = "non-empty";
                break;
            }
            case 3: {
                statusString = "full";
            }
        }
        builder.append(", ").append(statusString);
        builder.append(" ]");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataObject)) {
            return false;
        }
        DataObject rhs = (DataObject)obj;
        if (this.key == null && rhs.key == null) {
            return true;
        }
        if (this.key != null && rhs.key != null) {
            return this.key.equals(rhs.key) && this.data.equals(rhs.data);
        }
        return false;
    }
}

