/*
 * Decompiled with CFR 0.152.
 */
package org.k33nteam.jade.propagation.track;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.k33nteam.jade.bean.VulnResult;
import org.k33nteam.jade.propagation.track.IAPIVulnManager;
import soot.SootMethod;
import soot.Value;
import soot.jimple.Stmt;
import soot.toolkits.scalar.Pair;

public class APIVulnManager
implements IAPIVulnManager {
    private Map<String, Integer> mappings = new HashMap<String, Integer>();
    private Map<String, String> descs = new HashMap<String, String>();
    private List<Pair<SootMethod, Pair<Stmt, String>>> results = new ArrayList<Pair<SootMethod, Pair<Stmt, String>>>();
    private GroovyObject groovyObject;
    private static final boolean DEBUG = false;

    public APIVulnManager(String groovyPath) {
        this.initFromGroovy(groovyPath);
    }

    private void initFromGroovy(String groovyPath) {
        ClassLoader parent = APIVulnManager.class.getClassLoader();
        GroovyClassLoader loader = new GroovyClassLoader(parent);
        Class groovyClass = null;
        try {
            groovyClass = loader.parseClass(new File(groovyPath));
        }
        catch (IOException | CompilationFailedException e) {
            e.printStackTrace();
        }
        try {
            this.groovyObject = (GroovyObject)groovyClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        this.mappings = (Map)this.groovyObject.invokeMethod("getMappings", null);
        this.descs = (Map)this.groovyObject.invokeMethod("getDescMappings", null);
        try {
            loader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getDescBySig(String funcsig) {
        return this.descs.get(funcsig);
    }

    public boolean evaluateResult(String sig, String value2) {
        String[] args = new String[]{sig, value2};
        return (Boolean)this.groovyObject.invokeMethod("evaluate", args);
    }

    @Override
    public List<VulnResult> getAnalysisResult() {
        ArrayList<VulnResult> ret = new ArrayList<VulnResult>();
        for (int i = 0; i < this.results.size(); ++i) {
            String value2;
            String funcSig = this.results.get(i).getO2().getO1().getInvokeExpr().getMethod().getSignature();
            if (!this.evaluateResult(funcSig, value2 = this.results.get(i).getO2().getO2())) continue;
            VulnResult result2 = VulnResult.toConstantAPIVulnResult(this.results.get(i).getO2().getO1(), this.results.get(i).getO1(), this.descs.get(funcSig), "", 0.3f);
            ret.add(result2);
        }
        return ret;
    }

    @Override
    public Value getVulnParamAsSource(Stmt stmt) {
        String name = stmt.getInvokeExpr().getMethod().getSignature();
        if (this.mappings.containsKey(name)) {
            return stmt.getInvokeExpr().getArg(this.mappings.get(name));
        }
        return null;
    }

    @Override
    public void isParamVulnAndStore(SootMethod originMethod, Stmt originStmt, Value reachedValue) {
        System.out.println(originStmt);
        String funcSig = originStmt.getInvokeExpr().getMethod().getSignature();
        String valueString2 = reachedValue.toString();
        if (this.evaluateResult(funcSig, valueString2)) {
            this.results.add(new Pair<SootMethod, Pair<Stmt, String>>(originMethod, new Pair<Stmt, String>(originStmt, valueString2)));
        }
    }
}

