/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import java.text.DecimalFormat;

public class NumberUtils {
    private static final int canonicalFloatNaN = Float.floatToRawIntBits(Float.NaN);
    private static final int maxFloat = Float.floatToRawIntBits(Float.MAX_VALUE);
    private static final int piFloat = Float.floatToRawIntBits((float)Math.PI);
    private static final int eFloat = Float.floatToRawIntBits((float)Math.E);
    private static final long canonicalDoubleNaN = Double.doubleToRawLongBits(Double.NaN);
    private static final long maxDouble = Double.doubleToLongBits(Double.MAX_VALUE);
    private static final long piDouble = Double.doubleToLongBits(Math.PI);
    private static final long eDouble = Double.doubleToLongBits(Math.E);
    private static final DecimalFormat format = new DecimalFormat("0.####################E0");

    public static boolean isLikelyFloat(int value2) {
        if (value2 == canonicalFloatNaN || value2 == maxFloat || value2 == piFloat || value2 == eFloat) {
            return true;
        }
        if (value2 == Integer.MAX_VALUE || value2 == Integer.MIN_VALUE) {
            return false;
        }
        int packageId = value2 >> 24;
        int resourceType = value2 >> 16 & 0xFF;
        int resourceId = value2 & 0xFFFF;
        if ((packageId == 127 || packageId == 1) && resourceType < 31 && resourceId < 4095) {
            return false;
        }
        float floatValue = Float.intBitsToFloat(value2);
        if (Float.isNaN(floatValue)) {
            return false;
        }
        String asInt = format.format(value2);
        String asFloat = format.format(floatValue);
        int decimalPoint = asFloat.indexOf(46);
        int exponent = asFloat.indexOf("E");
        int zeros = asFloat.indexOf("000");
        if (zeros > decimalPoint && zeros < exponent) {
            asFloat = asFloat.substring(0, zeros) + asFloat.substring(exponent);
        } else {
            int nines = asFloat.indexOf("999");
            if (nines > decimalPoint && nines < exponent) {
                asFloat = asFloat.substring(0, nines) + asFloat.substring(exponent);
            }
        }
        return asFloat.length() < asInt.length();
    }

    public static boolean isLikelyDouble(long value2) {
        if (value2 == canonicalDoubleNaN || value2 == maxDouble || value2 == piDouble || value2 == eDouble) {
            return true;
        }
        if (value2 == Long.MAX_VALUE || value2 == Long.MIN_VALUE) {
            return false;
        }
        double doubleValue = Double.longBitsToDouble(value2);
        if (Double.isNaN(doubleValue)) {
            return false;
        }
        String asLong = format.format(value2);
        String asDouble = format.format(doubleValue);
        int decimalPoint = asDouble.indexOf(46);
        int exponent = asDouble.indexOf("E");
        int zeros = asDouble.indexOf("000");
        if (zeros > decimalPoint && zeros < exponent) {
            asDouble = asDouble.substring(0, zeros) + asDouble.substring(exponent);
        } else {
            int nines = asDouble.indexOf("999");
            if (nines > decimalPoint && nines < exponent) {
                asDouble = asDouble.substring(0, nines) + asDouble.substring(exponent);
            }
        }
        return asDouble.length() < asLong.length();
    }
}

