/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jf.dexlib2.writer.OffsetSection;
import org.jf.util.ExceptionWithContext;

public abstract class BaseOffsetPool<Key>
implements OffsetSection<Key> {
    @Nonnull
    protected final Map<Key, Integer> internedItems = Maps.newHashMap();

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends Key, Integer>> getItems() {
        return this.internedItems.entrySet();
    }

    @Override
    public int getItemOffset(@Nonnull Key key2) {
        Integer offset = this.internedItems.get(key2);
        if (offset == null) {
            throw new ExceptionWithContext("Item not found.: %s", this.getItemString(key2));
        }
        return offset;
    }

    @Nonnull
    protected String getItemString(@Nonnull Key key2) {
        return key2.toString();
    }
}

