/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.jf.dexlib2.base.reference.BaseMethodReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.writer.MethodSection;
import org.jf.dexlib2.writer.builder.BuilderContext;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.BuilderMethodReference;
import org.jf.dexlib2.writer.builder.BuilderProtoReference;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;

class BuilderMethodPool
implements MethodSection<BuilderStringReference, BuilderTypeReference, BuilderProtoReference, BuilderMethodReference, BuilderMethod> {
    @Nonnull
    private final BuilderContext context;
    @Nonnull
    private final ConcurrentMap<MethodReference, BuilderMethodReference> internedItems = Maps.newConcurrentMap();

    BuilderMethodPool(@Nonnull BuilderContext context) {
        this.context = context;
    }

    @Nonnull
    public BuilderMethodReference internMethod(@Nonnull MethodReference methodReference) {
        BuilderMethodReference ret = (BuilderMethodReference)this.internedItems.get(methodReference);
        if (ret != null) {
            return ret;
        }
        BuilderMethodReference dexPoolMethodReference = new BuilderMethodReference(this.context.typePool.internType(methodReference.getDefiningClass()), this.context.stringPool.internString(methodReference.getName()), this.context.protoPool.internProto(methodReference));
        ret = this.internedItems.putIfAbsent(dexPoolMethodReference, dexPoolMethodReference);
        return ret == null ? dexPoolMethodReference : ret;
    }

    @Nonnull
    public BuilderMethodReference internMethod(@Nonnull String definingClass, @Nonnull String name, @Nonnull List<? extends CharSequence> parameters, @Nonnull String returnType) {
        return this.internMethod(new MethodKey(definingClass, name, parameters, returnType));
    }

    @Override
    @Nonnull
    public BuilderTypeReference getDefiningClass(@Nonnull BuilderMethodReference key2) {
        return key2.definingClass;
    }

    @Override
    @Nonnull
    public BuilderProtoReference getPrototype(@Nonnull BuilderMethodReference key2) {
        return key2.proto;
    }

    @Override
    @Nonnull
    public BuilderProtoReference getPrototype(@Nonnull BuilderMethod builderMethod) {
        return builderMethod.methodReference.proto;
    }

    @Override
    @Nonnull
    public BuilderStringReference getName(@Nonnull BuilderMethodReference key2) {
        return key2.name;
    }

    @Override
    public int getMethodIndex(@Nonnull BuilderMethod builderMethod) {
        return builderMethod.methodReference.index;
    }

    @Override
    public int getItemIndex(@Nonnull BuilderMethodReference key2) {
        return key2.index;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderMethodReference, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderMethodReference>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderMethodReference key2) {
                return key2.index;
            }

            @Override
            protected int setValue(@Nonnull BuilderMethodReference key2, int value2) {
                int prev = key2.index;
                key2.index = value2;
                return prev;
            }
        };
    }

    private static class MethodKey
    extends BaseMethodReference
    implements MethodReference {
        @Nonnull
        private final String definingClass;
        @Nonnull
        private final String name;
        @Nonnull
        private final List<? extends CharSequence> parameterTypes;
        @Nonnull
        private final String returnType;

        public MethodKey(@Nonnull String definingClass, @Nonnull String name, @Nonnull List<? extends CharSequence> parameterTypes, @Nonnull String returnType) {
            this.definingClass = definingClass;
            this.name = name;
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
        }

        @Override
        @Nonnull
        public String getDefiningClass() {
            return this.definingClass;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        @Nonnull
        public List<? extends CharSequence> getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        @Nonnull
        public String getReturnType() {
            return this.returnType;
        }
    }
}

