/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.ClassProto;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.util.ConsoleUtil;
import org.jf.util.SparseArray;

public class DumpFields {
    private static final Options options = new Options();

    public static void main(String[] args) {
        CommandLine commandLine;
        PosixParser parser2 = new PosixParser();
        try {
            commandLine = parser2.parse(options, args);
        }
        catch (ParseException ex) {
            DumpFields.usage();
            return;
        }
        String[] remainingArgs = commandLine.getArgs();
        Option[] parsedOptions = commandLine.getOptions();
        ArrayList<String> bootClassPathDirs = Lists.newArrayList();
        String outFile = "fields.txt";
        int apiLevel = 15;
        boolean experimental2 = false;
        block10: for (int i = 0; i < parsedOptions.length; ++i) {
            Option option = parsedOptions[i];
            String opt2 = option.getOpt();
            switch (opt2.charAt(0)) {
                case 'd': {
                    bootClassPathDirs.add(option.getValue());
                    continue block10;
                }
                case 'o': {
                    outFile = option.getValue();
                    continue block10;
                }
                case 'a': {
                    apiLevel = Integer.parseInt(commandLine.getOptionValue("a"));
                    continue block10;
                }
                case 'X': {
                    experimental2 = true;
                    continue block10;
                }
                default: {
                    assert (false);
                    continue block10;
                }
            }
        }
        if (remainingArgs.length != 1) {
            DumpFields.usage();
            return;
        }
        String inputDexFileName = remainingArgs[0];
        File dexFileFile = new File(inputDexFileName);
        if (!dexFileFile.exists()) {
            System.err.println("Can't find the file " + inputDexFileName);
            System.exit(1);
        }
        try {
            DexBackedDexFile dexFile = DexFileFactory.loadDexFile(dexFileFile, apiLevel, experimental2);
            Iterable<String> bootClassPaths = Splitter.on(":").split("core.jar:ext.jar:framework.jar:android.policy.jar:services.jar");
            ClassPath classPath = ClassPath.fromClassPath(bootClassPathDirs, bootClassPaths, dexFile, apiLevel, experimental2);
            FileOutputStream outStream = new FileOutputStream(outFile);
            for (ClassDef classDef : dexFile.getClasses()) {
                ClassProto classProto = (ClassProto)classPath.getClass(classDef);
                SparseArray<FieldReference> fields = classProto.getInstanceFields();
                String className = "Class " + classDef.getType() + " : " + fields.size() + " instance fields\n";
                outStream.write(className.getBytes());
                for (int i = 0; i < fields.size(); ++i) {
                    String field2 = fields.keyAt(i) + ":" + fields.valueAt(i).getType() + " " + fields.valueAt(i).getName() + "\n";
                    outStream.write(field2.getBytes());
                }
                outStream.write("\n".getBytes());
            }
            outStream.close();
        }
        catch (IOException ex) {
            System.out.println("IOException thrown when trying to open a dex file or write out vtables: " + ex);
        }
    }

    private static void usage() {
        int consoleWidth = ConsoleUtil.getConsoleWidth();
        if (consoleWidth <= 0) {
            consoleWidth = 80;
        }
        System.out.println("java -cp baksmali.jar org.jf.dexlib2.analysis.DumpFields -d path/to/framework/jar/files <dex-file>");
    }

    private static void buildOptions() {
        OptionBuilder.withLongOpt((String)"bootclasspath-dir");
        OptionBuilder.withDescription((String)"the base folder to look for the bootclasspath files in. Defaults to the current directory");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"DIR");
        Option classPathDirOption = OptionBuilder.create((String)"d");
        OptionBuilder.withLongOpt((String)"out-file");
        OptionBuilder.withDescription((String)"output file");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        Option outputFileOption = OptionBuilder.create((String)"o");
        OptionBuilder.withLongOpt((String)"api-level");
        OptionBuilder.withDescription((String)"The numeric api-level of the file being disassembled. If not specified, it defaults to 15 (ICS).");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"API_LEVEL");
        Option apiLevelOption = OptionBuilder.create((String)"a");
        OptionBuilder.withLongOpt((String)"experimental");
        OptionBuilder.withDescription((String)"Enable dumping experimental opcodes, that aren't necessarily supported by the android runtime yet.");
        Option experimentalOption = OptionBuilder.create((String)"X");
        options.addOption(classPathDirOption);
        options.addOption(outputFileOption);
        options.addOption(apiLevelOption);
        options.addOption(experimentalOption);
    }

    static {
        DumpFields.buildOptions();
    }
}

