/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedOdexFile;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.writer.pool.DexPool;
import org.jf.util.ExceptionWithContext;

public final class DexFileFactory {
    @Nonnull
    public static DexBackedDexFile loadDexFile(String path, int api, boolean experimental2) throws IOException {
        return DexFileFactory.loadDexFile(new File(path), "classes.dex", new Opcodes(api, experimental2));
    }

    @Nonnull
    public static DexBackedDexFile loadDexFile(File dexFile, int api, boolean experimental2) throws IOException {
        return DexFileFactory.loadDexFile(dexFile, "classes.dex", new Opcodes(api, experimental2));
    }

    @Nonnull
    public static DexBackedDexFile loadDexFile(File dexFile, String dexEntry, int api, boolean experimental2) throws IOException {
        return DexFileFactory.loadDexFile(dexFile, dexEntry, new Opcodes(api, experimental2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nonnull
    public static DexBackedDexFile loadDexFile(File dexFile, String dexEntry, @Nonnull Opcodes opcodes) throws IOException {
        block24: {
            DexBackedDexFile fileLength2222;
            ZipFile zipFile = null;
            boolean isZipFile = false;
            try {
                zipFile = new ZipFile(dexFile);
                isZipFile = true;
                ZipEntry zipEntry = zipFile.getEntry(dexEntry);
                if (zipEntry == null) {
                    throw new NoClassesDexException("zip file %s does not contain a classes.dex file", dexFile.getName());
                }
                long fileLength2222 = zipEntry.getSize();
                if (fileLength2222 < 40L) {
                    throw new ExceptionWithContext("The " + dexEntry + " file in %s is too small to be a valid dex file", dexFile.getName());
                }
                if (fileLength2222 > Integer.MAX_VALUE) {
                    throw new ExceptionWithContext("The " + dexEntry + " file in %s is too large to read in", dexFile.getName());
                }
                byte[] dexBytes = new byte[(int)fileLength2222];
                ByteStreams.readFully(zipFile.getInputStream(zipEntry), dexBytes);
                DexBackedDexFile dexBackedDexFile = new DexBackedDexFile(opcodes, dexBytes);
                return dexBackedDexFile;
            }
            catch (IOException ex) {
                if (isZipFile) {
                    throw ex;
                }
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException ex) {}
                }
            }
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(dexFile));
            try {
                fileLength2222 = DexBackedDexFile.fromInputStream(opcodes, inputStream);
            }
            catch (DexBackedDexFile.NotADexFile ex2222) {
                DexBackedOdexFile ex2222 = DexBackedOdexFile.fromInputStream(opcodes, inputStream);
                ((InputStream)inputStream).close();
                return ex2222;
                {
                    catch (DexBackedOdexFile.NotAnOdexFile ex3) {
                        ((InputStream)inputStream).close();
                        break block24;
                        catch (Throwable throwable) {
                            ((InputStream)inputStream).close();
                            throw throwable;
                        }
                    }
                }
            }
            ((InputStream)inputStream).close();
            return fileLength2222;
        }
        throw new ExceptionWithContext("%s is not an apk, dex file or odex file.", dexFile.getPath());
    }

    public static void writeDexFile(String path, DexFile dexFile) throws IOException {
        DexPool.writeTo(path, dexFile);
    }

    private DexFileFactory() {
    }

    public static class NoClassesDexException
    extends ExceptionWithContext {
        public NoClassesDexException(Throwable cause) {
            super(cause);
        }

        public NoClassesDexException(Throwable cause, String message, Object ... formatArgs) {
            super(cause, message, formatArgs);
        }

        public NoClassesDexException(String message, Object ... formatArgs) {
            super(message, formatArgs);
        }
    }
}

