/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.xml;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.util.xml.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlHelper {
    public static void write(Writer out, Document dom) throws Exception {
        new DOMWriter(out).setPrettyprint(true).print(dom);
    }

    public static Iterator getChildrenByTagName(Element element2, String tagName) {
        if (element2 == null) {
            return null;
        }
        NodeList children2 = element2.getChildNodes();
        ArrayList<Node> goodChildren = new ArrayList<Node>();
        for (int i = 0; i < children2.getLength(); ++i) {
            Node currentChild = children2.item(i);
            if (currentChild.getNodeType() != 1 || !((Element)currentChild).getTagName().equals(tagName)) continue;
            goodChildren.add(currentChild);
        }
        return goodChildren.iterator();
    }

    public static Element getUniqueChild(Element element2, String tagName) throws Exception {
        Iterator goodChildren = XmlHelper.getChildrenByTagName(element2, tagName);
        if (goodChildren != null && goodChildren.hasNext()) {
            Element child = (Element)goodChildren.next();
            if (goodChildren.hasNext()) {
                throw new Exception("expected only one " + tagName + " tag");
            }
            return child;
        }
        throw new Exception("expected one " + tagName + " tag");
    }

    public static Element getOptionalChild(Element element2, String tagName) throws Exception {
        return XmlHelper.getOptionalChild(element2, tagName, null);
    }

    public static Element getOptionalChild(Element element2, String tagName, Element defaultElement) throws Exception {
        Iterator goodChildren = XmlHelper.getChildrenByTagName(element2, tagName);
        if (goodChildren != null && goodChildren.hasNext()) {
            Element child = (Element)goodChildren.next();
            if (goodChildren.hasNext()) {
                throw new Exception("expected only one " + tagName + " tag");
            }
            return child;
        }
        return defaultElement;
    }

    public static String getElementContent(Element element2) throws Exception {
        return XmlHelper.getElementContent(element2, null);
    }

    public static String getElementContent(Element element2, String defaultStr) throws Exception {
        if (element2 == null) {
            return defaultStr;
        }
        NodeList children2 = element2.getChildNodes();
        String result2 = "";
        for (int i = 0; i < children2.getLength(); ++i) {
            if (children2.item(i).getNodeType() == 3 || children2.item(i).getNodeType() == 4) {
                result2 = result2 + children2.item(i).getNodeValue();
                continue;
            }
            if (children2.item(i).getNodeType() != 8) continue;
        }
        return result2.trim();
    }

    public static String getUniqueChildContent(Element element2, String tagName) throws Exception {
        return XmlHelper.getElementContent(XmlHelper.getUniqueChild(element2, tagName));
    }

    public static String getOptionalChildContent(Element element2, String tagName) throws Exception {
        return XmlHelper.getElementContent(XmlHelper.getOptionalChild(element2, tagName));
    }

    public static boolean getOptionalChildBooleanContent(Element element2, String name) throws Exception {
        Element child = XmlHelper.getOptionalChild(element2, name);
        if (child != null) {
            String value2 = XmlHelper.getElementContent(child).toLowerCase();
            return value2.equals("true") || value2.equals("yes");
        }
        return false;
    }
}

